/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.collector.impl;

import com.carrotsearch.hppc.LongHashSet;
import com.carrotsearch.hppc.LongObjectHashMap;
import com.carrotsearch.hppc.cursors.LongObjectCursor;
import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.CollectorManager;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.SimpleCollector;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.BaseTermsCollector;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.CollectorKey;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.TermCollectorSegmentValue;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.LongMultiValues;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.LongMultiValuesSource;

public class NumericTermsCollector
extends SimpleCollector
implements BaseTermsCollector {
    private final LongHashSet uniqueLeafIndicesForDocument = new LongHashSet();
    private final LongMultiValuesSource valuesSource;
    private final LongObjectHashMap<TermCollectorSegmentValue> segmentValues = new LongObjectHashMap();
    private final CollectorKey<?, ?>[] keys;
    private final CollectorManager<Collector, ?>[] managers;
    private LongMultiValues values;
    private LeafReaderContext leafReaderContext;

    public NumericTermsCollector(LongMultiValuesSource valuesSource, CollectorKey<?, ?>[] keys, CollectorManager<Collector, ?>[] managers) {
        this.valuesSource = valuesSource;
        this.keys = keys;
        this.managers = managers;
    }

    public void collect(int doc) throws IOException {
        if (this.values.advanceExact(doc)) {
            this.uniqueLeafIndicesForDocument.clear();
            while (this.values.hasNextValue()) {
                long value = this.values.nextValue();
                if (!this.uniqueLeafIndicesForDocument.add(value)) continue;
                TermCollectorSegmentValue segmentValue = (TermCollectorSegmentValue)this.segmentValues.get(value);
                if (segmentValue == null) {
                    segmentValue = new TermCollectorSegmentValue(this.managers, this.leafReaderContext);
                    this.segmentValues.put(value, (Object)segmentValue);
                }
                segmentValue.collect(doc);
            }
        }
    }

    public ScoreMode scoreMode() {
        return ScoreMode.COMPLETE_NO_SCORES;
    }

    protected void doSetNextReader(LeafReaderContext context) throws IOException {
        this.values = this.valuesSource.getValues(context);
        this.leafReaderContext = context;
        for (LongObjectCursor value : this.segmentValues) {
            ((TermCollectorSegmentValue)value.value).resetLeafCollectors(context);
        }
    }

    public void finish() {
        this.values = null;
    }

    @Override
    public CollectorKey<?, ?>[] keys() {
        return this.keys;
    }

    @Override
    public CollectorManager<Collector, ?>[] managers() {
        return this.managers;
    }

    LongObjectHashMap<TermCollectorSegmentValue> segmentValues() {
        return this.segmentValues;
    }
}

