/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.collector.impl;

import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.IntHashSet;
import com.carrotsearch.hppc.LongArrayList;
import com.carrotsearch.hppc.LongContainer;
import com.carrotsearch.hppc.LongIntHashMap;
import com.carrotsearch.hppc.cursors.IntCursor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.SimpleCollector;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.CollectorKey;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.LongMultiValues;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.LongMultiValuesSource;
import org.hibernate.search.backend.lucene.types.lowlevel.impl.EffectiveRange;

public class RangeCollector
extends SimpleCollector {
    private final LongMultiValuesSource valuesSource;
    private final long[] boundaries;
    private final IntArrayList[] countsPerBoundaries;
    private final Collector[][] collectors;
    private final CollectorKey<?, ?>[] keys;
    private final LeafCollector[][] leafCollectors;
    private LongMultiValues values;

    public RangeCollector(LongMultiValuesSource valuesSource, EffectiveRange[] ranges, Collector[][] collectors, CollectorKey<?, ?>[] keys) {
        int i;
        long prev;
        this.valuesSource = valuesSource;
        this.collectors = collectors;
        this.keys = keys;
        LongIntHashMap endsMap = new LongIntHashMap();
        endsMap.put(Long.MIN_VALUE, 1);
        endsMap.put(Long.MAX_VALUE, 2);
        for (EffectiveRange range : ranges) {
            long min = range.min();
            long max = range.max();
            int cur = endsMap.get(min);
            if (cur == 0) {
                endsMap.put(min, 1);
            } else {
                endsMap.put(min, cur | 1);
            }
            cur = endsMap.get(max);
            if (cur == 0) {
                endsMap.put(max, 2);
                continue;
            }
            endsMap.put(max, cur | 2);
        }
        LongArrayList endsList = new LongArrayList((LongContainer)endsMap.keys());
        Arrays.sort(endsList.buffer, 0, endsList.elementsCount);
        ArrayList<EffectiveRange> elementaryIntervals = new ArrayList<EffectiveRange>();
        int upto0 = 1;
        long v = endsList.get(0);
        if (endsMap.get(v) == 3) {
            elementaryIntervals.add(new EffectiveRange(v, v));
            prev = v + 1L;
        } else {
            prev = v;
        }
        while (upto0 < endsList.size()) {
            v = endsList.get(upto0);
            int flags = endsMap.get(v);
            if (flags == 3) {
                if (v > prev) {
                    elementaryIntervals.add(new EffectiveRange(prev, v - 1L));
                }
                elementaryIntervals.add(new EffectiveRange(v, v));
                prev = v + 1L;
            } else if (flags == 1) {
                if (v > prev) {
                    elementaryIntervals.add(new EffectiveRange(prev, v - 1L));
                }
                prev = v;
            } else {
                assert (flags == 2);
                elementaryIntervals.add(new EffectiveRange(prev, v));
                prev = v + 1L;
            }
            ++upto0;
        }
        this.boundaries = new long[elementaryIntervals.size()];
        this.countsPerBoundaries = new IntArrayList[this.boundaries.length];
        for (i = 0; i < this.boundaries.length; ++i) {
            IntArrayList list;
            EffectiveRange interval = (EffectiveRange)elementaryIntervals.get(i);
            this.boundaries[i] = interval.max();
            this.countsPerBoundaries[i] = list = new IntArrayList();
            for (int j = 0; j < ranges.length; ++j) {
                if (interval.min() < ranges[j].min() || interval.max() > ranges[j].max()) continue;
                list.add(j);
            }
        }
        this.leafCollectors = new LeafCollector[keys.length][];
        for (i = 0; i < this.leafCollectors.length; ++i) {
            this.leafCollectors[i] = new LeafCollector[ranges.length];
        }
    }

    private void processLeafWithIndex(int index, int doc) throws IOException {
        for (IntCursor cursor : this.countsPerBoundaries[index]) {
            for (int i = 0; i < this.keys.length; ++i) {
                this.leafCollectors[i][cursor.value].collect(doc);
            }
        }
    }

    private int findLeafIndex(long v) {
        int mid;
        int lo = 0;
        int hi = this.boundaries.length - 1;
        while (true) {
            if (v <= this.boundaries[mid = lo + hi >>> 1]) {
                if (mid == 0) {
                    return 0;
                }
                hi = mid - 1;
                continue;
            }
            if (v <= this.boundaries[mid + 1]) break;
            lo = mid + 1;
        }
        return mid + 1;
    }

    public void collect(int doc) throws IOException {
        if (this.values.advanceExact(doc)) {
            IntHashSet uniqueLeafIndicesForDocument = new IntHashSet();
            while (this.values.hasNextValue()) {
                int leafIndex = this.findLeafIndex(this.values.nextValue());
                if (!uniqueLeafIndicesForDocument.add(leafIndex)) continue;
                this.processLeafWithIndex(leafIndex, doc);
            }
        }
    }

    public Collector[][] collectors() {
        return this.collectors;
    }

    public ScoreMode scoreMode() {
        return ScoreMode.COMPLETE_NO_SCORES;
    }

    protected void doSetNextReader(LeafReaderContext context) throws IOException {
        this.values = this.valuesSource.getValues(context);
        for (int i = 0; i < this.collectors.length; ++i) {
            for (int j = 0; j < this.collectors[i].length; ++j) {
                this.leafCollectors[i][j] = this.collectors[i][j].getLeafCollector(context);
            }
        }
    }

    public void finish() throws IOException {
        this.values = null;
    }
}

