/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.collector.impl;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.CollectorManager;
import org.apache.lucene.search.LeafCollector;

class TermCollectorSegmentValue {
    final Collector[] collectors;
    final LeafCollector[] leafCollectors;
    long count = 0L;

    TermCollectorSegmentValue(CollectorManager<Collector, ?>[] managers, LeafReaderContext leafReaderContext) throws IOException {
        this.collectors = new Collector[managers.length];
        this.leafCollectors = new LeafCollector[managers.length];
        for (int i = 0; i < managers.length; ++i) {
            this.collectors[i] = managers[i].newCollector();
            this.leafCollectors[i] = this.collectors[i].getLeafCollector(leafReaderContext);
        }
    }

    void collect(int doc) throws IOException {
        ++this.count;
        for (LeafCollector collector : this.leafCollectors) {
            collector.collect(doc);
        }
    }

    void resetLeafCollectors(LeafReaderContext leafReaderContext) throws IOException {
        for (int i = 0; i < this.leafCollectors.length; ++i) {
            this.leafCollectors[i] = this.collectors[i].getLeafCollector(leafReaderContext);
        }
    }
}

