/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.collector.impl;

import com.carrotsearch.hppc.LongHashSet;
import com.carrotsearch.hppc.LongObjectHashMap;
import com.carrotsearch.hppc.cursors.LongObjectCursor;
import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.CollectorManager;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.SimpleCollector;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.BaseTermsCollector;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.CollectorKey;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.TermCollectorSegmentValue;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.TextMultiValues;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.TextMultiValuesSource;
import org.hibernate.search.backend.lucene.types.aggregation.impl.LongBucket;

public class TextTermsCollector
extends SimpleCollector
implements BaseTermsCollector {
    private final LongHashSet uniqueLeafIndicesForDocument = new LongHashSet();
    private final TextMultiValuesSource valuesSource;
    private final LongObjectHashMap<LongBucket> hashValues = new LongObjectHashMap();
    private final LongObjectHashMap<TermCollectorSegmentValue> segmentValues = new LongObjectHashMap();
    private final String field;
    private SortedSetDocValues sortedSetValues;
    private final CollectorKey<?, ?>[] keys;
    private final CollectorManager<Collector, ?>[] managers;
    private TextMultiValues values;
    private LeafReaderContext leafReaderContext;

    public TextTermsCollector(String field, TextMultiValuesSource valuesSource, CollectorKey<?, ?>[] keys, CollectorManager<Collector, ?>[] managers) {
        this.field = field;
        this.valuesSource = valuesSource;
        this.keys = keys;
        this.managers = managers;
    }

    public void collect(int doc) throws IOException {
        if (this.values.advanceExact(doc)) {
            this.uniqueLeafIndicesForDocument.clear();
            while (this.values.hasNextValue()) {
                long value = this.values.nextOrd();
                if (!this.uniqueLeafIndicesForDocument.add(value)) continue;
                TermCollectorSegmentValue segmentValue = (TermCollectorSegmentValue)this.segmentValues.get(value);
                if (segmentValue == null) {
                    segmentValue = new TermCollectorSegmentValue(this.managers, this.leafReaderContext);
                    this.segmentValues.put(value, (Object)segmentValue);
                }
                segmentValue.collect(doc);
            }
        }
    }

    @Override
    public CollectorKey<?, ?>[] keys() {
        return this.keys;
    }

    @Override
    public CollectorManager<Collector, ?>[] managers() {
        return this.managers;
    }

    LongObjectHashMap<LongBucket> segmentValues() {
        return this.hashValues;
    }

    public ScoreMode scoreMode() {
        return ScoreMode.COMPLETE_NO_SCORES;
    }

    protected void doSetNextReader(LeafReaderContext context) throws IOException {
        this.initRootSortedSetDocValues((IndexReaderContext)context);
        this.values = this.valuesSource.getValues(context);
        this.leafReaderContext = context;
    }

    public void finish() throws IOException {
        for (LongObjectCursor value : this.segmentValues) {
            long globalOrd = this.sortedSetValues.lookupTerm(this.values.lookupOrd(value.key));
            LongBucket bucket = (LongBucket)this.hashValues.get(globalOrd);
            if (bucket == null) {
                bucket = new LongBucket(globalOrd, ((TermCollectorSegmentValue)value.value).collectors, ((TermCollectorSegmentValue)value.value).count);
                this.hashValues.put(globalOrd, (Object)bucket);
                continue;
            }
            bucket.count += ((TermCollectorSegmentValue)value.value).count;
            for (int i = 0; i < bucket.collectors.length; ++i) {
                bucket.collectors[i].add(((TermCollectorSegmentValue)value.value).collectors[i]);
            }
        }
        this.values = null;
        this.segmentValues.clear();
    }

    private void initRootSortedSetDocValues(IndexReaderContext ctx) throws IOException {
        if (this.sortedSetValues != null || ctx == null) {
            return;
        }
        if (ctx.isTopLevel) {
            this.sortedSetValues = MultiDocValues.getSortedSetValues((IndexReader)ctx.reader(), (String)this.field);
        }
        this.initRootSortedSetDocValues((IndexReaderContext)ctx.parent);
    }
}

