/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.orchestration.impl;

import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.similarities.Similarity;
import org.hibernate.search.backend.lucene.cache.impl.LuceneQueryCachingContext;
import org.hibernate.search.backend.lucene.logging.impl.LuceneMiscLog;
import org.hibernate.search.backend.lucene.logging.impl.QueryLog;
import org.hibernate.search.backend.lucene.lowlevel.reader.impl.HibernateSearchMultiReader;
import org.hibernate.search.backend.lucene.lowlevel.reader.impl.IndexReaderMetadataResolver;
import org.hibernate.search.backend.lucene.lowlevel.reader.impl.ReadIndexManagerContext;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneSyncWorkOrchestrator;
import org.hibernate.search.backend.lucene.work.impl.ReadWork;
import org.hibernate.search.backend.lucene.work.impl.ReadWorkExecutionContext;
import org.hibernate.search.engine.backend.orchestration.spi.AbstractWorkOrchestrator;
import org.hibernate.search.engine.backend.work.execution.OperationSubmitter;
import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.util.common.impl.SuppressingCloser;
import org.hibernate.search.util.common.reporting.EventContext;

public class LuceneSyncWorkOrchestratorImpl
extends AbstractWorkOrchestrator<WorkExecution<?>>
implements LuceneSyncWorkOrchestrator {
    private final Similarity similarity;
    private final LuceneQueryCachingContext cachingContext;

    public LuceneSyncWorkOrchestratorImpl(String name, Similarity similarity, LuceneQueryCachingContext cachingContext) {
        super(name);
        this.similarity = similarity;
        this.start(null);
        this.cachingContext = cachingContext;
    }

    @Override
    public <T> T submit(Set<String> indexNames, Collection<? extends ReadIndexManagerContext> indexManagerContexts, Set<String> routingKeys, ReadWork<T> work, HibernateSearchMultiReader indexReader) {
        WorkExecution<T> workExecution = new WorkExecution<T>(this.similarity, indexNames, indexManagerContexts, routingKeys, work, indexReader, this.cachingContext);
        Throwable throwable = null;
        try {
            this.submit(workExecution, OperationSubmitter.blocking());
            T t = workExecution.getResult();
            return t;
        }
        catch (Throwable t) {
            throwable = t;
            throw t;
        }
        finally {
            if (throwable == null) {
                workExecution.close();
            } else {
                new SuppressingCloser(throwable).push(workExecution);
            }
        }
    }

    protected void doStart(ConfigurationPropertySource propertySource) {
    }

    protected void doSubmit(WorkExecution<?> work, OperationSubmitter operationSubmitter) {
        if (!OperationSubmitter.blocking().equals(operationSubmitter)) {
            throw LuceneMiscLog.INSTANCE.nonblockingOperationSubmitterNotSupported();
        }
        work.execute();
    }

    protected CompletableFuture<?> completion() {
        return CompletableFuture.completedFuture(null);
    }

    protected void doStop() {
    }

    static class WorkExecution<T>
    implements AutoCloseable,
    ReadWorkExecutionContext {
        private final Similarity similarity;
        private final Set<String> indexNames;
        private final HibernateSearchMultiReader indexReader;
        private final ReadWork<T> work;
        private final boolean closeIndexReader;
        private final LuceneQueryCachingContext cachingContext;
        private T result;

        WorkExecution(Similarity similarity, Set<String> indexNames, Collection<? extends ReadIndexManagerContext> indexManagerContexts, Set<String> routingKeys, ReadWork<T> work, HibernateSearchMultiReader indexReader, LuceneQueryCachingContext cachingContext) {
            this.similarity = similarity;
            this.indexNames = indexNames;
            this.work = work;
            if (indexReader == null) {
                this.indexReader = HibernateSearchMultiReader.open(indexNames, indexManagerContexts, routingKeys);
                this.closeIndexReader = true;
            } else {
                this.indexReader = indexReader;
                this.closeIndexReader = false;
            }
            this.cachingContext = cachingContext;
        }

        @Override
        public IndexSearcher createSearcher() {
            IndexSearcher searcher = new IndexSearcher((IndexReader)this.indexReader);
            searcher.setSimilarity(this.similarity);
            this.cachingContext.queryCache().ifPresent(arg_0 -> ((IndexSearcher)searcher).setQueryCache(arg_0));
            if (this.cachingContext.queryCachingPolicy().isPresent()) {
                searcher.setQueryCachingPolicy(this.cachingContext.queryCachingPolicy().get());
                if (searcher.getQueryCache() == null) {
                    QueryLog.INSTANCE.ineffectiveQueryCachingPolicy();
                }
            }
            return searcher;
        }

        @Override
        public IndexReaderMetadataResolver getIndexReaderMetadataResolver() {
            return this.indexReader.getMetadataResolver();
        }

        @Override
        public EventContext getEventContext() {
            return EventContexts.fromIndexNames(this.indexNames);
        }

        public void execute() {
            this.result = this.work.execute(this);
        }

        public T getResult() {
            return this.result;
        }

        @Override
        public void close() {
            if (!this.closeIndexReader) {
                return;
            }
            try {
                this.indexReader.close();
            }
            catch (IOException | RuntimeException e) {
                LuceneMiscLog.INSTANCE.unableToCloseIndexReader(this.getEventContext(), e);
            }
        }
    }
}

