/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.predicate.impl;

import java.util.function.Function;
import org.apache.lucene.search.Query;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexScope;
import org.hibernate.search.backend.lucene.search.predicate.impl.AbstractLuceneSearchPredicate;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicate;
import org.hibernate.search.backend.lucene.search.predicate.impl.PredicateRequestContext;
import org.hibernate.search.engine.search.common.NamedValues;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.dsl.PredicateFinalStep;
import org.hibernate.search.engine.search.predicate.spi.WithParametersPredicateBuilder;

public class LuceneWithParametersPredicate
extends AbstractLuceneSearchPredicate {
    private final LuceneSearchIndexScope<?> scope;
    private final Function<? super NamedValues, ? extends PredicateFinalStep> predicateCreator;

    private LuceneWithParametersPredicate(Builder builder) {
        super(builder);
        this.scope = builder.scope;
        this.predicateCreator = builder.predicateCreator;
    }

    @Override
    protected Query doToQuery(PredicateRequestContext context) {
        LuceneSearchPredicate providedPredicate = LuceneSearchPredicate.from(this.scope, this.predicateCreator.apply((NamedValues)context.queryParameters()).toPredicate());
        providedPredicate.checkNestableWithin(context.getNestedPath());
        return providedPredicate.toQuery(context);
    }

    @Override
    public void checkNestableWithin(String expectedParentNestedPath) {
    }

    public static class Builder
    extends AbstractLuceneSearchPredicate.AbstractBuilder
    implements WithParametersPredicateBuilder {
        private Function<? super NamedValues, ? extends PredicateFinalStep> predicateCreator;

        Builder(LuceneSearchIndexScope<?> scope) {
            super(scope);
        }

        public void creator(Function<? super NamedValues, ? extends PredicateFinalStep> creator) {
            this.predicateCreator = creator;
        }

        public SearchPredicate build() {
            return new LuceneWithParametersPredicate(this);
        }
    }
}

