/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.spi;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicate;
import org.hibernate.search.backend.lucene.search.predicate.impl.PredicateRequestContext;
import org.hibernate.search.backend.lucene.search.sort.impl.LuceneSearchSort;
import org.hibernate.search.backend.lucene.search.sort.impl.LuceneSearchSortCollector;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.sort.SearchSort;

public final class LuceneMigrationUtils {
    private LuceneMigrationUtils() {
    }

    public static Query toLuceneQuery(SearchPredicate predicate) {
        return ((LuceneSearchPredicate)predicate).toQuery(PredicateRequestContext.withoutSession());
    }

    public static Sort toLuceneSort(SearchSort sort) {
        final ArrayList result = new ArrayList();
        LuceneSearchSortCollector collector = new LuceneSearchSortCollector(){

            @Override
            public void collectSortField(SortField sortField) {
                result.add(sortField);
            }

            @Override
            public void collectSortFields(SortField[] sortFields) {
                Collections.addAll(result, sortFields);
            }

            @Override
            public PredicateRequestContext toPredicateRequestContext(String absoluteNestedPath) {
                return PredicateRequestContext.withoutSession().withNestedPath(absoluteNestedPath);
            }
        };
        ((LuceneSearchSort)sort).toSortFields(collector);
        return new Sort(result.toArray(new SortField[0]));
    }
}

