/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.codec.impl;

import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexableField;
import org.hibernate.search.backend.lucene.types.codec.impl.AbstractLuceneNumericFieldCodec;
import org.hibernate.search.backend.lucene.types.codec.impl.DocValues;
import org.hibernate.search.backend.lucene.types.codec.impl.Indexing;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneDocumentContent;
import org.hibernate.search.backend.lucene.types.codec.impl.Storage;
import org.hibernate.search.backend.lucene.types.lowlevel.impl.LuceneIntegerDomain;
import org.hibernate.search.backend.lucene.types.lowlevel.impl.LuceneNumericDomain;

public final class LuceneIntegerFieldCodec
extends AbstractLuceneNumericFieldCodec<Integer, Integer> {
    public LuceneIntegerFieldCodec(Indexing indexing, DocValues docValues, Storage storage, Integer indexNullAsValue) {
        super(indexing, docValues, storage, indexNullAsValue);
    }

    @Override
    void addStoredToDocument(LuceneDocumentContent documentBuilder, String absoluteFieldPath, Integer value, Integer encodedValue) {
        documentBuilder.addField((IndexableField)new StoredField(absoluteFieldPath, encodedValue.intValue()));
    }

    @Override
    public Integer decode(IndexableField field) {
        return (Integer)field.numericValue();
    }

    @Override
    public Integer raw(IndexableField field) {
        return this.decode(field);
    }

    @Override
    public Integer encode(Integer value) {
        return value;
    }

    @Override
    public Integer decode(Integer encoded) {
        return encoded;
    }

    @Override
    public LuceneNumericDomain<Integer> getDomain() {
        return LuceneIntegerDomain.get();
    }

    @Override
    public Class<Integer> encodedType() {
        return Integer.class;
    }
}

