/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.cfg.impl;

import java.util.function.Function;
import org.hibernate.search.engine.cfg.impl.OptionalPropertyContextImpl;
import org.hibernate.search.engine.cfg.spi.ConvertUtils;
import org.hibernate.search.engine.cfg.spi.KeyContext;
import org.hibernate.search.engine.cfg.spi.OptionalPropertyContext;
import org.hibernate.search.engine.environment.bean.BeanReference;

public class KeyContextImpl
implements KeyContext {
    private final String key;

    public KeyContextImpl(String key) {
        this.key = key;
    }

    @Override
    public OptionalPropertyContext<String> asString() {
        return this.as(String.class, Function.identity());
    }

    @Override
    public OptionalPropertyContext<Boolean> asBoolean() {
        return new OptionalPropertyContextImpl<Boolean>(this.key, ConvertUtils::convertBoolean);
    }

    @Override
    public OptionalPropertyContext<Integer> asInteger() {
        return new OptionalPropertyContextImpl<Integer>(this.key, ConvertUtils::convertInteger);
    }

    @Override
    public OptionalPropertyContext<Long> asLong() {
        return new OptionalPropertyContextImpl<Long>(this.key, ConvertUtils::convertLong);
    }

    @Override
    public <T> OptionalPropertyContext<BeanReference<? extends T>> asBeanReference(Class<T> expectedBeanType) {
        return new OptionalPropertyContextImpl<BeanReference<? extends T>>(this.key, v -> ConvertUtils.convertBeanReference(expectedBeanType, v));
    }

    @Override
    public <T> OptionalPropertyContext<T> as(Class<T> expectedType, Function<String, T> parser) {
        return new OptionalPropertyContextImpl<Object>(this.key, v -> ConvertUtils.convert(expectedType, parser, v));
    }
}

