/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.cfg.impl;

import java.lang.invoke.MethodHandles;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.engine.cfg.impl.EmptyConfigurationPropertySource;
import org.hibernate.search.engine.cfg.spi.ConfigurationProvider;
import org.hibernate.search.engine.cfg.spi.ConfigurationScope;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanResolver;
import org.hibernate.search.engine.logging.impl.Log;
import org.hibernate.search.util.common.annotation.Incubating;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

@Incubating
public final class ConfigurationPropertySourceScopeUtils {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final Comparator<ConfigurationProvider> CONFIGURATION_PROVIDER_COMPARATOR = Comparator.comparing(ConfigurationProvider::priority).thenComparing(cp -> cp.getClass().getName());

    private ConfigurationPropertySourceScopeUtils() {
    }

    public static ConfigurationScope global() {
        return ConfigurationScope.GLOBAL;
    }

    public static ConfigurationScope backend() {
        return ConfigurationPropertySourceScopeUtils.global().reduce("backend", null);
    }

    public static ConfigurationScope backend(String backendName) {
        return ConfigurationPropertySourceScopeUtils.backend().reduce("backend", backendName);
    }

    public static ConfigurationScope index(String backendName, String indexName) {
        return ConfigurationPropertySourceScopeUtils.backend(backendName).reduce("index", indexName);
    }

    public static ConfigurationPropertySource fallback(BeanResolver beanResolver, ConfigurationScope scope) {
        try (BeanHolder<List<ConfigurationProvider>> configurationProviderHolders = beanResolver.resolve(beanResolver.allConfiguredForRole(ConfigurationProvider.class));){
            List<ConfigurationProvider> configurationProviders = configurationProviderHolders.get().stream().sorted(CONFIGURATION_PROVIDER_COMPARATOR).collect(Collectors.toList());
            if (configurationProviders.size() > 1) {
                log.multipleConfigurationProvidersAvailable(scope.toString(), configurationProviders);
            }
            ConfigurationPropertySource fallback = EmptyConfigurationPropertySource.get();
            ConfigurationScope scopeIterator = scope;
            for (ConfigurationProvider provider : configurationProviders) {
                fallback = provider.get(scopeIterator).map(fallback::withFallback).orElse(fallback);
            }
            ConfigurationPropertySource configurationPropertySource = fallback;
            return configurationPropertySource;
        }
    }
}

