/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.environment.bean;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.impl.CollectionHelper;

final class CompositeBeanHolder<T>
implements BeanHolder<List<T>> {
    private final List<? extends BeanHolder<? extends T>> dependencies;
    private final List<T> instances;

    CompositeBeanHolder(List<? extends BeanHolder<? extends T>> dependencies) {
        this.dependencies = dependencies;
        ArrayList<T> tmp = new ArrayList<T>(dependencies.size());
        for (BeanHolder<T> delegate : dependencies) {
            tmp.add(delegate.get());
        }
        this.instances = CollectionHelper.toImmutableList(tmp);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[instances=" + String.valueOf(this.instances) + ", dependencies=" + String.valueOf(this.dependencies) + "]";
    }

    @Override
    public List<T> get() {
        return this.instances;
    }

    @Override
    public void close() {
        try (Closer closer = new Closer();){
            closer.pushAll(BeanHolder::close, this.dependencies);
        }
    }
}

