/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.projection.spi;

import java.util.List;
import java.util.function.Function;
import org.hibernate.search.engine.search.projection.ProjectionCollector;
import org.hibernate.search.engine.search.projection.spi.ListBasedProjectionCollector;

final class SimpleProjectionCollector<E, V, R>
extends ListBasedProjectionCollector<E, V, R> {
    private final Function<List<V>, R> finisher;

    private SimpleProjectionCollector(Function<List<V>, R> finisher) {
        this.finisher = finisher;
    }

    @Override
    public R doFinish(List<V> accumulated) {
        return this.finisher.apply(accumulated);
    }

    static final class Provider<V, R>
    implements ProjectionCollector.Provider<V, R> {
        private final Function<List<V>, R> finisher;

        Provider(Function<List<V>, R> finisher) {
            this.finisher = finisher;
        }

        @Override
        public <T> ProjectionCollector<T, V, ?, R> get() {
            return new SimpleProjectionCollector(this.finisher);
        }

        @Override
        public boolean isSingleValued() {
            return false;
        }
    }
}

