/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.query.spi;

import org.hibernate.search.engine.logging.impl.QueryLog;
import org.hibernate.search.engine.search.query.SearchResultTotal;

public class SimpleSearchResultTotal
implements SearchResultTotal {
    private final long totalHitCount;
    private final boolean isExact;

    public static SimpleSearchResultTotal of(long totalHitCount, boolean isExact) {
        return new SimpleSearchResultTotal(totalHitCount, isExact);
    }

    public static SimpleSearchResultTotal exact(long totalHitCount) {
        return SimpleSearchResultTotal.of(totalHitCount, true);
    }

    public static SimpleSearchResultTotal lowerBound(long totalHitCount) {
        return SimpleSearchResultTotal.of(totalHitCount, false);
    }

    private SimpleSearchResultTotal(long totalHitCount, boolean isExact) {
        this.totalHitCount = totalHitCount;
        this.isExact = isExact;
    }

    @Override
    public boolean isHitCountExact() {
        return this.isExact;
    }

    @Override
    public boolean isHitCountLowerBound() {
        return !this.isExact;
    }

    @Override
    public long hitCount() {
        if (!this.isExact) {
            throw QueryLog.INSTANCE.notExactTotalHitCount();
        }
        return this.totalHitCount;
    }

    @Override
    public long hitCountLowerBound() {
        return this.totalHitCount;
    }

    public String toString() {
        return "SimpleSearchResultTotal{totalHitCount=" + this.totalHitCount + ", isExact=" + this.isExact + "}";
    }
}

