/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.logging.impl;

import java.util.Collection;
import java.util.List;
import org.hibernate.ScrollMode;
import org.hibernate.SessionFactory;
import org.hibernate.mapping.Value;
import org.hibernate.resource.beans.container.spi.BeanContainer;
import org.hibernate.search.engine.environment.bean.spi.BeanNotFoundException;
import org.hibernate.search.mapper.orm.common.EntityReference;
import org.hibernate.search.mapper.orm.search.loading.EntityLoadingCacheLookupStrategy;
import org.hibernate.search.mapper.pojo.logging.spi.PojoModelPathFormatter;
import org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPath;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.impl.ClassFormatter;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.FormatWith;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.ValidIdRange;
import org.jboss.logging.annotations.ValidIdRanges;

@MessageLogger(projectCode="HSEARCH")
@ValidIdRanges(value={@ValidIdRange(min=800000, max=809999), @ValidIdRange(min=27, max=28), @ValidIdRange(min=30, max=30), @ValidIdRange(min=31, max=31), @ValidIdRange(min=34, max=34), @ValidIdRange(min=36, max=36), @ValidIdRange(min=39, max=39), @ValidIdRange(min=62, max=62), @ValidIdRange(min=116, max=116), @ValidIdRange(min=183, max=183), @ValidIdRange(min=211, max=212), @ValidIdRange(min=235, max=235), @ValidIdRange(min=276, max=276), @ValidIdRange(min=348, max=349)})
public interface Log
extends BasicLogger {
    public static final int ID_OFFSET_LEGACY_ENGINE = 0;
    public static final int ID_OFFSET = 800000;

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=27, value="Mass indexing is going to index %d entities.")
    public void indexingEntities(long var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=28, value="Mass indexing complete. Indexed %1$d entities.")
    public void indexingEntitiesCompleted(long var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=30, value="Mass indexing progress: indexed %1$d entities in %2$d ms.")
    public void indexingProgressRaw(long var1, long var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=31, value="Mass indexing progress: %2$.2f%% [%1$f documents/second].")
    public void indexingProgressStats(float var1, float var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=34, value="Hibernate Search version %1$s")
    public void version(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=36, value="Unable to guess the transaction status: not starting a JTA transaction.")
    public void cannotGuessTransactionStatus(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=39, value="Unable to properly close scroll in ScrollableResults.")
    public void unableToCloseSearcherInScrollableResult(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=62, value="Mass indexing received interrupt signal: aborting.")
    public void interruptedBatchIndexing();

    @Message(value="MassIndexer operation")
    public String massIndexerOperation();

    @Message(value="Indexing instance of entity '%s' during mass indexing")
    public String massIndexerIndexingInstance(String var1);

    @Message(value="Fetching identifiers of entities to index for entity '%s' during mass indexing")
    public String massIndexerFetchingIds(String var1);

    @Message(value="Loading and extracting entity data for entity '%s' during mass indexing")
    public String massIndexingLoadingAndExtractingEntityData(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=235, value="Default automatic indexing synchronization strategy set to '%s'.")
    public void defaultAutomaticIndexingSynchronizationStrategy(Object var1);

    @Message(id=276, value="No transaction active while indexing entity '%1$s'. Consider increasing the connection time-out.")
    public SearchException transactionNotActiveWhileProducingIdsForBatchIndexing(String var1);

    @Message(id=800001, value="Hibernate Search was not initialized.")
    public SearchException hibernateSearchNotInitialized();

    @Message(id=800002, value="Unexpected entity name for a query hit: '%1$s'. Expected one of %2$s.")
    public SearchException unexpectedSearchHitEntityName(String var1, Collection<String> var2);

    @Message(id=800003, value="Invalid automatic indexing strategy name: '%1$s'. Valid names are: %2$s.")
    public SearchException invalidAutomaticIndexingStrategyName(String var1, List<String> var2);

    @Message(id=800007, value="Unable to resolve path '%1$s' to a persisted attribute in Hibernate ORM metadata. If this path points to a transient attribute, use @IndexingDependency(derivedFrom = ...) to specify which persisted attributes it is derived from. See the reference documentation for more information.")
    public SearchException unknownPathForDirtyChecking(@FormatWith(value=PojoModelPathFormatter.class) PojoModelPath var1, @Cause Exception var2);

    @Message(id=800008, value="Path '%1$s' points to attribute '%2$s' that will never be reported as dirty by Hibernate ORM. Check that you didn't declare an invalid indexing dependency.")
    public SearchException unreportedPathForDirtyChecking(@FormatWith(value=PojoModelPathFormatter.class) PojoModelPath var1, Value var2);

    @Message(id=800009, value="Unable to apply container value extractor with name '%2$s' to Hibernate ORM metadata node of type '%1$s'.")
    public SearchException invalidContainerExtractorForDirtyChecking(Class<?> var1, String var2);

    @Message(id=800011, value="Unable to create a SearchSession for sessions created using a different session factory. Expected: '%1$s'. In use: '%2$s'.")
    public SearchException usingDifferentSessionFactories(SessionFactory var1, SessionFactory var2);

    @Message(id=800012, value="Unable to retrieve property type model for '%1$s' on '%2$s': %3$s")
    public SearchException errorRetrievingPropertyTypeModel(String var1, @FormatWith(value=PojoTypeModelFormatter.class) PojoRawTypeModel<?> var2, String var3, @Cause Exception var4);

    @Message(id=800013, value="Mass indexing received interrupt signal. The index is left in an unknown state!")
    public SearchException massIndexingThreadInterrupted(@Cause InterruptedException var1);

    @Message(id=800015, value="Invalid reflection strategy name: '%1$s'. Valid names are: %2$s.")
    public SearchException invalidReflectionStrategyName(String var1, List<String> var2);

    @Message(id=800016, value="Unable to access Hibernate ORM session: %1$s")
    public SearchException hibernateSessionAccessError(String var1, @Cause IllegalStateException var2);

    @Message(id=800017, value="Underlying Hibernate ORM Session is closed.")
    public SearchException hibernateSessionIsClosed(@Cause IllegalStateException var1);

    @Message(id=800018, value="Invalid automatic indexing synchronization strategy name: '%1$s'. Valid names are: %2$s.")
    public SearchException invalidAutomaticIndexingSynchronizationStrategyName(String var1, List<String> var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=800019, value="The entity loader for '%1$s' is ignoring the cache lookup strategy '%2$s', because document IDs are distinct from entity IDs and thus cannot be used for persistence context or second level cache lookups.")
    public void skippingPreliminaryCacheLookupsForNonEntityIdEntityLoader(String var1, EntityLoadingCacheLookupStrategy var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=800020, value="The entity loader for '%1$s' is ignoring the second-level cache even though it was instructed to use it, because caching is not enabled for this entity type.")
    public void skippingSecondLevelCacheLookupsForNonCachedEntityTypeEntityLoader(String var1);

    @Message(id=800021, value="Unable to access Hibernate ORM session factory: %1$s")
    public SearchException hibernateSessionFactoryAccessError(String var1, @Cause IllegalStateException var2);

    @Message(id=800022, value="Indexing failure: %1$s.\nThe following entities may not have been updated correctly in the index: %2$s.")
    public SearchException indexingFailure(String var1, List<EntityReference> var2, @Cause Throwable var3);

    @Message(value="Automatic indexing of Hibernate ORM entities")
    public String automaticIndexing();

    @Message(id=800023, value="Unable to process entities for automatic indexing before transaction completion: %1$s")
    public SearchException synchronizationBeforeTransactionFailure(String var1, @Cause Throwable var2);

    @Message(id=800024, value="Unable to index documents for automatic indexing after transaction completion: %1$s")
    public SearchException synchronizationAfterTransactionFailure(String var1, @Cause Throwable var2);

    @Message(id=800025, value="Unable to handle transaction: %1$s")
    public SearchException massIndexingTransactionHandlingException(String var1, @Cause Throwable var2);

    @Message(id=800026, value="%1$s failure(s) occurred during mass indexing. See the logs for details. First failure on entity '%2$s': %3$s")
    public SearchException massIndexingFirstFailureOnEntity(long var1, EntityReference var3, String var4, @Cause Throwable var5);

    @Message(id=800027, value="Unknown type: '%1$s'. Available named types: %2$s. For entity types, the correct type name is the entity name. For component types (embeddeds, ...) in dynamic-map entities, the correct type name is name of the owner entity followed by a dot ('.') followed by the dot-separated path to the component, e.g. 'MyEntity.myEmbedded' or 'MyEntity.myEmbedded.myNestedEmbedded'.")
    public SearchException unknownNamedType(String var1, Collection<String> var2);

    @Message(id=800028, value="Unknown entity name: '%1$s'. Available entity names: %2$s.")
    public SearchException invalidEntityName(String var1, Collection<String> var2);

    @Message(id=800029, value="Invalid type for '%1$s': the entity type must extend '%2$s', but entity type '%3$s' does not.")
    public SearchException invalidEntitySuperType(String var1, @FormatWith(value=ClassFormatter.class) Class<?> var2, @FormatWith(value=ClassFormatter.class) Class<?> var3);

    @Message(id=800030, value="Type '%1$s' doesn't have any representation in the JPA metamodel. As a result, Hibernate Search cannot use the Criteria API to automatically build queries targeting this type. This means in particular that this type cannot be mass-indexed.")
    public SearchException nonJpaEntityType(PojoRawTypeIdentifier<?> var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=800031, value="The mass indexing failure handler threw an exception while handling a previous failure. The failure may not have been reported.")
    public void failureInMassIndexingFailureHandler(@Cause Throwable var1);

    @Message(id=800032, value="Invalid schema management strategy name: '%1$s'. Valid names are: %2$s.")
    public SearchException invalidSchemaManagementStrategyName(String var1, List<String> var2);

    @Message(id=800033, value="Type '%1$s' is not an entity type, or this entity type is not indexed.")
    public SearchException notIndexedEntityType(@FormatWith(value=ClassFormatter.class) Class<?> var1);

    @Message(id=800034, value="Entity type '%1$s' is not indexed.")
    public SearchException notIndexedEntityName(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=800035, value="Unable to shut down Hibernate Search: %1$s")
    public void shutdownFailed(String var1, @Cause Throwable var2);

    @Message(id=800036, value="Cannot use scroll() with scroll mode '%1$s' with Hibernate Search queries: only ScrollMode.FORWARDS_ONLY is supported.")
    public SearchException canOnlyUseScrollWithScrollModeForwardsOnly(ScrollMode var1);

    @Message(id=800037, value="Cannot scroll backwards with Hibernate Search scrolls: they are forwards-only. Ensure you always increment the scroll position, and never decrement it.")
    public SearchException cannotScrollBackwards();

    @Message(id=800038, value="Cannot set the scroll position relative to the end with Hibernate Search scrolls. Ensure you always pass a positive number to setRowNumber().")
    public SearchException cannotSetScrollPositionRelativeToEnd();

    @Message(id=800039, value="Cannot use this ScrollableResults instance: it is closed.")
    public SearchException cannotUseClosedScrollableResults();

    @Message(id=800040, value="Multiple instances of entity type '%1$s' have their property '%2$s' set to '%3$s'. '%2$s' is the document ID and must be assigned unique values.")
    public SearchException foundMultipleEntitiesForDocumentId(String var1, String var2, Object var3);

    @Message(id=800041, value="No such bean in bean container '%1$s'.")
    public BeanNotFoundException beanNotFoundInBeanContainer(BeanContainer var1);

    @Message(id=800042, value="%1$s failure(s) occurred during mass indexing. See the logs for details. First failure: %2$s")
    public SearchException massIndexingFirstFailure(long var1, String var3, @Cause Throwable var4);
}

