/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.mapping.impl;

import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.mapper.orm.coordination.common.spi.CoordinationStrategy;
import org.hibernate.search.mapper.orm.mapping.impl.HibernateOrmMappingPartialBuildState;
import org.hibernate.search.mapper.orm.mapping.impl.HibernateOrmTypeContextContainer;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmBasicTypeMetadataProvider;
import org.hibernate.search.mapper.orm.session.impl.ConfiguredAutomaticIndexingStrategy;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoContainedTypeExtendedMappingCollector;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoIndexedTypeExtendedMappingCollector;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoMapperDelegate;
import org.hibernate.search.mapper.pojo.mapping.spi.PojoMappingDelegate;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.util.common.impl.Closer;

public final class HibernateOrmMapperDelegate
implements PojoMapperDelegate<HibernateOrmMappingPartialBuildState> {
    private final HibernateOrmTypeContextContainer.Builder typeContextContainerBuilder;
    private final BeanHolder<? extends CoordinationStrategy> coordinationStrategyHolder;
    private final ConfiguredAutomaticIndexingStrategy configuredAutomaticIndexingStrategy;

    HibernateOrmMapperDelegate(HibernateOrmBasicTypeMetadataProvider basicTypeMetadataProvider, BeanHolder<? extends CoordinationStrategy> coordinationStrategyHolder, ConfiguredAutomaticIndexingStrategy configuredAutomaticIndexingStrategy) {
        this.typeContextContainerBuilder = new HibernateOrmTypeContextContainer.Builder(basicTypeMetadataProvider);
        this.coordinationStrategyHolder = coordinationStrategyHolder;
        this.configuredAutomaticIndexingStrategy = configuredAutomaticIndexingStrategy;
    }

    public void closeOnFailure() {
        try (Closer closer = new Closer();){
            closer.push(ConfiguredAutomaticIndexingStrategy::stop, (Object)this.configuredAutomaticIndexingStrategy);
            closer.push(CoordinationStrategy::stop, this.coordinationStrategyHolder, BeanHolder::get);
            closer.push(BeanHolder::close, this.coordinationStrategyHolder);
        }
    }

    public <E> PojoIndexedTypeExtendedMappingCollector createIndexedTypeExtendedMappingCollector(PojoRawTypeModel<E> rawTypeModel, String entityName) {
        return this.typeContextContainerBuilder.addIndexed(rawTypeModel, entityName);
    }

    public <E> PojoContainedTypeExtendedMappingCollector createContainedTypeExtendedMappingCollector(PojoRawTypeModel<E> rawTypeModel, String entityName) {
        return this.typeContextContainerBuilder.addContained(rawTypeModel, entityName);
    }

    public HibernateOrmMappingPartialBuildState prepareBuild(PojoMappingDelegate mappingDelegate) {
        return new HibernateOrmMappingPartialBuildState(mappingDelegate, this.typeContextContainerBuilder, this.coordinationStrategyHolder, this.configuredAutomaticIndexingStrategy);
    }
}

