/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.mapping.impl;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Value;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingBuildContext;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingConfigurationCollector;
import org.hibernate.search.mapper.orm.common.impl.HibernateOrmUtils;
import org.hibernate.search.mapper.orm.mapping.impl.HibernateOrmEntityTypeMetadataContributor;
import org.hibernate.search.mapper.orm.mapping.impl.HibernateOrmMappingPropertiesMetadataContributor;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmBasicTypeMetadataProvider;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmBootstrapIntrospector;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmClassRawTypeModel;
import org.hibernate.search.mapper.pojo.mapping.building.spi.ErrorCollectingPojoTypeMetadataContributor;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoTypeMetadataContributor;
import org.hibernate.search.mapper.pojo.mapping.spi.PojoMappingConfigurationContext;
import org.hibernate.search.mapper.pojo.mapping.spi.PojoMappingConfigurationContributor;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;

public final class HibernateOrmMappingConfigurationContributor
implements PojoMappingConfigurationContributor {
    private final HibernateOrmBasicTypeMetadataProvider basicTypeMetadataProvider;
    private final HibernateOrmBootstrapIntrospector introspector;

    HibernateOrmMappingConfigurationContributor(HibernateOrmBasicTypeMetadataProvider basicTypeMetadataProvider, HibernateOrmBootstrapIntrospector introspector) {
        this.basicTypeMetadataProvider = basicTypeMetadataProvider;
        this.introspector = introspector;
    }

    public void configure(MappingBuildContext buildContext, PojoMappingConfigurationContext configurationContext, MappingConfigurationCollector<PojoTypeMetadataContributor> configurationCollector) {
        LinkedHashSet processedEmbeddableTypes = new LinkedHashSet();
        for (PersistentClass persistentClass : this.basicTypeMetadataProvider.getPersistentClasses()) {
            Class clazz = persistentClass.getMappedClass();
            HibernateOrmClassRawTypeModel typeModel = persistentClass.hasPojoRepresentation() ? this.introspector.typeModel(clazz) : this.introspector.typeModel(persistentClass.getEntityName());
            List<Property> properties = HibernateOrmUtils.sortedNonSyntheticProperties(persistentClass.getPropertyIterator());
            Property identifierProperty = persistentClass.getIdentifierProperty();
            Optional<String> identifierPropertyNameOptional = Optional.ofNullable(identifierProperty).map(Property::getName);
            configurationCollector.collectContributor(typeModel, (Object)new ErrorCollectingPojoTypeMetadataContributor().add((PojoTypeMetadataContributor)new HibernateOrmEntityTypeMetadataContributor(typeModel.typeIdentifier(), persistentClass, identifierPropertyNameOptional)).add((PojoTypeMetadataContributor)new HibernateOrmMappingPropertiesMetadataContributor(this.basicTypeMetadataProvider, properties)));
            this.contributeEmbeddableTypeMetadata(configurationCollector, processedEmbeddableTypes, properties);
        }
    }

    private void contributeEmbeddableTypeMetadata(MappingConfigurationCollector<PojoTypeMetadataContributor> configurationCollector, Set<PojoRawTypeModel<?>> processedEmbeddableTypes, List<Property> properties) {
        for (Property property : properties) {
            this.contributeEmbeddableTypeMetadata(configurationCollector, processedEmbeddableTypes, property);
        }
    }

    private void contributeEmbeddableTypeMetadata(MappingConfigurationCollector<PojoTypeMetadataContributor> configurationCollector, Set<PojoRawTypeModel<?>> processedEmbeddableTypes, Property property) {
        Component componentValue;
        Object componentTypeModel;
        Value value = property.getValue();
        if (value instanceof Component && processedEmbeddableTypes.add((PojoRawTypeModel<?>)(componentTypeModel = (componentValue = (Component)value).isDynamic() ? this.introspector.typeModel(componentValue.getRoleName()) : this.introspector.typeModel(componentValue.getComponentClass())))) {
            List<Property> properties = HibernateOrmUtils.sortedNonSyntheticProperties(componentValue.getPropertyIterator());
            configurationCollector.collectContributor(componentTypeModel, (Object)new ErrorCollectingPojoTypeMetadataContributor().add((PojoTypeMetadataContributor)new HibernateOrmMappingPropertiesMetadataContributor(this.basicTypeMetadataProvider, properties)));
            this.contributeEmbeddableTypeMetadata(configurationCollector, processedEmbeddableTypes, properties);
        }
    }
}

