/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.mapping.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.search.mapper.orm.automaticindexing.impl.AutomaticIndexingTypeContextProvider;
import org.hibernate.search.mapper.orm.event.impl.HibernateOrmListenerTypeContextProvider;
import org.hibernate.search.mapper.orm.loading.impl.LoadingIndexedTypeContextProvider;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.orm.mapping.impl.AbstractHibernateOrmTypeContext;
import org.hibernate.search.mapper.orm.mapping.impl.HibernateOrmContainedTypeContext;
import org.hibernate.search.mapper.orm.mapping.impl.HibernateOrmIndexedTypeContext;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmBasicTypeMetadataProvider;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmRawTypeIdentifierResolver;
import org.hibernate.search.mapper.orm.session.impl.HibernateOrmSessionTypeContextProvider;
import org.hibernate.search.mapper.orm.spi.BatchTypeIdentifierProvider;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class HibernateOrmTypeContextContainer
implements HibernateOrmListenerTypeContextProvider,
HibernateOrmSessionTypeContextProvider,
AutomaticIndexingTypeContextProvider,
LoadingIndexedTypeContextProvider,
BatchTypeIdentifierProvider {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final Map<PojoRawTypeIdentifier<?>, AbstractHibernateOrmTypeContext<?>> typeContexts = new LinkedHashMap();
    private final Map<String, AbstractHibernateOrmTypeContext<?>> typeContextsByHibernateOrmEntityName = new LinkedHashMap();
    private final Map<PojoRawTypeIdentifier<?>, HibernateOrmIndexedTypeContext<?>> indexedTypeContexts = new LinkedHashMap();
    private final Map<String, AbstractHibernateOrmTypeContext<?>> typeContextsByJpaEntityName = new LinkedHashMap();
    private final HibernateOrmRawTypeIdentifierResolver typeIdentifierResolver;

    private HibernateOrmTypeContextContainer(Builder builder, SessionFactoryImplementor sessionFactory) {
        PojoRawTypeIdentifier typeIdentifier;
        for (AbstractHibernateOrmTypeContext.AbstractBuilder contextBuilder : builder.indexedTypeContextBuilders) {
            HibernateOrmIndexedTypeContext indexedTypeContext = ((HibernateOrmIndexedTypeContext.Builder)contextBuilder).build(sessionFactory);
            typeIdentifier = indexedTypeContext.typeIdentifier();
            this.typeContexts.put(typeIdentifier, indexedTypeContext);
            this.indexedTypeContexts.put(typeIdentifier, indexedTypeContext);
            this.typeContextsByHibernateOrmEntityName.put(indexedTypeContext.hibernateOrmEntityName(), indexedTypeContext);
            this.typeContextsByJpaEntityName.put(indexedTypeContext.jpaEntityName(), indexedTypeContext);
        }
        for (AbstractHibernateOrmTypeContext.AbstractBuilder contextBuilder : builder.containedTypeContextBuilders) {
            HibernateOrmContainedTypeContext containedTypeContext = ((HibernateOrmContainedTypeContext.Builder)contextBuilder).build(sessionFactory);
            typeIdentifier = containedTypeContext.typeIdentifier();
            this.typeContexts.put(typeIdentifier, containedTypeContext);
            this.typeContextsByHibernateOrmEntityName.put(containedTypeContext.hibernateOrmEntityName(), containedTypeContext);
            this.typeContextsByJpaEntityName.put(containedTypeContext.jpaEntityName(), containedTypeContext);
        }
        this.typeIdentifierResolver = builder.basicTypeMetadataProvider.getTypeIdentifierResolver();
    }

    public <E> AbstractHibernateOrmTypeContext<E> forExactType(PojoRawTypeIdentifier<E> typeIdentifier) {
        return this.typeContexts.get(typeIdentifier);
    }

    public <E> HibernateOrmIndexedTypeContext<E> indexedForExactType(PojoRawTypeIdentifier<E> typeIdentifier) {
        return this.indexedTypeContexts.get(typeIdentifier);
    }

    public AbstractHibernateOrmTypeContext<?> forJpaEntityName(String indexName) {
        return this.typeContextsByJpaEntityName.get(indexName);
    }

    @Override
    public AbstractHibernateOrmTypeContext<?> forHibernateOrmEntityName(String hibernateOrmEntityName) {
        return this.typeContextsByHibernateOrmEntityName.get(hibernateOrmEntityName);
    }

    @Override
    public <T> PojoRawTypeIdentifier<T> typeIdentifierForJavaClass(Class<T> clazz) {
        return this.typeIdentifierResolver.resolveByJavaClass(clazz);
    }

    @Override
    public PojoRawTypeIdentifier<?> typeIdentifierForHibernateOrmEntityName(String entityName) {
        PojoRawTypeIdentifier<?> result = this.typeIdentifierResolver.resolveByHibernateOrmEntityName(entityName);
        if (result == null) {
            throw log.invalidEntityName(entityName, this.typeIdentifierResolver.allKnownHibernateOrmEntityNames());
        }
        return result;
    }

    @Override
    public PojoRawTypeIdentifier<?> typeIdentifierForEntityName(String entityName) {
        PojoRawTypeIdentifier<?> result = this.typeIdentifierResolver.resolveByJpaOrHibernateOrmEntityName(entityName);
        if (result == null) {
            throw log.invalidEntityName(entityName, this.typeIdentifierResolver.allKnownJpaOrHibernateOrmEntityNames());
        }
        return result;
    }

    Collection<HibernateOrmIndexedTypeContext<?>> allIndexed() {
        return this.indexedTypeContexts.values();
    }

    static class Builder {
        private final HibernateOrmBasicTypeMetadataProvider basicTypeMetadataProvider;
        private final List<HibernateOrmIndexedTypeContext.Builder<?>> indexedTypeContextBuilders = new ArrayList();
        private final List<HibernateOrmContainedTypeContext.Builder<?>> containedTypeContextBuilders = new ArrayList();

        Builder(HibernateOrmBasicTypeMetadataProvider basicTypeMetadataProvider) {
            this.basicTypeMetadataProvider = basicTypeMetadataProvider;
        }

        <E> HibernateOrmIndexedTypeContext.Builder<E> addIndexed(PojoRawTypeModel<E> typeModel, String jpaEntityName) {
            HibernateOrmIndexedTypeContext.Builder<E> builder = new HibernateOrmIndexedTypeContext.Builder<E>(typeModel, jpaEntityName, this.basicTypeMetadataProvider.getHibernateOrmEntityNameByJpaEntityName(jpaEntityName));
            this.indexedTypeContextBuilders.add(builder);
            return builder;
        }

        <E> HibernateOrmContainedTypeContext.Builder<E> addContained(PojoRawTypeModel<E> typeModel, String jpaEntityName) {
            HibernateOrmContainedTypeContext.Builder<E> builder = new HibernateOrmContainedTypeContext.Builder<E>(typeModel, jpaEntityName, this.basicTypeMetadataProvider.getHibernateOrmEntityNameByJpaEntityName(jpaEntityName));
            this.containedTypeContextBuilders.add(builder);
            return builder;
        }

        HibernateOrmTypeContextContainer build(SessionFactoryImplementor sessionFactory) {
            return new HibernateOrmTypeContextContainer(this, sessionFactory);
        }
    }
}

