/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.bridge.builtin.impl;

import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.net.URISyntaxException;
import org.hibernate.search.mapper.pojo.bridge.ValueBridge;
import org.hibernate.search.mapper.pojo.bridge.runtime.ValueBridgeFromIndexedValueContext;
import org.hibernate.search.mapper.pojo.bridge.runtime.ValueBridgeToIndexedValueContext;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public final class DefaultJavaNetURIValueBridge
implements ValueBridge<URI, String> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public String toIndexedValue(URI value, ValueBridgeToIndexedValueContext context) {
        return DefaultJavaNetURIValueBridge.to(value);
    }

    @Override
    public URI fromIndexedValue(String value, ValueBridgeFromIndexedValueContext context) {
        return DefaultJavaNetURIValueBridge.from(value);
    }

    @Override
    public String parse(String value) {
        DefaultJavaNetURIValueBridge.from(value);
        return value;
    }

    @Override
    public boolean isCompatibleWith(ValueBridge<?, ?> other) {
        return this.getClass().equals(other.getClass());
    }

    static String to(URI value) {
        return value == null ? null : value.toString();
    }

    static URI from(String value) {
        if (value == null) {
            return null;
        }
        try {
            return new URI(value);
        }
        catch (URISyntaxException e) {
            throw log.badURISyntax(value, e);
        }
    }
}

