/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.bridge.builtin.impl;

import java.sql.Time;
import java.time.format.DateTimeFormatter;
import org.hibernate.search.engine.cfg.spi.ParseUtils;
import org.hibernate.search.mapper.pojo.bridge.IdentifierBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultJavaSqlTimeValueBridge;
import org.hibernate.search.mapper.pojo.bridge.runtime.IdentifierBridgeFromDocumentIdentifierContext;
import org.hibernate.search.mapper.pojo.bridge.runtime.IdentifierBridgeToDocumentIdentifierContext;

public final class DefaultJavaSqlTimeIdentifierBridge
implements IdentifierBridge<Time> {
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ISO_INSTANT;

    @Override
    public String toDocumentIdentifier(Time propertyValue, IdentifierBridgeToDocumentIdentifierContext context) {
        return FORMATTER.format(DefaultJavaSqlTimeValueBridge.to(propertyValue));
    }

    @Override
    public Time fromDocumentIdentifier(String documentIdentifier, IdentifierBridgeFromDocumentIdentifierContext context) {
        return DefaultJavaSqlTimeValueBridge.from(ParseUtils.parseInstant((String)documentIdentifier));
    }

    @Override
    public boolean isCompatibleWith(IdentifierBridge<?> other) {
        return this.getClass().equals(other.getClass());
    }
}

