/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.bridge.builtin.impl;

import java.sql.Time;
import java.time.Instant;
import org.hibernate.search.engine.cfg.spi.ParseUtils;
import org.hibernate.search.mapper.pojo.bridge.ValueBridge;
import org.hibernate.search.mapper.pojo.bridge.runtime.ValueBridgeFromIndexedValueContext;
import org.hibernate.search.mapper.pojo.bridge.runtime.ValueBridgeToIndexedValueContext;

public final class DefaultJavaSqlTimeValueBridge
implements ValueBridge<Time, Instant> {
    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public Instant toIndexedValue(Time value, ValueBridgeToIndexedValueContext context) {
        return DefaultJavaSqlTimeValueBridge.to(value);
    }

    @Override
    public Time fromIndexedValue(Instant value, ValueBridgeFromIndexedValueContext context) {
        return DefaultJavaSqlTimeValueBridge.from(value);
    }

    @Override
    public Instant parse(String value) {
        return ParseUtils.parseInstant((String)value);
    }

    @Override
    public boolean isCompatibleWith(ValueBridge<?, ?> other) {
        return this.getClass().equals(other.getClass());
    }

    static Instant to(Time value) {
        return value == null ? null : Instant.ofEpochMilli(value.getTime());
    }

    static Time from(Instant value) {
        return value == null ? null : new Time(value.toEpochMilli());
    }
}

