/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.bridge.builtin.impl;

import java.sql.Timestamp;
import java.time.Instant;
import org.hibernate.search.engine.cfg.spi.ParseUtils;
import org.hibernate.search.mapper.pojo.bridge.ValueBridge;
import org.hibernate.search.mapper.pojo.bridge.runtime.ValueBridgeFromIndexedValueContext;
import org.hibernate.search.mapper.pojo.bridge.runtime.ValueBridgeToIndexedValueContext;

public final class DefaultJavaSqlTimestampValueBridge
implements ValueBridge<Timestamp, Instant> {
    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public Instant toIndexedValue(Timestamp value, ValueBridgeToIndexedValueContext context) {
        return DefaultJavaSqlTimestampValueBridge.to(value);
    }

    @Override
    public Timestamp fromIndexedValue(Instant value, ValueBridgeFromIndexedValueContext context) {
        return DefaultJavaSqlTimestampValueBridge.from(value);
    }

    @Override
    public Instant parse(String value) {
        return ParseUtils.parseInstant((String)value);
    }

    @Override
    public boolean isCompatibleWith(ValueBridge<?, ?> other) {
        return this.getClass().equals(other.getClass());
    }

    static Instant to(Timestamp value) {
        return value == null ? null : Instant.ofEpochMilli(value.getTime());
    }

    static Timestamp from(Instant value) {
        return value == null ? null : new Timestamp(value.toEpochMilli());
    }
}

