/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.model.additionalmetadata.building.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.hibernate.search.engine.environment.bean.BeanResolver;
import org.hibernate.search.mapper.pojo.bridge.binding.impl.MarkerBindingContextImpl;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.MarkerBinder;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.building.impl.PojoEntityTypeAdditionalMetadataBuilder;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.building.impl.PojoIndexedTypeAdditionalMetadataBuilder;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.building.impl.PojoPropertyAdditionalMetadataBuilder;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.building.spi.PojoAdditionalMetadataCollectorPropertyNode;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.building.spi.PojoAdditionalMetadataCollectorTypeNode;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.impl.PojoPropertyAdditionalMetadata;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.impl.PojoTypeAdditionalMetadata;
import org.hibernate.search.mapper.pojo.model.path.spi.PojoPathFilterFactory;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;

class PojoTypeAdditionalMetadataBuilder
implements PojoAdditionalMetadataCollectorTypeNode {
    private final BeanResolver beanResolver;
    private final PojoRawTypeModel<?> rawTypeModel;
    private PojoEntityTypeAdditionalMetadataBuilder entityTypeMetadataBuilder;
    private PojoIndexedTypeAdditionalMetadataBuilder indexedTypeMetadataBuilder;
    private final Map<String, List<Consumer<PojoAdditionalMetadataCollectorPropertyNode>>> propertyContributors = new LinkedHashMap<String, List<Consumer<PojoAdditionalMetadataCollectorPropertyNode>>>();

    PojoTypeAdditionalMetadataBuilder(BeanResolver beanResolver, PojoRawTypeModel<?> rawTypeModel) {
        this.beanResolver = beanResolver;
        this.rawTypeModel = rawTypeModel;
    }

    @Override
    public PojoRawTypeIdentifier<?> typeIdentifier() {
        return this.rawTypeModel.typeIdentifier();
    }

    @Override
    public PojoEntityTypeAdditionalMetadataBuilder markAsEntity(String entityName, PojoPathFilterFactory<Set<String>> pathFilterFactory) {
        if (this.entityTypeMetadataBuilder == null) {
            this.entityTypeMetadataBuilder = new PojoEntityTypeAdditionalMetadataBuilder(entityName, pathFilterFactory);
        } else {
            this.entityTypeMetadataBuilder.checkSameEntity(entityName);
        }
        return this.entityTypeMetadataBuilder;
    }

    @Override
    public PojoIndexedTypeAdditionalMetadataBuilder markAsIndexed(boolean enabled) {
        if (this.indexedTypeMetadataBuilder == null) {
            this.indexedTypeMetadataBuilder = new PojoIndexedTypeAdditionalMetadataBuilder();
        }
        this.indexedTypeMetadataBuilder.enabled(enabled);
        return this.indexedTypeMetadataBuilder;
    }

    @Override
    public void property(String propertyName, Consumer<PojoAdditionalMetadataCollectorPropertyNode> propertyMetadataContributor) {
        this.propertyContributors.computeIfAbsent(propertyName, ignored -> new ArrayList()).add(propertyMetadataContributor);
    }

    Object bindMarker(MarkerBinder binder) {
        MarkerBindingContextImpl bindingContext = new MarkerBindingContextImpl(this.beanResolver);
        return bindingContext.applyBinder(binder);
    }

    public PojoTypeAdditionalMetadata build() {
        HashMap<String, Supplier<PojoPropertyAdditionalMetadata>> propertiesAdditionalMetadataSuppliers = new HashMap<String, Supplier<PojoPropertyAdditionalMetadata>>();
        for (Map.Entry<String, List<Consumer<PojoAdditionalMetadataCollectorPropertyNode>>> entry : this.propertyContributors.entrySet()) {
            String propertyName = entry.getKey();
            List<Consumer<PojoAdditionalMetadataCollectorPropertyNode>> contributors = entry.getValue();
            propertiesAdditionalMetadataSuppliers.put(propertyName, () -> {
                PojoPropertyAdditionalMetadataBuilder builder = new PojoPropertyAdditionalMetadataBuilder(this.beanResolver);
                for (Consumer contributor : contributors) {
                    contributor.accept(builder);
                }
                return builder.build();
            });
        }
        return new PojoTypeAdditionalMetadata(this.entityTypeMetadataBuilder == null ? Optional.empty() : Optional.of(this.entityTypeMetadataBuilder.build()), this.indexedTypeMetadataBuilder == null ? Optional.empty() : this.indexedTypeMetadataBuilder.build(), propertiesAdditionalMetadataSuppliers);
    }
}

