/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.processing.impl;

import org.hibernate.search.engine.backend.document.DocumentElement;
import org.hibernate.search.mapper.pojo.processing.impl.PojoIndexingProcessor;
import org.hibernate.search.mapper.pojo.processing.spi.PojoIndexingProcessorSessionContext;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.impl.ToStringTreeBuilder;
import org.hibernate.search.util.common.reflect.spi.ValueReadHandle;

public class PojoIndexingProcessorPropertyNode<T, P>
extends PojoIndexingProcessor<T> {
    private final ValueReadHandle<P> handle;
    private final PojoIndexingProcessor<? super P> nested;

    public PojoIndexingProcessorPropertyNode(ValueReadHandle<P> handle, PojoIndexingProcessor<? super P> nested) {
        this.handle = handle;
        this.nested = nested;
    }

    @Override
    public void close() {
        try (Closer closer = new Closer();){
            closer.push(PojoIndexingProcessor::close, this.nested);
        }
    }

    public void appendTo(ToStringTreeBuilder builder) {
        builder.attribute("operation", (Object)"process property");
        builder.attribute("handle", this.handle);
        builder.attribute("nested", this.nested);
    }

    @Override
    public final void process(DocumentElement target, T source, PojoIndexingProcessorSessionContext sessionContext) {
        Object propertyValue = this.handle.get(source);
        this.nested.process(target, propertyValue, sessionContext);
    }
}

