/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.bridge.binding.impl;

import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.Optional;
import org.hibernate.search.engine.backend.document.model.dsl.IndexSchemaElement;
import org.hibernate.search.engine.backend.types.dsl.IndexFieldTypeFactory;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanResolver;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexBindingContext;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexSchemaContributionListener;
import org.hibernate.search.mapper.pojo.bridge.PropertyBridge;
import org.hibernate.search.mapper.pojo.bridge.binding.PropertyBindingContext;
import org.hibernate.search.mapper.pojo.bridge.binding.impl.AbstractCompositeBindingContext;
import org.hibernate.search.mapper.pojo.bridge.binding.impl.BoundPropertyBridge;
import org.hibernate.search.mapper.pojo.bridge.binding.impl.PojoIndexSchemaContributionListener;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.PropertyBinder;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.model.PojoModelProperty;
import org.hibernate.search.mapper.pojo.model.dependency.PojoPropertyIndexingDependencyConfigurationContext;
import org.hibernate.search.mapper.pojo.model.dependency.impl.PojoPropertyIndexingDependencyConfigurationContextImpl;
import org.hibernate.search.mapper.pojo.model.impl.PojoModelPropertyRootElement;
import org.hibernate.search.mapper.pojo.model.spi.PojoBootstrapIntrospector;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoTypeModel;
import org.hibernate.search.util.common.impl.AbstractCloser;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.impl.SuppressingCloser;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class PropertyBindingContextImpl<P>
extends AbstractCompositeBindingContext
implements PropertyBindingContext {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final PojoBootstrapIntrospector introspector;
    private final PojoTypeModel<?> propertyTypeModel;
    private final PojoModelPropertyRootElement<P> bridgedElement;
    private final PojoPropertyIndexingDependencyConfigurationContextImpl<P> dependencyContext;
    private final IndexFieldTypeFactory indexFieldTypeFactory;
    private final PojoIndexSchemaContributionListener listener;
    private final IndexSchemaElement indexSchemaElement;
    private PartialBinding<P> partialBinding;

    public PropertyBindingContextImpl(BeanResolver beanResolver, PojoBootstrapIntrospector introspector, PojoTypeModel<P> propertyTypeModel, IndexBindingContext indexBindingContext, PojoModelPropertyRootElement<P> bridgedElement, PojoPropertyIndexingDependencyConfigurationContextImpl<P> dependencyContext, Map<String, Object> params) {
        super(beanResolver, params);
        this.introspector = introspector;
        this.propertyTypeModel = propertyTypeModel;
        this.bridgedElement = bridgedElement;
        this.dependencyContext = dependencyContext;
        this.indexFieldTypeFactory = indexBindingContext.createTypeFactory();
        this.listener = new PojoIndexSchemaContributionListener();
        this.indexSchemaElement = indexBindingContext.schemaElement((IndexSchemaContributionListener)this.listener);
    }

    @Override
    public <P2> void bridge(Class<P2> expectedPropertyType, PropertyBridge<P2> bridge) {
        this.bridge(expectedPropertyType, BeanHolder.of(bridge));
    }

    @Override
    public <P2> void bridge(Class<P2> expectedPropertyType, BeanHolder<? extends PropertyBridge<P2>> bridgeHolder) {
        this.checkAndBind(bridgeHolder, this.introspector.typeModel(expectedPropertyType));
    }

    @Override
    public PojoModelProperty bridgedElement() {
        return this.bridgedElement;
    }

    @Override
    public PojoPropertyIndexingDependencyConfigurationContext dependencies() {
        return this.dependencyContext;
    }

    @Override
    public IndexFieldTypeFactory typeFactory() {
        return this.indexFieldTypeFactory;
    }

    @Override
    public IndexSchemaElement indexSchemaElement() {
        return this.indexSchemaElement;
    }

    public Optional<BoundPropertyBridge<P>> applyBinder(PropertyBinder binder) {
        try {
            binder.bind(this);
            if (this.partialBinding == null) {
                throw log.missingBridgeForBinder(binder);
            }
            PropertyBindingContextImpl.checkBridgeDependencies(this.bridgedElement, this.dependencyContext);
            if (!this.listener.isAnySchemaContributed()) {
                try (Object closer = new Closer();){
                    this.partialBinding.abort((AbstractCloser<?, ?>)closer);
                }
                closer = Optional.empty();
                return closer;
            }
            Optional<BoundPropertyBridge<P>> closer = Optional.of(this.partialBinding.complete(this.bridgedElement, this.dependencyContext));
            return closer;
        }
        catch (RuntimeException e) {
            if (this.partialBinding != null) {
                this.partialBinding.abort((AbstractCloser<?, ?>)new SuppressingCloser((Throwable)e));
            }
            throw e;
        }
        finally {
            this.partialBinding = null;
        }
    }

    private <P2> void checkAndBind(BeanHolder<? extends PropertyBridge<P2>> bridgeHolder, PojoRawTypeModel<?> expectedPropertyTypeModel) {
        if (!this.propertyTypeModel.rawType().isSubTypeOf(expectedPropertyTypeModel)) {
            throw log.invalidInputTypeForBridge(bridgeHolder.get(), this.propertyTypeModel, expectedPropertyTypeModel);
        }
        BeanHolder<? extends PropertyBridge<P2>> castedBridgeHolder = bridgeHolder;
        this.partialBinding = new PartialBinding(castedBridgeHolder);
    }

    private static class PartialBinding<P> {
        private final BeanHolder<? extends PropertyBridge<? super P>> bridgeHolder;

        private PartialBinding(BeanHolder<? extends PropertyBridge<? super P>> bridgeHolder) {
            this.bridgeHolder = bridgeHolder;
        }

        void abort(AbstractCloser<?, ?> closer) {
            closer.push(PropertyBridge::close, this.bridgeHolder, BeanHolder::get);
            closer.push(BeanHolder::close, this.bridgeHolder);
        }

        BoundPropertyBridge<P> complete(PojoModelPropertyRootElement<P> bridgedElement, PojoPropertyIndexingDependencyConfigurationContextImpl<P> dependencyContext) {
            return new BoundPropertyBridge<P>(this.bridgeHolder, bridgedElement, dependencyContext);
        }
    }
}

