/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.bridge.builtin.alternative.impl;

import java.util.function.Predicate;
import org.hibernate.search.engine.backend.document.DocumentElement;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.mapper.pojo.bridge.TypeBridge;
import org.hibernate.search.mapper.pojo.bridge.binding.TypeBindingContext;
import org.hibernate.search.mapper.pojo.bridge.builtin.alternative.impl.AlternativeDiscriminatorBinderImpl;
import org.hibernate.search.mapper.pojo.bridge.builtin.programmatic.AlternativeBinder;
import org.hibernate.search.mapper.pojo.bridge.builtin.programmatic.AlternativeBinderDelegate;
import org.hibernate.search.mapper.pojo.bridge.builtin.programmatic.AlternativeValueBridge;
import org.hibernate.search.mapper.pojo.bridge.runtime.TypeBridgeWriteContext;
import org.hibernate.search.mapper.pojo.logging.impl.MappingLog;
import org.hibernate.search.mapper.pojo.model.PojoElementAccessor;
import org.hibernate.search.mapper.pojo.model.PojoModelProperty;
import org.hibernate.search.mapper.pojo.model.PojoModelType;
import org.hibernate.search.util.common.impl.StreamHelper;

public final class AlternativeBinderImpl<D, P>
implements AlternativeBinder {
    private final Class<D> discriminatorType;
    private final String fieldValueSourcePropertyName;
    private final Class<P> fieldValueSourcePropertyType;
    private final BeanReference<? extends AlternativeBinderDelegate<D, P>> delegateRef;
    private String alternativeId;

    public AlternativeBinderImpl(Class<D> discriminatorType, String fieldValueSourcePropertyName, Class<P> fieldValueSourcePropertyType, BeanReference<? extends AlternativeBinderDelegate<D, P>> delegateRef) {
        this.discriminatorType = discriminatorType;
        this.fieldValueSourcePropertyName = fieldValueSourcePropertyName;
        this.fieldValueSourcePropertyType = fieldValueSourcePropertyType;
        this.delegateRef = delegateRef;
    }

    @Override
    public AlternativeBinder alternativeId(String id) {
        this.alternativeId = id;
        return this;
    }

    @Override
    public void bind(TypeBindingContext context) {
        AlternativeValueBridge bridgeDelegate;
        PojoElementAccessor<P> fieldValueSourceAccessor;
        PojoElementAccessor<D> discriminatorAccessor;
        PojoModelType bridgedElement = context.bridgedElement();
        try (BeanHolder alternativeBinderHolder = this.delegateRef.resolve(context.beanResolver());){
            AlternativeBinderDelegate delegate = (AlternativeBinderDelegate)alternativeBinderHolder.get();
            discriminatorAccessor = this.findAlternativeDiscriminatorProperty(bridgedElement).createAccessor(this.discriminatorType);
            PojoModelProperty fieldValueSource = bridgedElement.property(this.fieldValueSourcePropertyName);
            fieldValueSourceAccessor = fieldValueSource.createAccessor(this.fieldValueSourcePropertyType);
            bridgeDelegate = delegate.bind(context.indexSchemaElement(), fieldValueSource);
        }
        context.bridge(new Bridge<D, P>(discriminatorAccessor, fieldValueSourceAccessor, bridgeDelegate));
    }

    private PojoModelProperty findAlternativeDiscriminatorProperty(PojoModelType bridgedElement) {
        return (PojoModelProperty)bridgedElement.properties().stream().filter(p -> p.markers(AlternativeDiscriminatorBinderImpl.Marker.class).stream().map(AlternativeDiscriminatorBinderImpl.Marker::id).anyMatch(Predicate.isEqual(this.alternativeId))).collect(StreamHelper.singleElement(() -> MappingLog.INSTANCE.cannotFindAlternativeDiscriminator(this.alternativeId, this.fieldValueSourcePropertyName), () -> MappingLog.INSTANCE.conflictingAlternativeDiscriminators(this.alternativeId, this.fieldValueSourcePropertyName)));
    }

    private static final class Bridge<D, P>
    implements TypeBridge<Object> {
        private final PojoElementAccessor<D> discriminatorAccessor;
        private final PojoElementAccessor<P> fieldValueSourceAccessor;
        private final AlternativeValueBridge<D, P> delegate;

        private Bridge(PojoElementAccessor<D> discriminatorAccessor, PojoElementAccessor<P> fieldValueSourceAccessor, AlternativeValueBridge<D, P> delegate) {
            this.discriminatorAccessor = discriminatorAccessor;
            this.fieldValueSourceAccessor = fieldValueSourceAccessor;
            this.delegate = delegate;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[discriminatorAccessor=" + String.valueOf(this.discriminatorAccessor) + ", fieldValueSourceAccessor=" + String.valueOf(this.fieldValueSourceAccessor) + ", delegate=" + String.valueOf(this.delegate) + "]";
        }

        @Override
        public void write(DocumentElement target, Object bridgedElement, TypeBridgeWriteContext context) {
            this.delegate.write(target, this.discriminatorAccessor.read(bridgedElement), this.fieldValueSourceAccessor.read(bridgedElement));
        }
    }
}

