/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.logging.impl;

import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.search.engine.backend.types.dsl.IndexFieldTypeOptionsStep;
import org.hibernate.search.engine.logging.spi.MappableTypeModelFormatter;
import org.hibernate.search.engine.mapper.model.spi.MappingElement;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.DerivedDependencyWalkingInfo;
import org.hibernate.search.mapper.pojo.extractor.ContainerExtractor;
import org.hibernate.search.mapper.pojo.logging.spi.PojoConstructorModelFormatter;
import org.hibernate.search.mapper.pojo.logging.spi.PojoModelPathFormatter;
import org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.ObjectPath;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoContainedTypeManager;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoIndexedTypeManager;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPathValueNode;
import org.hibernate.search.mapper.pojo.model.spi.PojoConstructorModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoTypeModel;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.data.impl.LinkedNode;
import org.hibernate.search.util.common.logging.CategorizedLogger;
import org.hibernate.search.util.common.logging.impl.ClassFormatter;
import org.hibernate.search.util.common.logging.impl.CommaSeparatedClassesFormatter;
import org.hibernate.search.util.common.logging.impl.EventContextFormatter;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.logging.impl.ToStringTreeMultilineFormatter;
import org.hibernate.search.util.common.logging.impl.TypeFormatter;
import org.hibernate.search.util.common.reporting.EventContext;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.FormatWith;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.Param;

@CategorizedLogger(category="org.hibernate.search.mapping.mapper", description="Logs related to creating Hibernate Search mapping.\n")
@MessageLogger(projectCode="HSEARCH")
public interface MappingLog {
    public static final String CATEGORY_NAME = "org.hibernate.search.mapping.mapper";
    public static final MappingLog INSTANCE = (MappingLog)LoggerFactory.make(MappingLog.class, (String)"org.hibernate.search.mapping.mapper", (MethodHandles.Lookup)MethodHandles.lookup());

    @Message(id=700126, value="Target path '%1$s' already exists and is not an empty directory. Use a path to an empty or non-existing directory.")
    public SearchException schemaExporterTargetIsNotEmptyDirectory(Path var1);

    @Message(id=700127, value="Unable to export the schema: %1$s")
    public SearchException unableToExportSchema(String var1, @Cause Exception var2, @Param EventContext var3);

    @Message(id=135, value="No default value bridge implementation for type '%1$s'. Use a custom bridge.")
    public SearchException unableToResolveDefaultValueBridgeFromSourceType(@FormatWith(value=PojoTypeModelFormatter.class) PojoTypeModel<?> var1);

    @Message(id=159, value="No property annotated with %1$s(markerSet = \"%3$s\"). There must be exactly one such property in order to map it to geo-point field '%2$s'.")
    public SearchException unableToFindLongitudeOrLatitudeProperty(String var1, String var2, String var3);

    @Message(id=160, value="Multiple properties annotated with %1$s(markerSet = \"%3$s\"). There must be exactly one such property in order to map it to geo-point field '%2$s'.")
    public SearchException multipleLatitudeOrLongitudeProperties(String var1, String var2, String var3);

    @Message(id=177, value="Unable to define a document identifier for indexed type '%1$s', The property representing the entity identifier is unknown. Define the document identifier explicitly by annotating a property whose values are unique with @DocumentId.")
    public SearchException missingIdentifierMapping(@FormatWith(value=PojoTypeModelFormatter.class) PojoRawTypeModel<?> var1);

    @Message(id=216, value="%1$s defines includePaths filters that do not match anything. Non-matching includePaths filters: %2$s. Encountered field paths: %3$s. Check the filters for typos, or remove them if they are not useful.")
    public SearchException uselessIncludePathFilters(MappingElement var1, Set<String> var2, Set<String> var3, @Param EventContext var4);

    @Message(id=221, value="Infinite embedded recursion involving path '%2$s' on type '%1$s'")
    public SearchException infiniteRecursionForAssociationEmbeddeds(@FormatWith(value=PojoTypeModelFormatter.class) PojoRawTypeModel<?> var1, @FormatWith(value=PojoModelPathFormatter.class) PojoModelPathValueNode var2);

    @Message(id=234, value="No matching indexed entity types for types %1$s These types are not indexed entity types, nor is any of their subtypes. Valid indexed entity classes, superclasses and superinterfaces are: %2$s.")
    public SearchException invalidIndexedSuperTypes(Collection<PojoRawTypeIdentifier<?>> var1, Collection<PojoRawTypeIdentifier<?>> var2);

    @Message(id=337, value="Conflicting usage of @Param annotation for parameter name: '%1$s'. Can't assign both value '%2$s' and '%3$s'")
    public SearchException conflictingParameterDefined(String var1, Object var2, Object var3);

    @Message(id=700001, value="No default identifier bridge implementation for type '%1$s'. Implement a custom bridge and assign it to the identifier property with @DocumentId(identifierBridge = ...). See the reference documentation for more information about bridges.")
    public SearchException unableToResolveDefaultIdentifierBridgeFromSourceType(@FormatWith(value=PojoTypeModelFormatter.class) PojoTypeModel<?> var1);

    @Message(id=700003, value="Empty binder reference.")
    public SearchException missingBinderReferenceInBinding();

    @Message(id=700005, value="Ambiguous value bridge reference: both 'valueBridge' and 'valueBinder' are set. Only one can be set.")
    public SearchException invalidFieldDefiningBothBridgeReferenceAndBinderReference();

    @Message(id=700006, value="Ambiguous identifier bridge reference: both 'identifierBridge' and 'identifierBinder' are set. Only one can be set.")
    public SearchException invalidDocumentIdDefiningBothBridgeReferenceAndBinderReference();

    @Message(id=700007, value="Empty scope. If you want to target all indexes, pass 'Object.class' as the target type.")
    public SearchException invalidEmptyTargetForScope();

    @Message(id=700010, value="Invalid bridge for input type '%2$s': '%1$s'. This bridge expects an input of type '%3$s'.")
    public SearchException invalidInputTypeForBridge(Object var1, @FormatWith(value=PojoTypeModelFormatter.class) PojoTypeModel<?> var2, @FormatWith(value=PojoTypeModelFormatter.class) PojoTypeModel<?> var3);

    @Message(id=700011, value="Missing field name for @GeoPointBinding on type %1$s. The field name is mandatory when the bridge is applied to a type, optional when applied to a property.")
    public SearchException missingFieldNameForGeoPointBridgeOnType(String var1);

    @Message(id=700015, value="Unable to interpret the type arguments to the ContainerExtractor interface in  implementation '%1$s'. Only the following implementations of ContainerExtractor are valid:  1) implementations setting both type parameters to *raw* types, e.g. class MyExtractor implements ContainerExtractor<MyBean, String>; 2) implementations setting the first type parameter to an array of an unbounded type variable, and setting the second parameter to the same type variable, e.g. MyExtractor<T> implements ContainerExtractor<T[], T> 3) implementations setting the first type parameter to a parameterized type with one argument set to an unbounded type variable and the other to unbounded wildcards, and setting the second type parameter to the same type variable, e.g. MyExtractor<T> implements ContainerExtractor<MyParameterizedBean<?, T, ?>, T>")
    public SearchException cannotInferContainerExtractorClassTypePattern(@FormatWith(value=ClassFormatter.class) Class<?> var1, @Cause Exception var2);

    @Message(id=700016, value="Invalid container extractor for type '%3$s': '%1$s' (implementation class: '%2$s')")
    public SearchException invalidContainerExtractorForType(String var1, @FormatWith(value=ClassFormatter.class) Class<? extends ContainerExtractor> var2, @FormatWith(value=PojoTypeModelFormatter.class) PojoTypeModel<?> var3);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=700017, value="Type manager for indexed type '%1$s': %2$s")
    public void indexedTypeManager(@FormatWith(value=PojoTypeModelFormatter.class) PojoRawTypeModel<?> var1, @FormatWith(value=ToStringTreeMultilineFormatter.class) PojoIndexedTypeManager<?, ?> var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=700018, value="Detected entity types: %1$s, indexed types: %2$s, initial mapped types: %3$s.")
    public void detectedMappedTypes(Set<PojoRawTypeModel<?>> var1, Set<PojoRawTypeModel<?>> var2, Set<PojoRawTypeModel<?>> var3);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=700019, value="Type manager for contained type '%1$s': %2$s")
    public void containedTypeManager(@FormatWith(value=PojoTypeModelFormatter.class) PojoRawTypeModel<?> var1, @FormatWith(value=ToStringTreeMultilineFormatter.class) PojoContainedTypeManager<?, ?> var2);

    @Message(id=700020, value="Unable to find the inverse side of the association on type '%2$s' at path '%3$s'. Hibernate Search needs this information in order to reindex '%2$s' when '%1$s' is modified. You can solve this error by defining the inverse side of this association,  either with annotations specific to your integration (@OneToMany(mappedBy = ...) in Hibernate ORM)  or with the Hibernate Search @AssociationInverseSide annotation. Alternatively, if you do not need to reindex '%2$s' when '%1$s' is modified, you can disable automatic reindexing with @IndexingDependency(reindexOnUpdate = ReindexOnUpdate.SHALLOW).")
    public SearchException cannotInvertAssociationForReindexing(@FormatWith(value=PojoTypeModelFormatter.class) PojoRawTypeModel<?> var1, @FormatWith(value=PojoTypeModelFormatter.class) PojoRawTypeModel<?> var2, @FormatWith(value=PojoModelPathFormatter.class) PojoModelPathValueNode var3);

    @Message(id=700021, value="Unable to apply path '%2$s' to type '%1$s'. This path was resolved as the inverse side of the association '%4$s' on type '%3$s'. Hibernate Search needs to apply this path in order to reindex '%3$s' when '%1$s' is modified. Nested exception: %5$s")
    public SearchException cannotApplyImplicitInverseAssociationPath(@FormatWith(value=PojoTypeModelFormatter.class) PojoRawTypeModel<?> var1, @FormatWith(value=PojoModelPathFormatter.class) PojoModelPathValueNode var2, @FormatWith(value=PojoTypeModelFormatter.class) PojoRawTypeModel<?> var3, @FormatWith(value=PojoModelPathFormatter.class) PojoModelPathValueNode var4, String var5, @Cause Exception var6);

    @Message(id=700022, value="The inverse association targets type '%1$s', but a supertype or subtype of '%2$s' was expected.")
    public SearchException incorrectTargetTypeForInverseAssociation(@FormatWith(value=PojoTypeModelFormatter.class) PojoRawTypeModel<?> var1, @FormatWith(value=PojoTypeModelFormatter.class) PojoRawTypeModel<?> var2);

    @Message(id=700023, value="@AssociationInverseSide.inversePath is empty.")
    public SearchException missingInversePathInAssociationInverseSideMapping();

    @Message(id=700027, value="Unable to index type '%1$s': this type is not an entity type. If you only expect subtypes to be instantiated, make this type abstract. If you expect this exact type to be instantiated and want it to be indexed, make it an entity type. Otherwise, ensure this type and its subtypes are never indexed by removing the @Indexed annotation or by annotating the type with @Indexed(enabled = false).")
    public SearchException missingEntityTypeMetadata(@FormatWith(value=PojoTypeModelFormatter.class) PojoRawTypeModel<?> var1);

    @Message(id=700029, value="@IndexingDependency.derivedFrom contains an empty path.")
    public SearchException missingPathInIndexingDependencyDerivedFrom();

    @Message(id=700030, value="Unable to resolve dependencies of a derived property: there is a cyclic dependency starting from type '%1$s'.\nDerivation chain starting from that type and ending with a cycle:%2$s\n A derived property cannot be marked as derived from itself, even indirectly through other  derived properties. If your model actually contains such cyclic dependency,  you should consider disabling automatic reindexing, at least partially  using @IndexingDependency(reindexOnUpdate = ReindexOnUpdate.NO) on one of the properties in the cycle.")
    public SearchException infiniteRecursionForDerivedFrom(@FormatWith(value=PojoTypeModelFormatter.class) PojoRawTypeModel<?> var1, @FormatWith(value=ToStringTreeMultilineFormatter.class) LinkedNode<DerivedDependencyWalkingInfo> var2);

    @Message(id=700031, value="Unable to apply property mapping: this property mapping must target an index field of standard String type, but the resolved field type is non-standard or non-String. This generally means you need to use a different field annotation or to convert property values using a custom ValueBridge or ValueBinder. If you are already using a custom ValueBridge or ValueBinder, check its field type. Details: encountered type DSL step '%1$s', which does not extend the expected interface '%2$s'.")
    public SearchException invalidFieldEncodingForStringFieldMapping(IndexFieldTypeOptionsStep<?, ?> var1, @FormatWith(value=ClassFormatter.class) Class<?> var2);

    @Message(id=700037, value="No matching entity type for type identifier '%1$s'. Either this type is not an entity type, or the entity type is not mapped in Hibernate Search. Valid identifiers for mapped entity types are: %2$s")
    public SearchException unknownTypeIdentifierForMappedEntityType(PojoRawTypeIdentifier<?> var1, Collection<PojoRawTypeIdentifier<?>> var2);

    @Message(id=700039, value="'%1$s' cannot be assigned to '%2$s'")
    public SearchException incompatibleRequestedType(@FormatWith(value=PojoModelPathFormatter.class) PojoModelPathValueNode var1, @FormatWith(value=ClassFormatter.class) Class<?> var2);

    @Message(id=700040, value="No matching indexed entity type for type identifier '%1$s'. Either this type is not an entity type, or the entity type is not indexed in Hibernate Search. Valid identifiers for indexed entity types are: %2$s")
    public SearchException unknownTypeIdentifierForIndexedEntityType(PojoRawTypeIdentifier<?> var1, Collection<PojoRawTypeIdentifier<?>> var2);

    @Message(id=700041, value="Invalid reference to default extractors: a chain of multiple container extractors must not include the default extractors. Either use only the default extractors, or explicitly reference every single extractor to be applied.")
    public SearchException cannotUseDefaultExtractorsInMultiExtractorChain();

    @Message(id=700045, value="A PojoModelPath must include at least one property.")
    public SearchException cannotDefinePojoModelPathWithoutProperty();

    @Message(id=700046, value="Unable to apply path '%2$s' to type '%1$s'. This path was declared as a path to collect entities of type '%3$s' to be reindexed. Hibernate Search needs to apply this path in order to reindex '%3$s' when '%1$s' is modified. Nested exception: %4$s")
    public SearchException cannotApplyExplicitInverseAssociationPath(@FormatWith(value=PojoTypeModelFormatter.class) PojoRawTypeModel<?> var1, @FormatWith(value=PojoModelPathFormatter.class) PojoModelPathValueNode var2, @FormatWith(value=PojoTypeModelFormatter.class) PojoRawTypeModel<?> var3, String var4, @Cause Exception var5);

    @Message(id=700047, value="Invalid use of 'fromOtherEntity': this method can only be used when the bridged element has an entity type, but the bridged element has type '%1$s', which is not an entity type.")
    public SearchException cannotDefineOtherEntityDependencyOnNonEntityBridgedType(@FormatWith(value=PojoTypeModelFormatter.class) PojoRawTypeModel<?> var1);

    @Message(id=700048, value="Invalid type passed to 'fromOtherEntity': the type must be an entity type. Type '%1$s' is not an entity type.")
    public SearchException cannotDefineOtherEntityDependencyFromNonEntityType(@FormatWith(value=PojoTypeModelFormatter.class) PojoRawTypeModel<?> var1);

    @Message(id=700049, value="Incorrect binder implementation: the binder did not declare any dependency to the entity model during binding. Declare dependencies using context.dependencies().use(...) or, if the bridge really does not depend on the entity model, context.dependencies().useRootOnly().")
    public SearchException missingBridgeDependencyDeclaration();

    @Message(id=700050, value="Incorrect binder implementation: the binder called context.dependencies().useRootOnly() during binding, but also declared extra dependencies to the entity model.")
    public SearchException inconsistentBridgeDependencyDeclaration();

    @Message(id=700051, value="Unable to apply property mapping: this property mapping must target an index field of standard, scaled-number type (BigDecimal or BigInteger), but the resolved field type is non-standard or non-scaled. This generally means you need to use a different field annotation or to convert property values using a custom ValueBridge or ValueBinder. If you are already using a custom ValueBridge or ValueBinder, check its field type. Details: encountered type DSL step '%1$s', which does not extend the expected interface '%2$s'.")
    public SearchException invalidFieldEncodingForScaledNumberFieldMapping(IndexFieldTypeOptionsStep<?, ?> var1, @FormatWith(value=ClassFormatter.class) Class<?> var2);

    @Message(id=700052, value="Unexpected extractor references: extractors cannot be defined explicitly when extract = ContainerExtract.NO. Either leave 'extract' to its default value to define extractors explicitly or leave the 'extractor' list to its default, empty value to disable extraction.")
    public SearchException cannotReferenceExtractorsWhenExtractionDisabled();

    @Message(id=700053, value="No container extractor with name '%1$s'. Check that this name matches a container extractor, either a builtin one whose name is a constant in '%2$s' or a custom one that was properly registered.")
    public SearchException cannotResolveContainerExtractorName(String var1, @FormatWith(value=ClassFormatter.class) Class<?> var2);

    @Message(id=700058, value="Incorrect binder implementation: binder '%1$s' did not call context.bridge(...).")
    public SearchException missingBridgeForBinder(Object var1);

    @Message(id=700059, value="Incorrect binder implementation: binder '%1$s' did not call context.marker(...).")
    public SearchException missingMarkerForBinder(Object var1);

    @Message(id=700061, value="Unable to index-embed type '%1$s': no index mapping (@GenericField, @FullTextField, custom bridges, ...) is defined for that type.")
    public SearchException invalidIndexedEmbedded(@FormatWith(value=PojoTypeModelFormatter.class) PojoTypeModel<?> var1);

    @Message(id=700064, value="Multiple entity names assigned to the same type: '%1$s', '%2$s'.")
    public SearchException multipleEntityNames(String var1, String var2);

    @Message(id=700065, value="Unable to apply property mapping: this property mapping must target an index field of standard type, but the resolved field type is non-standard. This generally means you need to use a different field annotation or to convert property values using a custom ValueBridge or ValueBinder. If you are already using a custom ValueBridge or ValueBinder, check its field type. Details: encountered type DSL step '%1$s', which does not extend the expected interface '%2$s'.")
    public SearchException invalidFieldEncodingForStandardFieldMapping(IndexFieldTypeOptionsStep<?, ?> var1, @FormatWith(value=ClassFormatter.class) Class<?> var2);

    @Message(id=700066, value="Unable to apply property mapping: this property mapping must target an index field of non-standard type, but the resolved field type is standard. Switch to a standard field annotation such as @GenericField. Details: encountered type DSL step '%1$s', which does extend the interface '%2$s'.")
    public SearchException invalidFieldEncodingForNonStandardFieldMapping(IndexFieldTypeOptionsStep<?, ?> var1, @FormatWith(value=ClassFormatter.class) Class<?> var2);

    @Message(id=700067, value="Invalid annotation processor: '%1$s'. This processor expects annotations of a different type: '%2$s'.")
    public SearchException invalidAnnotationTypeForAnnotationProcessor(Object var1, @FormatWith(value=ClassFormatter.class) Class<?> var2);

    @Message(id=700068, value="Empty annotation processor reference in meta-annotation '%1$s'.")
    public SearchException missingProcessorReferenceInMappingAnnotation(@FormatWith(value=ClassFormatter.class) Class<? extends Annotation> var1);

    @Message(id=700069, value="Ambiguous @IndexedEmbedded name: both 'name' and 'prefix' are set. Only one can be set. Name is '%1$s', prefix is '%2$s'.")
    public SearchException cannotSetBothIndexedEmbeddedNameAndPrefix(String var1, String var2);

    @Message(id=700070, value="Invalid index field name '%1$s': field names cannot contain a dot ('.').")
    public SearchException invalidFieldNameDotNotAllowed(String var1);

    @Message(id=700071, value="No property annotated with @Alternative(id = %1$s). There must be exactly one such property in order to map property '%2$s' to multi-alternative fields.")
    public SearchException cannotFindAlternativeDiscriminator(String var1, String var2);

    @Message(id=700072, value="Multiple properties annotated with @Alternative(id = %1$s). There must be exactly one such property in order to map property '%2$s' to multi-alternative fields.")
    public SearchException conflictingAlternativeDiscriminators(String var1, String var2);

    @Message(id=700073, value="Invalid routing bridge for entity type '%2$s': '%1$s' This bridge expects an entity type extending '%3$s'.")
    public SearchException invalidInputTypeForRoutingBridge(Object var1, @FormatWith(value=PojoTypeModelFormatter.class) PojoTypeModel<?> var2, @FormatWith(value=PojoTypeModelFormatter.class) PojoTypeModel<?> var3);

    @Message(id=700075, value="Incorrect routing bridge implementation: routing bridge '%1$s' did not define any current route. In the implementation of RoutingBridge.route(...), define exactly one current route by calling 'routes.addRoute()', or explicitly indicate indexing is not required by calling 'routes.notIndexed()'.")
    public SearchException noCurrentRoute(Object var1);

    @Message(id=700076, value="Incorrect routing bridge implementation: routing bridge '%1$s' defined multiple current routes. In the implementation of RoutingBridge.route(...), define at most one current route by calling 'routes.addRoute()' at most once.")
    public SearchException multipleCurrentRoutes(Object var1);

    @Message(id=700077, value="Incorrect routing bridge implementation: routing bridge '%1$s' did not define any previous route. In the implementation of RoutingBridge.previousRoutes(...), define at least one previous route by calling 'routes.addRoute()' at least once, or explicitly indicate no prior indexing was performed by calling 'routes.notIndexed()'.")
    public SearchException noPreviousRoute(Object var1);

    @Message(id=700078, value="No readable property named '%2$s' on type '%1$s'.")
    public SearchException cannotFindReadableProperty(@FormatWith(value=PojoTypeModelFormatter.class) PojoRawTypeModel<?> var1, String var2);

    @Message(id=700079, value="Exception while retrieving property type model for '%1$s' on '%2$s'.")
    public SearchException errorRetrievingPropertyTypeModel(String var1, @FormatWith(value=PojoTypeModelFormatter.class) PojoRawTypeModel<?> var2, @Cause Exception var3);

    @Message(id=700080, value="Unable to infer index field type for value bridge '%1$s': this bridge implements ValueBridge<V, F>, but sets the generic type parameter F to '%2$s'. The index field type can only be inferred automatically when this type parameter is set to a raw class. Use a ValueBinder to set the index field type explicitly, or set the type parameter F to a definite, raw type.")
    public SearchException invalidGenericParameterToInferFieldType(Object var1, @FormatWith(value=TypeFormatter.class) Type var2);

    @Message(id=700081, value="Unable to infer expected identifier type for identifier bridge '%1$s': this bridge implements IdentifierBridge<I>, but sets the generic type parameter I to '%2$s'. The expected identifier type can only be inferred automatically when this type parameter is set to a raw class. Use an IdentifierBinder to set the expected identifier type explicitly, or set the type parameter I to a definite, raw type.")
    public SearchException invalidGenericParameterToInferIdentifierType(Object var1, @FormatWith(value=TypeFormatter.class) Type var2);

    @Message(id=700082, value="Unable to infer expected value type for value bridge '%1$s': this bridge implements ValueBridge<V, F>, but sets the generic type parameter V to '%2$s'. The expected value type can only be inferred automatically when this type parameter is set to a raw class. Use a ValueBinder to set the expected value type explicitly, or set the type parameter V to a definite, raw type.")
    public SearchException invalidGenericParameterToInferValueType(Object var1, @FormatWith(value=TypeFormatter.class) Type var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=700085, value="Multiple getters exist for property named '%2$s' on type '%1$s'. Hibernate Search will use '%3$s' and ignore %4$s. The selected getter may change from one startup to the next. To get rid of this warning, either remove the extra getters or configure the access type for this property to 'FIELD'.")
    public void arbitraryMemberSelection(@FormatWith(value=PojoTypeModelFormatter.class) PojoRawTypeModel<?> var1, String var2, Member var3, List<Member> var4);

    @Message(id=700089, value="No matching entity type for name '%1$s'. Either this is not the name of an entity type, or the entity type is not mapped in Hibernate Search. Valid names for mapped entity types are: %2$s")
    public SearchException unknownEntityNameForMappedEntityType(String var1, Collection<String> var2);

    @Message(id=700110, value="Exception while retrieving parameter type model for parameter #%1$s of '%2$s'.")
    public SearchException errorRetrievingConstructorParameterTypeModel(int var1, PojoConstructorModel<?> var2, @Cause Exception var3);

    @Message(id=700105, value="Cannot work with the identifier of entities of type '%1$s': identifier mapping (@DocumentId, ...) is not configured for this type.")
    public SearchException cannotWorkWithIdentifierBecauseUnconfiguredIdentifierMapping(PojoRawTypeIdentifier<?> var1);

    @Message(id=700107, value="No main constructor for type '%1$s': this type does not declare exactly one constructor.")
    public SearchException cannotFindMainConstructorNotExactlyOneConstructor(@FormatWith(value=PojoTypeModelFormatter.class) PojoRawTypeModel<?> var1);

    @Message(id=700109, value="No constructor with parameter types %2$s on type '%1$s'. Available constructors: %3$s")
    public SearchException cannotFindConstructorWithParameterTypes(@FormatWith(value=PojoTypeModelFormatter.class) PojoRawTypeModel<?> var1, @FormatWith(value=CommaSeparatedClassesFormatter.class) Class<?>[] var2, Collection<? extends PojoConstructorModel<?>> var3);

    @Message(id=700111, value="Exception while retrieving constructor handle for '%1$s' on '%2$s'.")
    public SearchException errorRetrievingConstructorHandle(Constructor<?> var1, @FormatWith(value=PojoTypeModelFormatter.class) PojoRawTypeModel<?> var2, @Cause Exception var3);

    @Message(id=700121, value="Invalid ObjectPath encountered '%1$s': %2$s")
    public SearchException invalidObjectPath(ObjectPath var1, String var2, @Cause Exception var3);

    @Message(id=700122, value="An unexpected failure occurred while configuring resolution of association inverse side for reindexing. This may lead to incomplete reindexing and thus out-of-sync indexes. The exception is being ignored to preserve backwards compatibility with earlier versions of Hibernate Search. Failure: %3$s %2$s Association inverse side: %1$s.")
    public SearchException failedToCreateImplicitReindexingAssociationInverseSideResolverNode(Map<PojoRawTypeModel<?>, PojoModelPathValueNode> var1, @FormatWith(value=EventContextFormatter.class) EventContext var2, String var3, @Cause Exception var4);

    @Message(id=700130, value="No matching entity type for class '%1$s'. Neither this class nor any of its subclasses is mapped in Hibernate Search. Note interfaces are not considered superclasses and are not permitted here. Valid classes are: %2$s")
    public SearchException unknownClassForNonInterfaceSuperType(@FormatWith(value=ClassFormatter.class) Class<?> var1, @FormatWith(value=CommaSeparatedClassesFormatter.class) Collection<Class<?>> var2);

    @Message(id=700131, value="No matching entity type for name '%1$s'. This is not the name of an entity type in Hibernate Search. Valid entity names are: %2$s")
    public SearchException unknownEntityName(String var1, Collection<String> var2);

    @Message(id=700132, value="No matching entity type for type '%1$s'. Neither this type nor any of its subclasses is mapped in Hibernate Search. Note interfaces are not considered superclasses and are not permitted here. Valid types are: %2$s")
    public SearchException unknownNonInterfaceSuperTypeIdentifier(PojoRawTypeIdentifier<?> var1, Set<PojoRawTypeIdentifier<?>> var2);

    @Message(id=700133, value="No parameter at index '%2$s' for constructor '%1$s'.")
    public SearchException cannotFindConstructorParameter(@FormatWith(value=PojoConstructorModelFormatter.class) PojoConstructorModel<?> var1, int var2);

    @Message(id=700142, value="%1$s defines excludePaths filters that do not match anything. Non-matching excludePaths filters: %2$s. Encountered field paths: %3$s. Check the filters for typos, or remove them if they are not useful.")
    public SearchException uselessExcludePathFilters(MappingElement var1, Set<String> var2, Set<String> var3, @Param EventContext var4);

    @Message(id=700143, value="Cyclic recursion when applying the default container extractors to type '%1$s'. Container extractors applied to that type and resulting in the same type: %2$s. To break the cycle, you should consider configuring container extraction explicitly, possibly disabling it for this part of your mapping. See the reference documentation for more information.")
    public SearchException defaultContainerExtractorCyclicRecursion(@FormatWith(value=PojoTypeModelFormatter.class) PojoTypeModel<?> var1, List<String> var2);

    @Message(id=700144, value="Unable to apply property mapping: this property mapping must target an index field of vector type, but the resolved field type is non-vector. This generally means you need to use a different field annotation or to convert property values using a custom ValueBridge or ValueBinder. If you are already using a custom ValueBridge or ValueBinder, check its field type. Details: encountered type DSL step '%1$s', which does not extend the expected interface '%2$s'.")
    public SearchException invalidFieldEncodingForVectorFieldMapping(IndexFieldTypeOptionsStep<?, ?> var1, @FormatWith(value=ClassFormatter.class) Class<?> var2);

    @Message(id=700145, value="Vector dimension is a required property. Either specify it as an annotation property (@VectorField(dimension = somePositiveInteger)), or define a value binder (@VectorField(valueBinder = @ValueBinderRef(..))) that explicitly declares a vector field specifying the dimension.")
    public SearchException vectorDimensionNotSpecified();

    @Message(id=700146, value="Vector fields require an explicit extraction path being specified, i.e. extraction must be set to DEFAULT and a nonempty array of container value extractor names provided, e.g. @ContainerExtraction(extract = ContainerExtract.DEFAULT, value = { ... }).")
    public SearchException vectorFieldMustUseExplicitExtractorPath();

    @Message(id=700147, value="No matching entity type for entity name '%1$s'. Either this is not the name of an entity type, or neither the entity type nor any of its subclasses is mapped in Hibernate Search. Note interfaces are not considered superclasses and are not permitted here. Valid entity names are: %2$s")
    public SearchException unknownEntityNameForNonInterfaceSuperType(String var1, Collection<String> var2);

    @Message(id=700148, value="Multiple entity types configured with the same name '%1$s': '%2$s', '%3$s'")
    public SearchException multipleEntityTypesWithSameName(String var1, @FormatWith(value=MappableTypeModelFormatter.class) PojoRawTypeModel<?> var2, @FormatWith(value=MappableTypeModelFormatter.class) PojoRawTypeModel<?> var3);

    @Message(id=700149, value="Multiple secondary entity names assigned to the same type: '%1$s', '%2$s'.")
    public SearchException multipleSecondaryEntityNames(String var1, String var2);

    @Message(id=700150, value="Multiple entity types configured with the same secondary name '%1$s': '%2$s', '%3$s'")
    public SearchException multipleEntityTypesWithSameSecondaryName(String var1, @FormatWith(value=MappableTypeModelFormatter.class) PojoRawTypeModel<?> var2, @FormatWith(value=MappableTypeModelFormatter.class) PojoRawTypeModel<?> var3);

    @Message(id=700151, value="Invalid type for '%1$s': the entity type must extend '%2$s', but entity type '%3$s' does not.")
    public SearchException invalidEntitySuperType(String var1, @FormatWith(value=ClassFormatter.class) Class<?> var2, @FormatWith(value=ClassFormatter.class) Class<?> var3);

    @Message(id=700152, value="No matching indexed entity types for entity names %1$s. Either these are not the names of entity types, or neither the entity types nor any of their subclasses are indexed in Hibernate Search. Valid entity names are: %2$s.")
    public SearchException invalidIndexedSuperTypeEntityNames(Collection<String> var1, Collection<String> var2);

    @Message(id=700153, value="No matching indexed entity types for classes %1$s. Neither these classes nor any of their subclasses are indexed in Hibernate Search. Valid classes are: %2$s.")
    public SearchException invalidIndexedSuperTypeClasses(@FormatWith(value=CommaSeparatedClassesFormatter.class) Collection<Class<?>> var1, @FormatWith(value=CommaSeparatedClassesFormatter.class) Collection<Class<?>> var2);

    @Message(id=700154, value="No matching indexed entity type for name '%1$s'. Either this is not the name of an entity type, or the entity type is not indexed in Hibernate Search. Valid names for indexed entity types are: %2$s")
    public SearchException unknownEntityNameForIndexedEntityType(String var1, Collection<String> var2);

    @Message(id=700162, value="Using non-default `valueModel=ValueModel.%1$s` and `convert=ValueConvert.%2$s` at the same time is not allowed. Remove the `convert` attribute and keep only the `valueModel=ValueModel.%1$s`.")
    public SearchException usingNonDefaultValueConvertAndValueModelNotAllowed(String var1, String var2, @Param EventContext var3);

    @Message(id=700170, value="Property name '%1$s' cannot contain dots.")
    public IllegalArgumentException propertyNameCannotContainDots(String var1);
}

