/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.processing.impl;

import org.hibernate.search.engine.backend.document.DocumentElement;
import org.hibernate.search.mapper.pojo.common.annotation.impl.SearchProcessingWithContextException;
import org.hibernate.search.mapper.pojo.logging.impl.IndexingLog;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPath;
import org.hibernate.search.mapper.pojo.processing.impl.PojoIndexingProcessor;
import org.hibernate.search.mapper.pojo.processing.spi.PojoIndexingProcessorRootContext;
import org.hibernate.search.mapper.pojo.reporting.spi.PojoEventContexts;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.reflect.spi.ValueReadHandle;
import org.hibernate.search.util.common.spi.ToStringTreeAppender;

public class PojoIndexingProcessorPropertyNode<T, P>
extends PojoIndexingProcessor<T> {
    private final ValueReadHandle<P> handle;
    private final PojoIndexingProcessor<? super P> nested;
    private final PojoModelPath modelPath;

    public PojoIndexingProcessorPropertyNode(ValueReadHandle<P> handle, PojoIndexingProcessor<? super P> nested, PojoModelPath modelPath) {
        this.handle = handle;
        this.nested = nested;
        this.modelPath = modelPath;
    }

    @Override
    public void close() {
        try (Closer closer = new Closer();){
            closer.push(PojoIndexingProcessor::close, this.nested);
        }
    }

    public void appendTo(ToStringTreeAppender appender) {
        appender.attribute("operation", (Object)"process property");
        appender.attribute("handle", this.handle);
        appender.attribute("nested", this.nested);
    }

    @Override
    public final void process(DocumentElement target, T source, PojoIndexingProcessorRootContext context) {
        try {
            Object propertyValue = this.handle.get(source);
            this.nested.process(target, propertyValue, context);
        }
        catch (SearchProcessingWithContextException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw IndexingLog.INSTANCE.searchProcessingFailure(e, e.getMessage(), PojoEventContexts.fromPath(this.modelPath));
        }
    }
}

