/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util.common.impl;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.impl.StringHelper;
import org.hibernate.search.util.common.impl.ToStringStyle;
import org.hibernate.search.util.common.impl.ToStringTreeAppendable;

public class ToStringTreeBuilder {
    private final ToStringStyle style;
    private final StringBuilder builder = new StringBuilder();
    private final Deque<StructureType> structureTypeStack = new ArrayDeque<StructureType>();
    private boolean first = true;

    public ToStringTreeBuilder() {
        this(ToStringStyle.inlineDelimiterStructure());
    }

    public ToStringTreeBuilder(ToStringStyle style) {
        this.style = style;
    }

    public String toString() {
        return this.builder.toString();
    }

    public ToStringTreeBuilder attribute(String name, Object value) {
        if (value instanceof ToStringTreeAppendable) {
            ToStringTreeAppendable appendable = (ToStringTreeAppendable)value;
            this.startEntry(name, StructureType.OBJECT);
            this.startStructure(StructureType.OBJECT, this.style.startObject);
            appendable.appendTo(this);
            this.endStructure(StructureType.OBJECT, this.style.endObject);
            this.endEntry();
        } else {
            this.startEntry(name, null);
            this.builder.append(value);
            this.endEntry();
        }
        return this;
    }

    public ToStringTreeBuilder value(Object value) {
        return this.attribute(null, value);
    }

    public ToStringTreeBuilder startObject() {
        return this.startObject(null);
    }

    public ToStringTreeBuilder startObject(String name) {
        this.startEntry(name, StructureType.OBJECT);
        this.startStructure(StructureType.OBJECT, this.style.startObject);
        return this;
    }

    public ToStringTreeBuilder endObject() {
        this.endStructure(StructureType.OBJECT, this.style.endObject);
        this.endEntry();
        return this;
    }

    public ToStringTreeBuilder startList() {
        return this.startList(null);
    }

    public ToStringTreeBuilder startList(String name) {
        this.startEntry(name, StructureType.LIST);
        this.startStructure(StructureType.LIST, this.style.startList);
        return this;
    }

    public ToStringTreeBuilder endList() {
        this.endStructure(StructureType.LIST, this.style.endList);
        this.endEntry();
        return this;
    }

    private void startEntry(String name, StructureType containedStructureType) {
        StructureType entryType;
        if (!this.first) {
            this.builder.append(this.style.entrySeparator);
        }
        StructureType structureType = entryType = StringHelper.isEmpty(name) ? StructureType.UNNAMED_ENTRY : StructureType.NAMED_ENTRY;
        if (!(this.first && this.structureTypeStack.isEmpty() || this.shouldSqueeze(containedStructureType, entryType, this.structureTypeStack.peek()) || StructureType.UNNAMED_ENTRY.equals((Object)entryType) && StructureType.OBJECT.equals((Object)containedStructureType) && StringHelper.isEmpty(this.style.startObject) || StructureType.UNNAMED_ENTRY.equals((Object)entryType) && StructureType.LIST.equals((Object)containedStructureType) && StringHelper.isEmpty(this.style.startList))) {
            this.appendNewline();
            this.appendIndentIfNecessary();
        }
        if (StringHelper.isNotEmpty(name)) {
            this.builder.append(name);
            this.builder.append(this.style.nameValueSeparator);
        }
        this.structureTypeStack.push(entryType);
    }

    private void endEntry() {
        StructureType lastType = this.structureTypeStack.peek();
        if (lastType == null) {
            throw new AssertionFailure("Cannot pop, already at root");
        }
        if (!StructureType.UNNAMED_ENTRY.equals((Object)lastType) && !StructureType.NAMED_ENTRY.equals((Object)lastType)) {
            throw new AssertionFailure("Cannot pop, not inside an entry");
        }
        this.structureTypeStack.pop();
        this.first = false;
    }

    private void startStructure(StructureType structureType, String startDelimiter) {
        if (StringHelper.isNotEmpty(startDelimiter)) {
            this.builder.append(startDelimiter);
        }
        this.structureTypeStack.push(structureType);
        this.first = true;
    }

    private void endStructure(StructureType structureType, String endDelimiter) {
        StructureType lastType = this.structureTypeStack.peek();
        if (lastType == null) {
            throw new AssertionFailure("Cannot pop, already at root");
        }
        if (lastType != structureType) {
            throw new AssertionFailure("Cannot pop, not inside a " + (Object)((Object)structureType));
        }
        this.structureTypeStack.pop();
        if (StringHelper.isNotEmpty(endDelimiter)) {
            this.appendNewline();
            this.appendIndentIfNecessary();
            this.builder.append(endDelimiter);
        }
        this.first = false;
    }

    private void appendNewline() {
        this.builder.append(this.style.newline);
    }

    private void appendIndentIfNecessary() {
        StructureType child;
        if (this.structureTypeStack.isEmpty()) {
            return;
        }
        Iterator<StructureType> iterator = this.structureTypeStack.descendingIterator();
        StructureType grandParent = null;
        StructureType parent = null;
        StructureType current = iterator.next();
        StructureType structureType = child = iterator.hasNext() ? iterator.next() : null;
        while (current != null) {
            StructureType grandChild;
            StructureType structureType2 = grandChild = iterator.hasNext() ? iterator.next() : null;
            if (!this.shouldSqueeze(current, parent, grandParent)) {
                this.appendIndentIfNecessary(grandChild, child, current, iterator.hasNext());
            }
            grandParent = parent;
            parent = current;
            current = child;
            child = grandChild;
        }
    }

    private void appendIndentIfNecessary(StructureType grandChild, StructureType child, StructureType current, boolean hasParent) {
        switch (current) {
            case OBJECT: {
                this.builder.append(this.style.indentInObject);
                break;
            }
            case LIST: {
                if (child == null || this.shouldSqueeze(grandChild, child, current) && !hasParent && this.first) {
                    this.builder.append(this.style.indentInListBulletPoint);
                    break;
                }
                this.builder.append(this.style.indentInListNoBulletPoint);
                break;
            }
        }
    }

    private boolean shouldSqueeze(StructureType structureType, StructureType parentStructureType, StructureType grandParentStructureType) {
        return this.style.squeezeObjectsInList && StructureType.LIST.equals((Object)grandParentStructureType) && StructureType.UNNAMED_ENTRY.equals((Object)parentStructureType) && StructureType.OBJECT.equals((Object)structureType);
    }

    private static enum StructureType {
        OBJECT,
        LIST,
        NAMED_ENTRY,
        UNNAMED_ENTRY;

    }
}

