/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util.common.impl;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.concurrent.TimeUnit;

public final class TimeHelper {
    private static final int NANOS_PER_MILLI = 1000000;

    private TimeHelper() {
    }

    public static ZonedDateTime parseZoneDateTime(String value, DateTimeFormatter formatter) {
        TemporalAccessor temporal = formatter.parse(value);
        if (!temporal.isSupported(ChronoField.OFFSET_SECONDS)) {
            return ZonedDateTime.from(temporal);
        }
        ZoneId zone = ZoneId.from(temporal);
        ZoneOffset offset = ZoneOffset.from(temporal);
        LocalDateTime ldt = LocalDateTime.from(temporal);
        return ZonedDateTime.ofInstant(ldt, offset, zone);
    }

    public static Long toMillisecondsRoundedUp(Long time, TimeUnit timeUnit) {
        if (time == null || timeUnit == null) {
            return null;
        }
        long nanos = timeUnit.toNanos(time);
        long millis = nanos / 1000000L;
        return nanos % 1000000L == 0L ? millis : millis + 1L;
    }
}

