package org.hibernate.search.util.common.logging.impl;

import java.util.Locale;
import java.io.Serializable;
import javax.annotation.processing.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.hibernate.search.util.common.SearchException;
import java.lang.String;
import java.io.IOException;
import org.jboss.logging.Logger;
import java.net.URI;
import java.net.URL;
import java.lang.reflect.Type;
import org.jboss.logging.BasicLogger;
import java.lang.Runnable;
import java.lang.Throwable;
import java.lang.Class;
import java.util.Arrays;
import java.lang.reflect.Member;
import java.lang.IllegalArgumentException;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2024-04-10T08:36:21+0000")
public class Log_$logger extends DelegatingBasicLogger implements Log, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    public Log_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void interruptedWorkError(final Runnable r) {
        super.log.logf(FQCN, ERROR, null, interruptedWorkError$str(), r);
    }
    protected String interruptedWorkError$str() {
        return "HSEARCH000017: Work discarded, thread was interrupted while waiting for space to schedule: %1$s";
    }
    @Override
    public final void exceptionOccurred(final String errorMsg, final Throwable exceptionThatOccurred) {
        super.log.logf(FQCN, ERROR, exceptionThatOccurred, exceptionOccurred$str(), errorMsg);
    }
    protected String exceptionOccurred$str() {
        return "HSEARCH000058: %1$s";
    }
    protected String mustNotBeNull$str() {
        return "HSEARCH900000: '%1$s' must not be null.";
    }
    @Override
    public final IllegalArgumentException mustNotBeNull(final String objectDescription) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), mustNotBeNull$str(), objectDescription));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String collectionMustNotBeNullNorEmpty$str() {
        return "HSEARCH900001: '%1$s' must not be null or empty.";
    }
    @Override
    public final IllegalArgumentException collectionMustNotBeNullNorEmpty(final String objectDescription) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), collectionMustNotBeNullNorEmpty$str(), objectDescription));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mustBePositiveOrZero$str() {
        return "HSEARCH900002: '%1$s' must be positive or zero.";
    }
    @Override
    public final IllegalArgumentException mustBePositiveOrZero(final String objectDescription) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), mustBePositiveOrZero$str(), objectDescription));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String stringMustNotBeNullNorEmpty$str() {
        return "HSEARCH900003: '%1$s' must not be null or empty.";
    }
    @Override
    public final IllegalArgumentException stringMustNotBeNullNorEmpty(final String objectDescription) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), stringMustNotBeNullNorEmpty$str(), objectDescription));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String arrayMustNotBeNullNorEmpty$str() {
        return "HSEARCH900004: '%1$s' must not be null or empty.";
    }
    @Override
    public final IllegalArgumentException arrayMustNotBeNullNorEmpty(final String objectDescription) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), arrayMustNotBeNullNorEmpty$str(), objectDescription));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String errorInvokingMember$str() {
        return "HSEARCH900005: Exception while invoking '%1$s' on '%2$s': %3$s.";
    }
    @Override
    public final SearchException errorInvokingMember(final Member member, final String componentAsString, final Throwable cause, final String causeMessage) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), errorInvokingMember$str(), member, componentAsString, causeMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotRequestTypeParameterOfUnparameterizedType$str() {
        return "HSEARCH900006: Requested type argument %3$s to type %2$s in implementing type %1$s, but %2$s doesn't declare any type parameter.";
    }
    @Override
    public final IllegalArgumentException cannotRequestTypeParameterOfUnparameterizedType(final Type type, final Class<?> rawSuperType, final int typeArgumentIndex) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), cannotRequestTypeParameterOfUnparameterizedType$str(), new TypeFormatter(type), new ClassFormatter(rawSuperType), typeArgumentIndex));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String typeParameterIndexOutOfBound$str() {
        return "HSEARCH900007: Requested type argument %3$s to type %2$s in implementing type %1$s, but %2$s only declares %4$s type parameter(s).";
    }
    @Override
    public final IllegalArgumentException typeParameterIndexOutOfBound(final Type type, final Class<?> rawSuperType, final int typeArgumentIndex, final int typeParametersLength) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), typeParameterIndexOutOfBound$str(), new TypeFormatter(type), new ClassFormatter(rawSuperType), typeArgumentIndex, typeParametersLength));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidTypeParameterIndex$str() {
        return "HSEARCH900008: Requested type argument index %3$s to type %2$s in implementing type %1$s should be 0 or greater.";
    }
    @Override
    public final IllegalArgumentException invalidTypeParameterIndex(final Type type, final Class<?> rawSuperType, final int typeArgumentIndex) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidTypeParameterIndex$str(), new TypeFormatter(type), new ClassFormatter(rawSuperType), typeArgumentIndex));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void cannotAccessRepeateableContainingAnnotationValue(final Class<?> containingAnnotationType, final Throwable e) {
        super.log.logf(FQCN, INFO, e, cannotAccessRepeateableContainingAnnotationValue$str(), new ClassFormatter(containingAnnotationType));
    }
    protected String cannotAccessRepeateableContainingAnnotationValue$str() {
        return "HSEARCH900009: Unable to access the value of containing annotation '%1$s'. Ignoring annotation.";
    }
    protected String mustBeStrictlyPositive$str() {
        return "HSEARCH900010: '%1$s' must be strictly positive.";
    }
    @Override
    public final IllegalArgumentException mustBeStrictlyPositive(final String objectDescription) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), mustBeStrictlyPositive$str(), objectDescription));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String collectionMustNotContainNullElement$str() {
        return "HSEARCH900011: '%1$s' must not contain any null element.";
    }
    @Override
    public final IllegalArgumentException collectionMustNotContainNullElement(final String collectionDescription) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), collectionMustNotContainNullElement$str(), collectionDescription));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String errorInvokingStaticMember$str() {
        return "HSEARCH900012: Exception while invoking '%1$s' with arguments %2$s: %3$s";
    }
    @Override
    public final SearchException errorInvokingStaticMember(final Member member, final String argumentsAsString, final Throwable cause, final String causeMessage) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), errorInvokingStaticMember$str(), member, argumentsAsString, causeMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String errorAccessingJandexIndex$str() {
        return "HSEARCH900013: Exception while accessing Jandex index for '%1$s': %2$s";
    }
    @Override
    public final SearchException errorAccessingJandexIndex(final URL codeSourceLocation, final String message, final Throwable e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), errorAccessingJandexIndex$str(), codeSourceLocation, message), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String errorBuildingJandexIndex$str() {
        return "HSEARCH900014: Exception while building Jandex index for '%1$s': %2$s";
    }
    @Override
    public final SearchException errorBuildingJandexIndex(final URL codeSourceLocation, final String message, final Throwable e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), errorBuildingJandexIndex$str(), codeSourceLocation, message), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String propertyNameCannotContainDots$str() {
        return "HSEARCH900015: Property name '%1$s' cannot contain dots.";
    }
    @Override
    public final IllegalArgumentException propertyNameCannotContainDots(final String propertyName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), propertyNameCannotContainDots$str(), propertyName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotOpenCodeSourceFileSystem$str() {
        return "HSEARCH900016: Cannot open filesystem for code source at '%1$s': %2$s";
    }
    @Override
    public final IOException cannotOpenCodeSourceFileSystem(final URL url, final String causeMessage, final Throwable e) {
        final IOException result = new IOException(String.format(getLoggingLocale(), cannotOpenCodeSourceFileSystem$str(), url, causeMessage), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotInterpretCodeSourceUrl$str() {
        return "HSEARCH900017: Cannot interpret '%1$s' as a local directory or JAR.";
    }
    @Override
    public final IOException cannotInterpretCodeSourceUrl(final URL url) {
        final IOException result = new IOException(String.format(getLoggingLocale(), cannotInterpretCodeSourceUrl$str(), url));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotOpenNestedJar$str() {
        return "HSEARCH900018: Cannot open a ZIP filesystem for code source at '%1$s', because the URI points to content inside a nested JAR. Run your application on JDK13+ to get nested JAR support, or disable JAR scanning by setting a mapping configurer that calls .discoverAnnotatedTypesFromRootMappingAnnotations(false). See the reference documentation for information about mapping configurers.";
    }
    @Override
    public final SearchException cannotOpenNestedJar(final URI uri, final Throwable e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotOpenNestedJar$str(), uri), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
}
