/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util.common.data.impl;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;

public final class InsertionOrder<T> {
    private final AtomicInteger indexProvider = new AtomicInteger();
    private final Map<T, Key<T>> keys = new ConcurrentHashMap<T, Key<T>>();
    private final Function<? super T, Key<T>> createNewKey = key -> new Key<Object>(this.indexProvider.getAndIncrement(), key);

    public Key<T> wrapKey(T key) {
        return this.keys.computeIfAbsent(key, this.createNewKey);
    }

    public static final class Key<T>
    implements Comparable<Key<?>> {
        private final int index;
        private final T wrapped;

        private Key(int index, T wrapped) {
            this.index = index;
            this.wrapped = wrapped;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return this.index == key.index;
        }

        public int hashCode() {
            return Objects.hash(this.index);
        }

        @Override
        public int compareTo(Key<?> o) {
            return Integer.compare(this.index, o.index);
        }

        public T get() {
            return this.wrapped;
        }
    }
}

