/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util.common.reflect.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.hibernate.search.util.common.impl.Throwables;
import org.hibernate.search.util.common.logging.impl.CommonMiscLog;
import org.hibernate.search.util.common.reflect.spi.ValueCreateHandle;

public final class ConstructorValueCreateHandle<T>
implements ValueCreateHandle<T> {
    private final Constructor<T> constructor;

    public ConstructorValueCreateHandle(Constructor<T> constructor) {
        this.constructor = constructor;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + String.valueOf(this.constructor) + "]";
    }

    @Override
    public int hashCode() {
        return this.constructor.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        ConstructorValueCreateHandle other = (ConstructorValueCreateHandle)obj;
        return this.constructor.equals(other.constructor);
    }

    @Override
    public T create(Object ... arguments) {
        try {
            return this.constructor.newInstance(arguments);
        }
        catch (IllegalAccessException | InstantiationException | RuntimeException e) {
            throw CommonMiscLog.INSTANCE.errorInvokingStaticMember(this.constructor, Throwables.safeToString(e, arguments), e, e.getMessage());
        }
        catch (InvocationTargetException e) {
            Throwable thrown = e.getCause();
            if (thrown instanceof Error) {
                throw (Error)thrown;
            }
            throw CommonMiscLog.INSTANCE.errorInvokingStaticMember(this.constructor, Throwables.safeToString(thrown, arguments), thrown, thrown.getMessage());
        }
    }
}

