/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.impl;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.search.query.dsl.EntityContext;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.dsl.QueryContextBuilder;
import org.hibernate.search.query.dsl.impl.ConnectedQueryBuilder;
import org.hibernate.search.query.dsl.impl.QueryBuildingContext;
import org.hibernate.search.scope.spi.V5MigrationSearchScope;
import org.hibernate.search.spi.SearchIntegrator;

public class ConnectedQueryContextBuilder
implements QueryContextBuilder {
    private final SearchIntegrator integrator;

    public ConnectedQueryContextBuilder(SearchIntegrator integrator) {
        this.integrator = integrator;
    }

    @Override
    public EntityContext forEntity(Class<?> entityType) {
        return new HSearchEntityContext(entityType);
    }

    public final class HSearchEntityContext
    implements EntityContext {
        private final V5MigrationSearchScope scope;
        private final Map<String, String> analyzerOverrides = new HashMap<String, String>();

        public HSearchEntityContext(Class<?> entityType) {
            this.scope = ConnectedQueryContextBuilder.this.integrator.scope(entityType);
        }

        @Override
        public EntityContext overridesForField(String field, String analyzerName) {
            this.analyzerOverrides.put(field, analyzerName);
            return this;
        }

        @Override
        public QueryBuilder get() {
            return new ConnectedQueryBuilder(new QueryBuildingContext(ConnectedQueryContextBuilder.this.integrator, this.scope, this.analyzerOverrides));
        }
    }
}

