/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.bridge.builtin.impl;

import java.lang.invoke.MethodHandles;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collector;
import org.hibernate.search.engine.backend.document.DocumentElement;
import org.hibernate.search.engine.backend.document.IndexFieldReference;
import org.hibernate.search.engine.backend.document.model.dsl.IndexSchemaElement;
import org.hibernate.search.engine.backend.types.Projectable;
import org.hibernate.search.engine.backend.types.Sortable;
import org.hibernate.search.engine.backend.types.converter.FromDocumentValueConverter;
import org.hibernate.search.engine.backend.types.converter.ToDocumentValueConverter;
import org.hibernate.search.engine.backend.types.converter.runtime.FromDocumentValueConvertContext;
import org.hibernate.search.engine.backend.types.converter.runtime.ToDocumentValueConvertContext;
import org.hibernate.search.engine.backend.types.dsl.IndexFieldTypeFactory;
import org.hibernate.search.engine.backend.types.dsl.StandardIndexFieldTypeOptionsStep;
import org.hibernate.search.engine.spatial.GeoPoint;
import org.hibernate.search.mapper.pojo.bridge.PropertyBridge;
import org.hibernate.search.mapper.pojo.bridge.TypeBridge;
import org.hibernate.search.mapper.pojo.bridge.binding.PropertyBindingContext;
import org.hibernate.search.mapper.pojo.bridge.binding.TypeBindingContext;
import org.hibernate.search.mapper.pojo.bridge.builtin.spatial.impl.LatitudeMarker;
import org.hibernate.search.mapper.pojo.bridge.builtin.spatial.impl.LongitudeMarker;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.PropertyBinder;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.TypeBinder;
import org.hibernate.search.mapper.pojo.bridge.runtime.PropertyBridgeWriteContext;
import org.hibernate.search.mapper.pojo.bridge.runtime.TypeBridgeWriteContext;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.model.PojoElementAccessor;
import org.hibernate.search.mapper.pojo.model.PojoModelCompositeElement;
import org.hibernate.search.mapper.pojo.model.PojoModelType;
import org.hibernate.search.spatial.Coordinates;
import org.hibernate.search.spatial.impl.Point;
import org.hibernate.search.util.common.impl.StreamHelper;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class CoordinatesBridge
implements TypeBridge<Object>,
PropertyBridge<Object> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final Function<Object, GeoPoint> coordinatesExtractor;
    private final IndexFieldReference<GeoPoint> indexFieldReference;

    private CoordinatesBridge(Function<Object, GeoPoint> coordinatesExtractor, IndexFieldReference<GeoPoint> indexFieldReference) {
        this.coordinatesExtractor = coordinatesExtractor;
        this.indexFieldReference = indexFieldReference;
    }

    public void write(DocumentElement target, Object bridgedElement, TypeBridgeWriteContext context) {
        this.doWrite(target, bridgedElement);
    }

    public void write(DocumentElement target, Object bridgedElement, PropertyBridgeWriteContext context) {
        this.doWrite(target, bridgedElement);
    }

    private void doWrite(DocumentElement target, Object bridgedElement) {
        GeoPoint coordinates = this.coordinatesExtractor.apply(bridgedElement);
        if (coordinates != null) {
            target.addValue(this.indexFieldReference, (Object)coordinates);
        }
    }

    public void close() {
    }

    private static class CoordinatesConverter
    implements ToDocumentValueConverter<Coordinates, GeoPoint>,
    FromDocumentValueConverter<GeoPoint, Coordinates> {
        static final CoordinatesConverter INSTANCE = new CoordinatesConverter();

        private CoordinatesConverter() {
        }

        public Coordinates fromDocumentValue(GeoPoint value, FromDocumentValueConvertContext context) {
            return value == null ? null : Point.fromDegrees(value.latitude(), value.longitude());
        }

        public GeoPoint toDocumentValue(Coordinates value, ToDocumentValueConvertContext context) {
            return Coordinates.toGeoPoint(value);
        }
    }

    public static class Binder
    implements TypeBinder,
    PropertyBinder {
        private String fieldName;
        private Projectable projectable = Projectable.DEFAULT;
        private String markerSet;

        public Binder fieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public Binder projectable(Projectable projectable) {
            this.projectable = projectable;
            return this;
        }

        public Binder markerSet(String markerSet) {
            this.markerSet = markerSet;
            return this;
        }

        public void bind(TypeBindingContext context) {
            Function<Object, GeoPoint> coordinatesExtractor;
            String defaultedFieldName = this.fieldName != null && !this.fieldName.isEmpty() ? this.fieldName : "_hibernate_default_coordinates";
            PojoModelType bridgedElement = context.bridgedElement();
            if (bridgedElement.isAssignableTo(Coordinates.class)) {
                coordinatesExtractor = coord -> Coordinates.toGeoPoint((Coordinates)coord);
                context.dependencies().use("latitude").use("longitude");
            } else {
                coordinatesExtractor = this.createCoordinatesExtractorUsingMarkers(defaultedFieldName, (PojoModelCompositeElement)bridgedElement);
            }
            CoordinatesBridge bridge = this.doBind(defaultedFieldName, context.typeFactory(), context.indexSchemaElement(), coordinatesExtractor);
            context.bridge((TypeBridge)bridge);
        }

        public void bind(PropertyBindingContext context) {
            String defaultedFieldName = this.fieldName != null && !this.fieldName.isEmpty() ? this.fieldName : context.bridgedElement().name();
            Function<Object, GeoPoint> coordinatesExtractor = this.createCoordinatesExtractorUsingMarkers(defaultedFieldName, (PojoModelCompositeElement)context.bridgedElement());
            CoordinatesBridge bridge = this.doBind(defaultedFieldName, context.typeFactory(), context.indexSchemaElement(), coordinatesExtractor);
            context.bridge((PropertyBridge)bridge);
        }

        private CoordinatesBridge doBind(String defaultedFieldName, IndexFieldTypeFactory typeFactory, IndexSchemaElement indexSchemaElement, Function<Object, GeoPoint> coordinatesExtractor) {
            IndexFieldReference indexFieldReference = (IndexFieldReference)indexSchemaElement.field(defaultedFieldName, ((StandardIndexFieldTypeOptionsStep)((StandardIndexFieldTypeOptionsStep)typeFactory.asGeoPoint().projectable(this.projectable).sortable(Sortable.YES).dslConverter(Coordinates.class, (ToDocumentValueConverter)CoordinatesConverter.INSTANCE)).projectionConverter(Coordinates.class, (FromDocumentValueConverter)CoordinatesConverter.INSTANCE)).toIndexFieldType()).toReference();
            return new CoordinatesBridge(coordinatesExtractor, indexFieldReference);
        }

        private Function<Object, GeoPoint> createCoordinatesExtractorUsingMarkers(String defaultedFieldName, PojoModelCompositeElement bridgedElement) {
            PojoElementAccessor latitudeAccessor = bridgedElement.properties().stream().filter(model -> model.markers(LatitudeMarker.class).stream().map(LatitudeMarker::getMarkerSet).anyMatch(Predicate.isEqual(this.markerSet))).collect(Binder.singleMarkedProperty("latitude", defaultedFieldName, this.markerSet)).createAccessor(Double.class);
            PojoElementAccessor longitudeAccessor = bridgedElement.properties().stream().filter(model -> model.markers(LongitudeMarker.class).stream().map(LongitudeMarker::getMarkerSet).anyMatch(Predicate.isEqual(this.markerSet))).collect(Binder.singleMarkedProperty("longitude", defaultedFieldName, this.markerSet)).createAccessor(Double.class);
            return source -> {
                Double latitude = (Double)latitudeAccessor.read(source);
                Double longitude = (Double)longitudeAccessor.read(source);
                if (latitude == null || longitude == null) {
                    return null;
                }
                return GeoPoint.of((double)latitude, (double)longitude);
            };
        }

        private static Collector<PojoModelCompositeElement, ?, PojoModelCompositeElement> singleMarkedProperty(String markerName, String fieldName, String markerSet) {
            return StreamHelper.singleElement(() -> log.unableToFindLongitudeOrLatitudeProperty(markerName, fieldName, markerSet), () -> log.multipleLatitudeOrLongitudeProperties(markerName, fieldName, markerSet));
        }
    }
}

