/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.Query;
import org.hibernate.search.backend.lucene.LuceneExtension;
import org.hibernate.search.backend.lucene.search.predicate.dsl.LuceneSearchPredicateFactory;
import org.hibernate.search.backend.lucene.search.spi.LuceneMigrationUtils;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.dsl.BooleanPredicateClausesStep;
import org.hibernate.search.engine.search.predicate.dsl.BooleanPredicateOptionsCollector;
import org.hibernate.search.engine.search.predicate.dsl.PredicateScoreStep;
import org.hibernate.search.engine.search.predicate.dsl.SearchPredicateFactory;
import org.hibernate.search.engine.search.predicate.dsl.SearchPredicateFactoryExtension;
import org.hibernate.search.query.dsl.BooleanJunction;
import org.hibernate.search.query.dsl.MustJunction;
import org.hibernate.search.query.dsl.impl.MinimumShouldMatchContextImpl;
import org.hibernate.search.query.dsl.impl.QueryBuildingContext;
import org.hibernate.search.query.dsl.impl.QueryCustomizer;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

class BooleanQueryBuilder
implements MustJunction {
    private static final Log log = LoggerFactory.make(MethodHandles.lookup());
    private final QueryBuildingContext queryContext;
    private final List<BooleanClause> clauses;
    private BooleanClause lastClause;
    private final QueryCustomizer queryCustomizer;
    private MinimumShouldMatchContextImpl minimumShouldMatchContext;

    BooleanQueryBuilder(QueryBuildingContext queryContext) {
        this.queryContext = queryContext;
        this.clauses = new ArrayList<BooleanClause>(5);
        this.queryCustomizer = new QueryCustomizer();
    }

    @Override
    public BooleanJunction not() {
        this.replaceLastMustWith(BooleanClause.Occur.MUST_NOT);
        return this;
    }

    @Override
    public BooleanJunction disableScoring() {
        this.replaceLastMustWith(BooleanClause.Occur.FILTER);
        return this;
    }

    private void replaceLastMustWith(BooleanClause.Occur replacementOccur) {
        if (this.lastClause == null) {
            return;
        }
        if (!this.lastClause.getOccur().equals((Object)BooleanClause.Occur.MUST)) {
            throw new AssertionFailure("Cannot negate or disable scoring on class: " + this.lastClause.getOccur());
        }
        int lastIndex = this.clauses.size() - 1;
        this.clauses.set(lastIndex, new BooleanClause(this.lastClause.getQuery(), replacementOccur));
    }

    @Override
    public BooleanJunction should(Query query) {
        if (query == null) {
            this.lastClause = null;
        } else {
            this.lastClause = new BooleanClause(query, BooleanClause.Occur.SHOULD);
            this.clauses.add(this.lastClause);
        }
        return this;
    }

    @Override
    public MustJunction must(Query query) {
        if (query == null) {
            this.lastClause = null;
        } else {
            this.lastClause = new BooleanClause(query, BooleanClause.Occur.MUST);
            this.clauses.add(this.lastClause);
        }
        return this;
    }

    @Override
    public MustJunction boostedTo(float boost) {
        this.queryCustomizer.boostedTo(boost);
        return this;
    }

    @Override
    public MustJunction withConstantScore() {
        this.queryCustomizer.withConstantScore();
        return this;
    }

    @Override
    public MustJunction filteredBy(Query filter) {
        this.queryCustomizer.filteredBy(filter);
        return this;
    }

    @Override
    public Query createQuery() {
        return LuceneMigrationUtils.toLuceneQuery((SearchPredicate)this.createPredicate());
    }

    private SearchPredicate createPredicate() {
        int nbrOfClauses = this.clauses.size();
        if (nbrOfClauses == 0) {
            throw log.booleanQueryWithoutClauses();
        }
        SearchPredicateFactory factory = this.queryContext.getScope().predicate();
        BooleanPredicateClausesStep step = factory.bool();
        for (BooleanClause clause : this.clauses) {
            SearchPredicate predicate = ((LuceneSearchPredicateFactory)factory.extension((SearchPredicateFactoryExtension)LuceneExtension.get())).fromLuceneQuery(clause.getQuery()).toPredicate();
            switch (clause.getOccur()) {
                case MUST: {
                    step = (BooleanPredicateClausesStep)step.must(predicate);
                    break;
                }
                case FILTER: {
                    step = (BooleanPredicateClausesStep)step.filter(predicate);
                    break;
                }
                case SHOULD: {
                    step = (BooleanPredicateClausesStep)step.should(predicate);
                    break;
                }
                case MUST_NOT: {
                    step = (BooleanPredicateClausesStep)step.mustNot(predicate);
                }
            }
        }
        if (this.minimumShouldMatchContext != null) {
            this.minimumShouldMatchContext.applyMinimum(step);
        }
        this.queryCustomizer.applyScoreOptions((PredicateScoreStep<?>)step);
        this.queryCustomizer.applyFilter(factory, (BooleanPredicateOptionsCollector<?>)step);
        return step.toPredicate();
    }

    @Override
    public boolean isEmpty() {
        return this.clauses.isEmpty();
    }

    @Override
    public BooleanJunction minimumShouldMatchNumber(int matchingClausesNumber) {
        this.getMinimumShouldMatchContext().requireNumber(matchingClausesNumber);
        return this;
    }

    @Override
    public BooleanJunction minimumShouldMatchPercent(int matchingClausesPercent) {
        this.getMinimumShouldMatchContext().requirePercent(matchingClausesPercent);
        return this;
    }

    private MinimumShouldMatchContextImpl getMinimumShouldMatchContext() {
        if (this.minimumShouldMatchContext == null) {
            this.minimumShouldMatchContext = new MinimumShouldMatchContextImpl();
        }
        return this.minimumShouldMatchContext;
    }
}

