/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.impl;

import java.lang.invoke.MethodHandles;
import org.hibernate.search.engine.search.predicate.dsl.BooleanPredicateClausesStep;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

final class MinimumShouldMatchContextImpl {
    private static final Log log = LoggerFactory.make(MethodHandles.lookup());
    private MinimumShouldMatchConstraint minimumShouldMatchConstraint;

    MinimumShouldMatchContextImpl() {
    }

    public void requireNumber(int matchingClausesNumber) {
        this.addMinimumShouldMatchConstraint(new MinimumShouldMatchConstraint(matchingClausesNumber, null));
    }

    public void requirePercent(int matchingClausesPercent) {
        this.addMinimumShouldMatchConstraint(new MinimumShouldMatchConstraint(null, matchingClausesPercent));
    }

    void applyMinimum(BooleanPredicateClausesStep<?> step) {
        if (this.minimumShouldMatchConstraint != null) {
            this.minimumShouldMatchConstraint.apply(step);
        }
    }

    private void addMinimumShouldMatchConstraint(MinimumShouldMatchConstraint constraint) {
        if (this.minimumShouldMatchConstraint != null) {
            throw log.minimumShouldMatchConflictingConstraints();
        }
        this.minimumShouldMatchConstraint = constraint;
    }

    private static final class MinimumShouldMatchConstraint {
        private final Integer matchingClausesNumber;
        private final Integer matchingClausesPercent;

        MinimumShouldMatchConstraint(Integer matchingClausesNumber, Integer matchingClausesPercent) {
            this.matchingClausesNumber = matchingClausesNumber;
            this.matchingClausesPercent = matchingClausesPercent;
        }

        void apply(BooleanPredicateClausesStep<?> step) {
            if (this.matchingClausesNumber != null) {
                step.minimumShouldMatchNumber(this.matchingClausesNumber.intValue());
            } else {
                step.minimumShouldMatchPercent(this.matchingClausesPercent.intValue());
            }
        }
    }
}

