/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.internal.xml;

import java.io.StringWriter;
import org.hibernate.tool.internal.xml.AbstractXMLPrettyPrinterStrategy;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;

public class DOM3LSPrettyPrinterStrategy
extends AbstractXMLPrettyPrinterStrategy {
    private boolean outputComments;

    @Override
    public String prettyPrint(String xml) throws Exception {
        Document document = this.newDocument(xml, "UTF-8");
        DOMImplementationLS domImplementationLS = this.getDomImplementationLS(document);
        LSSerializer lsSerializer = this.newLSSerializer(domImplementationLS);
        LSOutput lsOutput = this.newLSOutput(domImplementationLS);
        StringWriter stringWriter = new StringWriter();
        lsOutput.setCharacterStream(stringWriter);
        lsSerializer.write(document, lsOutput);
        return stringWriter.toString();
    }

    protected DOMImplementationLS getDomImplementationLS(Document document) {
        DOMImplementation domImplementation = document.getImplementation();
        if (domImplementation.hasFeature("LS", "3.0") && domImplementation.hasFeature("Core", "2.0")) {
            return (DOMImplementationLS)domImplementation.getFeature("LS", "3.0");
        }
        throw new RuntimeException("DOM 3.0 LS and/or DOM 2.0 Core not supported.");
    }

    protected LSSerializer newLSSerializer(DOMImplementationLS domImplementationLS) {
        LSSerializer lsSerializer = domImplementationLS.createLSSerializer();
        DOMConfiguration domConfiguration = lsSerializer.getDomConfig();
        if (domConfiguration.canSetParameter("format-pretty-print", Boolean.TRUE)) {
            lsSerializer.getDomConfig().setParameter("format-pretty-print", Boolean.TRUE);
            if (domConfiguration.canSetParameter("comments", this.isOutputComments())) {
                lsSerializer.getDomConfig().setParameter("comments", this.isOutputComments());
            }
            return lsSerializer;
        }
        throw new RuntimeException("DOMConfiguration 'format-pretty-print' parameter isn't settable.");
    }

    protected LSOutput newLSOutput(DOMImplementationLS domImplementationLS) {
        LSOutput lsOutput = domImplementationLS.createLSOutput();
        lsOutput.setEncoding("UTF-8");
        return lsOutput;
    }

    public boolean isOutputComments() {
        return this.outputComments;
    }

    public void setOutputComments(boolean outputComments) {
        this.outputComments = outputComments;
    }
}

