/*
 * Decompiled with CFR 0.152.
 */
package org.hibersap.execution.jco.util;

import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoDestinationManager;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.monitor.JCoConnectionData;
import com.sap.conn.jco.monitor.JCoDestinationMonitor;
import java.util.Date;
import org.hibersap.execution.jco.util.MonitoringData;

public class JCoMonitoringUtil {
    public MonitoringData getMonitoringData(String destinationName) throws JCoException {
        JCoDestination dest = JCoDestinationManager.getDestination((String)destinationName);
        MonitoringData data = new MonitoringData();
        data.setSystemDescription(dest.getAttributes().toString());
        JCoDestinationMonitor monitor = dest.getMonitor();
        data.setPeakLimit(monitor.getPeakLimit());
        data.setPoolCapacity(monitor.getPoolCapacity());
        data.setMaxUsedCount(monitor.getMaxUsedCount());
        data.setPooledConnectionCount(monitor.getPooledConnectionCount());
        data.setUsedConnectionCount(monitor.getUsedConnectionCount());
        data.setLastActivity(new Date(monitor.getLastActivityTimestamp()));
        this.addConnectionData(data, monitor);
        return data;
    }

    private void addConnectionData(MonitoringData data, JCoDestinationMonitor monitor) {
        for (JCoConnectionData jCoConnectionData : monitor.getConnectionsData()) {
            MonitoringData.ConnectionData connectionData = new MonitoringData.ConnectionData();
            connectionData.setAbapClient(jCoConnectionData.getAbapClient());
            connectionData.setAbapHost(jCoConnectionData.getAbapHost());
            connectionData.setAbapLanguage(jCoConnectionData.getAbapLanguage());
            connectionData.setAbapSystemNumber(jCoConnectionData.getAbapSystemNumber());
            connectionData.setAbapUser(jCoConnectionData.getAbapUser());
            connectionData.setApplicationName(jCoConnectionData.getApplicationName());
            connectionData.setConnectionHandle(jCoConnectionData.getConnectionHandleAsString());
            connectionData.setConnectionType(jCoConnectionData.getConnectionType());
            connectionData.setConvId(jCoConnectionData.getConvId());
            connectionData.setDSRPassport(jCoConnectionData.getDSRPassportAsString());
            connectionData.setFunctionModuleName(jCoConnectionData.getFunctionModuleName());
            connectionData.setGroupName(jCoConnectionData.getGroupName());
            connectionData.setLastActivity(new Date(jCoConnectionData.getLastActivityTimestamp()));
            connectionData.setProtocol(jCoConnectionData.getProtocol());
            connectionData.setSessionId(jCoConnectionData.getSessionId());
            connectionData.setState(jCoConnectionData.getStateAsString());
            connectionData.setSystemId(jCoConnectionData.getSystemID());
            connectionData.setThreadId(jCoConnectionData.getThreadIdAsString());
            connectionData.setThreadName(jCoConnectionData.getThreadName());
            data.addConnectionData(connectionData);
        }
    }
}

