/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode.nonstiff;

import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.linear.Array2DRowFieldMatrix;
import org.hipparchus.linear.FieldMatrix;
import org.hipparchus.ode.FieldExpandableODE;
import org.hipparchus.ode.FieldODEState;
import org.hipparchus.ode.FieldODEStateAndDerivative;
import org.hipparchus.ode.nonstiff.AdamsFieldIntegrator;
import org.hipparchus.ode.nonstiff.AdamsFieldStateInterpolator;
import org.hipparchus.util.MathArrays;

public class AdamsBashforthFieldIntegrator<T extends RealFieldElement<T>>
extends AdamsFieldIntegrator<T> {
    private static final String METHOD_NAME = "Adams-Bashforth";

    public AdamsBashforthFieldIntegrator(Field<T> field, int nSteps, double minStep, double maxStep, double scalAbsoluteTolerance, double scalRelativeTolerance) throws MathIllegalArgumentException {
        super(field, METHOD_NAME, nSteps, nSteps, minStep, maxStep, scalAbsoluteTolerance, scalRelativeTolerance);
    }

    public AdamsBashforthFieldIntegrator(Field<T> field, int nSteps, double minStep, double maxStep, double[] vecAbsoluteTolerance, double[] vecRelativeTolerance) throws IllegalArgumentException {
        super(field, METHOD_NAME, nSteps, nSteps, minStep, maxStep, vecAbsoluteTolerance, vecRelativeTolerance);
    }

    private T errorEstimation(T[] previousState, T[] predictedState, T[] predictedScaled, FieldMatrix<T> predictedNordsieck) {
        RealFieldElement error = (RealFieldElement)this.getField().getZero();
        for (int i = 0; i < this.mainSetDimension; ++i) {
            RealFieldElement yScale = (RealFieldElement)predictedState[i].abs();
            RealFieldElement tol = this.vecAbsoluteTolerance == null ? (RealFieldElement)((RealFieldElement)yScale.multiply(this.scalRelativeTolerance)).add(this.scalAbsoluteTolerance) : (RealFieldElement)((RealFieldElement)yScale.multiply(this.vecRelativeTolerance[i])).add(this.vecAbsoluteTolerance[i]);
            RealFieldElement variation = (RealFieldElement)this.getField().getZero();
            int sign = predictedNordsieck.getRowDimension() % 2 == 0 ? -1 : 1;
            for (int k = predictedNordsieck.getRowDimension() - 1; k >= 0; --k) {
                variation = (RealFieldElement)variation.add(((RealFieldElement)predictedNordsieck.getEntry(k, i)).multiply(sign));
                sign = -sign;
            }
            variation = (RealFieldElement)variation.subtract(predictedScaled[i]);
            RealFieldElement ratio = (RealFieldElement)((RealFieldElement)((RealFieldElement)predictedState[i].subtract(previousState[i])).add((Object)variation)).divide((Object)tol);
            error = (RealFieldElement)error.add(ratio.multiply((Object)ratio));
        }
        return (T)((RealFieldElement)((RealFieldElement)error.divide((double)this.mainSetDimension)).sqrt());
    }

    @Override
    public FieldODEStateAndDerivative<T> integrate(FieldExpandableODE<T> equations, FieldODEState<T> initialState, T finalTime) throws MathIllegalArgumentException, MathIllegalStateException {
        this.sanityChecks(initialState, finalTime);
        this.setStepStart(this.initIntegration(equations, initialState, finalTime));
        boolean forward = ((RealFieldElement)finalTime.subtract(initialState.getTime())).getReal() > 0.0;
        this.start(equations, this.getStepStart(), finalTime);
        FieldODEStateAndDerivative stepEnd = AdamsFieldStateInterpolator.taylor(equations.getMapper(), this.getStepStart(), (RealFieldElement)((RealFieldElement)this.getStepStart().getTime().add(this.getStepSize())), this.getStepSize(), (RealFieldElement[])this.scaled, (Array2DRowFieldMatrix)this.nordsieck);
        this.setIsLastStep(false);
        RealFieldElement[] y = this.getStepStart().getCompleteState();
        do {
            RealFieldElement[] predictedY = null;
            RealFieldElement[] predictedScaled = (RealFieldElement[])MathArrays.buildArray(this.getField(), (int)y.length);
            Array2DRowFieldMatrix predictedNordsieck = null;
            RealFieldElement error = (RealFieldElement)((RealFieldElement)this.getField().getZero()).add(10.0);
            while (((RealFieldElement)error.subtract(1.0)).getReal() >= 0.0) {
                predictedY = stepEnd.getCompleteState();
                RealFieldElement[] yDot = this.computeDerivatives((RealFieldElement)stepEnd.getTime(), predictedY);
                for (int j = 0; j < predictedScaled.length; ++j) {
                    predictedScaled[j] = (RealFieldElement)this.getStepSize().multiply((Object)yDot[j]);
                }
                predictedNordsieck = this.updateHighOrderDerivativesPhase1(this.nordsieck);
                this.updateHighOrderDerivativesPhase2(this.scaled, predictedScaled, predictedNordsieck);
                error = this.errorEstimation(y, predictedY, predictedScaled, (FieldMatrix)predictedNordsieck);
                if (!(((RealFieldElement)error.subtract(1.0)).getReal() >= 0.0)) continue;
                RealFieldElement factor = this.computeStepGrowShrinkFactor(error);
                this.rescale(this.filterStep((RealFieldElement)this.getStepSize().multiply((Object)factor), forward, false));
                stepEnd = AdamsFieldStateInterpolator.taylor(equations.getMapper(), this.getStepStart(), (RealFieldElement)((RealFieldElement)this.getStepStart().getTime().add(this.getStepSize())), this.getStepSize(), (RealFieldElement[])this.scaled, (Array2DRowFieldMatrix)this.nordsieck);
            }
            this.setStepStart(this.acceptStep(new AdamsFieldStateInterpolator(this.getStepSize(), stepEnd, predictedScaled, predictedNordsieck, forward, this.getStepStart(), stepEnd, equations.getMapper()), finalTime));
            this.scaled = predictedScaled;
            this.nordsieck = predictedNordsieck;
            if (this.isLastStep()) continue;
            if (this.resetOccurred()) {
                this.start(equations, this.getStepStart(), finalTime);
                RealFieldElement nextT = (RealFieldElement)this.getStepStart().getTime().add(this.getStepSize());
                boolean nextIsLast = forward ? ((RealFieldElement)nextT.subtract(finalTime)).getReal() >= 0.0 : ((RealFieldElement)nextT.subtract(finalTime)).getReal() <= 0.0;
                Object hNew = nextIsLast ? (RealFieldElement)finalTime.subtract(this.getStepStart().getTime()) : this.getStepSize();
                this.rescale(hNew);
                System.arraycopy(this.getStepStart().getCompleteState(), 0, y, 0, y.length);
            } else {
                boolean filteredNextIsLast;
                RealFieldElement factor = this.computeStepGrowShrinkFactor(error);
                RealFieldElement scaledH = (RealFieldElement)this.getStepSize().multiply((Object)factor);
                RealFieldElement nextT = (RealFieldElement)this.getStepStart().getTime().add((Object)scaledH);
                boolean nextIsLast = forward ? ((RealFieldElement)nextT.subtract(finalTime)).getReal() >= 0.0 : ((RealFieldElement)nextT.subtract(finalTime)).getReal() <= 0.0;
                RealFieldElement hNew = this.filterStep(scaledH, forward, nextIsLast);
                RealFieldElement filteredNextT = (RealFieldElement)this.getStepStart().getTime().add((Object)hNew);
                boolean bl = forward ? ((RealFieldElement)filteredNextT.subtract(finalTime)).getReal() >= 0.0 : (filteredNextIsLast = ((RealFieldElement)filteredNextT.subtract(finalTime)).getReal() <= 0.0);
                if (filteredNextIsLast) {
                    hNew = (RealFieldElement)finalTime.subtract(this.getStepStart().getTime());
                }
                this.rescale(hNew);
                System.arraycopy(predictedY, 0, y, 0, y.length);
            }
            stepEnd = AdamsFieldStateInterpolator.taylor(equations.getMapper(), this.getStepStart(), (RealFieldElement)((RealFieldElement)this.getStepStart().getTime().add(this.getStepSize())), this.getStepSize(), (RealFieldElement[])this.scaled, (Array2DRowFieldMatrix)this.nordsieck);
        } while (!this.isLastStep());
        FieldODEStateAndDerivative finalState = this.getStepStart();
        this.setStepStart(null);
        this.setStepSize(null);
        return finalState;
    }
}

