/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode.nonstiff;

import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.ode.FieldEquationsMapper;
import org.hipparchus.ode.FieldODEStateAndDerivative;
import org.hipparchus.ode.nonstiff.RungeKuttaFieldStateInterpolator;

class ClassicalRungeKuttaFieldStateInterpolator<T extends RealFieldElement<T>>
extends RungeKuttaFieldStateInterpolator<T> {
    ClassicalRungeKuttaFieldStateInterpolator(Field<T> field, boolean forward, T[][] yDotK, FieldODEStateAndDerivative<T> globalPreviousState, FieldODEStateAndDerivative<T> globalCurrentState, FieldODEStateAndDerivative<T> softPreviousState, FieldODEStateAndDerivative<T> softCurrentState, FieldEquationsMapper<T> mapper) {
        super(field, forward, yDotK, globalPreviousState, globalCurrentState, softPreviousState, softCurrentState, mapper);
    }

    @Override
    protected ClassicalRungeKuttaFieldStateInterpolator<T> create(Field<T> newField, boolean newForward, T[][] newYDotK, FieldODEStateAndDerivative<T> newGlobalPreviousState, FieldODEStateAndDerivative<T> newGlobalCurrentState, FieldODEStateAndDerivative<T> newSoftPreviousState, FieldODEStateAndDerivative<T> newSoftCurrentState, FieldEquationsMapper<T> newMapper) {
        return new ClassicalRungeKuttaFieldStateInterpolator(newField, newForward, newYDotK, newGlobalPreviousState, newGlobalCurrentState, newSoftPreviousState, newSoftCurrentState, newMapper);
    }

    @Override
    protected FieldODEStateAndDerivative<T> computeInterpolatedStateAndDerivatives(FieldEquationsMapper<T> mapper, T time, T theta, T thetaH, T oneMinusThetaH) {
        RealFieldElement[] interpolatedDerivatives;
        RealFieldElement[] interpolatedState;
        RealFieldElement one = (RealFieldElement)time.getField().getOne();
        RealFieldElement oneMinusTheta = (RealFieldElement)one.subtract(theta);
        RealFieldElement oneMinus2Theta = (RealFieldElement)one.subtract(theta.multiply(2));
        RealFieldElement coeffDot1 = (RealFieldElement)oneMinusTheta.multiply((Object)oneMinus2Theta);
        RealFieldElement coeffDot23 = (RealFieldElement)((RealFieldElement)theta.multiply((Object)oneMinusTheta)).multiply(2);
        RealFieldElement coeffDot4 = (RealFieldElement)((RealFieldElement)theta.multiply((Object)oneMinus2Theta)).negate();
        if (this.getGlobalPreviousState() != null && theta.getReal() <= 0.5) {
            RealFieldElement fourTheta2 = (RealFieldElement)((RealFieldElement)theta.multiply(theta)).multiply(4);
            RealFieldElement s = (RealFieldElement)thetaH.divide(6.0);
            RealFieldElement coeff1 = (RealFieldElement)s.multiply(((RealFieldElement)fourTheta2.subtract(theta.multiply(9))).add(6.0));
            RealFieldElement coeff23 = (RealFieldElement)s.multiply(((RealFieldElement)theta.multiply(6)).subtract((Object)fourTheta2));
            RealFieldElement coeff4 = (RealFieldElement)s.multiply(fourTheta2.subtract(theta.multiply(3)));
            interpolatedState = this.previousStateLinearCombination(new RealFieldElement[]{coeff1, coeff23, coeff23, coeff4});
            interpolatedDerivatives = this.derivativeLinearCombination(new RealFieldElement[]{coeffDot1, coeffDot23, coeffDot23, coeffDot4});
        } else {
            RealFieldElement fourTheta = (RealFieldElement)theta.multiply(4);
            RealFieldElement s = (RealFieldElement)oneMinusThetaH.divide(6.0);
            RealFieldElement coeff1 = (RealFieldElement)s.multiply(((RealFieldElement)theta.multiply(((RealFieldElement)fourTheta.negate()).add(5.0))).subtract(1.0));
            RealFieldElement coeff23 = (RealFieldElement)s.multiply(((RealFieldElement)theta.multiply(fourTheta.subtract(2.0))).subtract(2.0));
            RealFieldElement coeff4 = (RealFieldElement)s.multiply(((RealFieldElement)theta.multiply(((RealFieldElement)fourTheta.negate()).subtract(1.0))).subtract(1.0));
            interpolatedState = this.currentStateLinearCombination(new RealFieldElement[]{coeff1, coeff23, coeff23, coeff4});
            interpolatedDerivatives = this.derivativeLinearCombination(new RealFieldElement[]{coeffDot1, coeffDot23, coeffDot23, coeffDot4});
        }
        return mapper.mapStateAndDerivative((RealFieldElement)time, interpolatedState, interpolatedDerivatives);
    }
}

