/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode.nonstiff;

import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.ode.ExpandableODE;
import org.hipparchus.ode.LocalizedODEFormats;
import org.hipparchus.ode.ODEState;
import org.hipparchus.ode.ODEStateAndDerivative;
import org.hipparchus.ode.nonstiff.AdaptiveStepsizeIntegrator;
import org.hipparchus.ode.nonstiff.GraggBulirschStoerStateInterpolator;
import org.hipparchus.util.FastMath;

public class GraggBulirschStoerIntegrator
extends AdaptiveStepsizeIntegrator {
    private static final String METHOD_NAME = "Gragg-Bulirsch-Stoer";
    private int maxOrder;
    private int[] sequence;
    private int[] costPerStep;
    private double[] costPerTimeUnit;
    private double[] optimalStep;
    private double[][] coeff;
    private boolean performTest;
    private int maxChecks;
    private int maxIter;
    private double stabilityReduction;
    private double stepControl1;
    private double stepControl2;
    private double stepControl3;
    private double stepControl4;
    private double orderControl1;
    private double orderControl2;
    private boolean useInterpolationError;
    private int mudif;

    public GraggBulirschStoerIntegrator(double minStep, double maxStep, double scalAbsoluteTolerance, double scalRelativeTolerance) {
        super(METHOD_NAME, minStep, maxStep, scalAbsoluteTolerance, scalRelativeTolerance);
        this.setStabilityCheck(true, -1, -1, -1.0);
        this.setControlFactors(-1.0, -1.0, -1.0, -1.0);
        this.setOrderControl(-1, -1.0, -1.0);
        this.setInterpolationControl(true, -1);
    }

    public GraggBulirschStoerIntegrator(double minStep, double maxStep, double[] vecAbsoluteTolerance, double[] vecRelativeTolerance) {
        super(METHOD_NAME, minStep, maxStep, vecAbsoluteTolerance, vecRelativeTolerance);
        this.setStabilityCheck(true, -1, -1, -1.0);
        this.setControlFactors(-1.0, -1.0, -1.0, -1.0);
        this.setOrderControl(-1, -1.0, -1.0);
        this.setInterpolationControl(true, -1);
    }

    public void setStabilityCheck(boolean performStabilityCheck, int maxNumIter, int maxNumChecks, double stepsizeReductionFactor) {
        this.performTest = performStabilityCheck;
        this.maxIter = maxNumIter <= 0 ? 2 : maxNumIter;
        this.maxChecks = maxNumChecks <= 0 ? 1 : maxNumChecks;
        this.stabilityReduction = stepsizeReductionFactor < 1.0E-4 || stepsizeReductionFactor > 0.9999 ? 0.5 : stepsizeReductionFactor;
    }

    public void setControlFactors(double control1, double control2, double control3, double control4) {
        this.stepControl1 = control1 < 1.0E-4 || control1 > 0.9999 ? 0.65 : control1;
        this.stepControl2 = control2 < 1.0E-4 || control2 > 0.9999 ? 0.94 : control2;
        this.stepControl3 = control3 < 1.0E-4 || control3 > 0.9999 ? 0.02 : control3;
        this.stepControl4 = control4 < 1.0001 || control4 > 999.9 ? 4.0 : control4;
    }

    public void setOrderControl(int maximalOrder, double control1, double control2) {
        this.maxOrder = maximalOrder > 6 && maximalOrder % 2 == 0 ? maximalOrder : 18;
        this.orderControl1 = control1 < 1.0E-4 || control1 > 0.9999 ? 0.8 : control1;
        this.orderControl2 = control2 < 1.0E-4 || control2 > 0.9999 ? 0.9 : control2;
        this.initializeArrays();
    }

    private void initializeArrays() {
        int k;
        int size = this.maxOrder / 2;
        if (this.sequence == null || this.sequence.length != size) {
            this.sequence = new int[size];
            this.costPerStep = new int[size];
            this.coeff = new double[size][];
            this.costPerTimeUnit = new double[size];
            this.optimalStep = new double[size];
        }
        for (k = 0; k < size; ++k) {
            this.sequence[k] = 4 * k + 2;
        }
        this.costPerStep[0] = this.sequence[0] + 1;
        for (k = 1; k < size; ++k) {
            this.costPerStep[k] = this.costPerStep[k - 1] + this.sequence[k];
        }
        for (k = 0; k < size; ++k) {
            this.coeff[k] = k > 0 ? new double[k] : null;
            for (int l = 0; l < k; ++l) {
                double ratio = (double)this.sequence[k] / (double)this.sequence[k - l - 1];
                this.coeff[k][l] = 1.0 / (ratio * ratio - 1.0);
            }
        }
    }

    public void setInterpolationControl(boolean useInterpolationErrorForControl, int mudifControlParameter) {
        this.useInterpolationError = useInterpolationErrorForControl;
        this.mudif = mudifControlParameter <= 0 || mudifControlParameter >= 7 ? 4 : mudifControlParameter;
    }

    private void rescale(double[] y1, double[] y2, double[] scale) {
        if (this.vecAbsoluteTolerance == null) {
            for (int i = 0; i < scale.length; ++i) {
                double yi = FastMath.max((double)FastMath.abs((double)y1[i]), (double)FastMath.abs((double)y2[i]));
                scale[i] = this.scalAbsoluteTolerance + this.scalRelativeTolerance * yi;
            }
        } else {
            for (int i = 0; i < scale.length; ++i) {
                double yi = FastMath.max((double)FastMath.abs((double)y1[i]), (double)FastMath.abs((double)y2[i]));
                scale[i] = this.vecAbsoluteTolerance[i] + this.vecRelativeTolerance[i] * yi;
            }
        }
    }

    private boolean tryStep(double t0, double[] y0, double step, int k, double[] scale, double[][] f, double[] yMiddle, double[] yEnd) throws MathIllegalArgumentException, MathIllegalStateException {
        int n = this.sequence[k];
        double subStep = step / (double)n;
        double subStep2 = 2.0 * subStep;
        double t = t0 + subStep;
        for (int i = 0; i < y0.length; ++i) {
            yEnd[i] = y0[i] + subStep * f[0][i];
        }
        f[1] = this.computeDerivatives(t, yEnd);
        double[] yTmp = (double[])y0.clone();
        for (int j = 1; j < n; ++j) {
            if (2 * j == n) {
                System.arraycopy(yEnd, 0, yMiddle, 0, y0.length);
            }
            t += subStep;
            for (int i = 0; i < y0.length; ++i) {
                double middle = yEnd[i];
                yEnd[i] = yTmp[i] + subStep2 * f[j][i];
                yTmp[i] = middle;
            }
            f[j + 1] = this.computeDerivatives(t, yEnd);
            if (!this.performTest || j > this.maxChecks || k >= this.maxIter) continue;
            double initialNorm = 0.0;
            for (int l = 0; l < scale.length; ++l) {
                double ratio = f[0][l] / scale[l];
                initialNorm += ratio * ratio;
            }
            double deltaNorm = 0.0;
            for (int l = 0; l < scale.length; ++l) {
                double ratio = (f[j + 1][l] - f[0][l]) / scale[l];
                deltaNorm += ratio * ratio;
            }
            if (!(deltaNorm > 4.0 * FastMath.max((double)1.0E-15, (double)initialNorm))) continue;
            return false;
        }
        for (int i = 0; i < y0.length; ++i) {
            yEnd[i] = 0.5 * (yTmp[i] + yEnd[i] + subStep * f[n][i]);
        }
        return true;
    }

    private void extrapolate(int offset, int k, double[][] diag, double[] last) {
        for (int j = 1; j < k; ++j) {
            for (int i = 0; i < last.length; ++i) {
                diag[k - j - 1][i] = diag[k - j][i] + this.coeff[k + offset][j - 1] * (diag[k - j][i] - diag[k - j - 1][i]);
            }
        }
        for (int i = 0; i < last.length; ++i) {
            last[i] = diag[0][i] + this.coeff[k + offset][k - 1] * (diag[0][i] - last[i]);
        }
    }

    @Override
    public ODEStateAndDerivative integrate(ExpandableODE equations, ODEState initialState, double finalTime) throws MathIllegalArgumentException, MathIllegalStateException {
        this.sanityChecks(initialState, finalTime);
        this.setStepStart(this.initIntegration(equations, initialState, finalTime));
        boolean forward = finalTime > initialState.getTime();
        double[] y = this.getStepStart().getCompleteState();
        double[] y1 = new double[y.length];
        double[][] diagonal = new double[this.sequence.length - 1][];
        double[][] y1Diag = new double[this.sequence.length - 1][];
        for (int k = 0; k < this.sequence.length - 1; ++k) {
            diagonal[k] = new double[y.length];
            y1Diag[k] = new double[y.length];
        }
        double[][][] fk = new double[this.sequence.length][][];
        for (int k = 0; k < this.sequence.length; ++k) {
            fk[k] = new double[this.sequence[k] + 1][];
        }
        double[][] yMidDots = new double[1 + 2 * this.sequence.length][y.length];
        double[] scale = new double[this.mainSetDimension];
        this.rescale(y, y, scale);
        double tol = this.vecRelativeTolerance == null ? this.scalRelativeTolerance : this.vecRelativeTolerance[0];
        double log10R = FastMath.log10((double)FastMath.max((double)1.0E-10, (double)tol));
        int targetIter = FastMath.max((int)1, (int)FastMath.min((int)(this.sequence.length - 2), (int)((int)FastMath.floor((double)(0.5 - 0.6 * log10R)))));
        double hNew = 0.0;
        double maxError = Double.MAX_VALUE;
        boolean previousRejected = false;
        boolean firstTime = true;
        boolean newStep = true;
        this.costPerTimeUnit[0] = 0.0;
        this.setIsLastStep(false);
        do {
            GraggBulirschStoerStateInterpolator interpolator;
            boolean reject = false;
            if (newStep) {
                double[] yDot0 = this.getStepStart().getCompleteDerivative();
                for (int k = 0; k < this.sequence.length; ++k) {
                    fk[k][0] = yDot0;
                }
                if (firstTime) {
                    hNew = this.initializeStep(forward, 2 * targetIter + 1, scale, this.getStepStart(), equations.getMapper());
                }
                newStep = false;
            }
            this.setStepSize(hNew);
            if (forward) {
                if (this.getStepStart().getTime() + this.getStepSize() >= finalTime) {
                    this.setStepSize(finalTime - this.getStepStart().getTime());
                }
            } else if (this.getStepStart().getTime() + this.getStepSize() <= finalTime) {
                this.setStepSize(finalTime - this.getStepStart().getTime());
            }
            double nextT = this.getStepStart().getTime() + this.getStepSize();
            this.setIsLastStep(forward ? nextT >= finalTime : nextT <= finalTime);
            int k = -1;
            boolean loop = true;
            block9: while (loop) {
                if (!this.tryStep(this.getStepStart().getTime(), y, this.getStepSize(), k, scale, fk[++k], k == 0 ? yMidDots[0] : diagonal[k - 1], k == 0 ? y1 : y1Diag[k - 1])) {
                    hNew = FastMath.abs((double)this.filterStep(this.getStepSize() * this.stabilityReduction, forward, false));
                    reject = true;
                    loop = false;
                    continue;
                }
                if (k <= 0) continue;
                this.extrapolate(0, k, y1Diag, y1);
                this.rescale(y, y1, scale);
                double error = 0.0;
                for (int j = 0; j < this.mainSetDimension; ++j) {
                    double e = FastMath.abs((double)(y1[j] - y1Diag[0][j])) / scale[j];
                    error += e * e;
                }
                if (Double.isNaN(error = FastMath.sqrt((double)(error / (double)this.mainSetDimension)))) {
                    throw new MathIllegalStateException((Localizable)LocalizedODEFormats.NAN_APPEARING_DURING_INTEGRATION, new Object[]{nextT});
                }
                if (error > 1.0E15 || k > 1 && error > maxError) {
                    hNew = FastMath.abs((double)this.filterStep(this.getStepSize() * this.stabilityReduction, forward, false));
                    reject = true;
                    loop = false;
                    continue;
                }
                maxError = FastMath.max((double)(4.0 * error), (double)1.0);
                double exp = 1.0 / (double)(2 * k + 1);
                double fac = this.stepControl2 / FastMath.pow((double)(error / this.stepControl1), (double)exp);
                double pow = FastMath.pow((double)this.stepControl3, (double)exp);
                fac = FastMath.max((double)(pow / this.stepControl4), (double)FastMath.min((double)(1.0 / pow), (double)fac));
                boolean acceptSmall = k < targetIter;
                this.optimalStep[k] = FastMath.abs((double)this.filterStep(this.getStepSize() * fac, forward, acceptSmall));
                this.costPerTimeUnit[k] = (double)this.costPerStep[k] / this.optimalStep[k];
                switch (k - targetIter) {
                    case -1: {
                        if (targetIter <= 1 || previousRejected) continue block9;
                        if (error <= 1.0) {
                            loop = false;
                            break;
                        }
                        double ratio = (double)this.sequence[targetIter] * (double)this.sequence[targetIter + 1] / (double)(this.sequence[0] * this.sequence[0]);
                        if (!(error > ratio * ratio)) continue block9;
                        reject = true;
                        loop = false;
                        targetIter = k;
                        if (targetIter > 1 && this.costPerTimeUnit[targetIter - 1] < this.orderControl1 * this.costPerTimeUnit[targetIter]) {
                            --targetIter;
                        }
                        hNew = this.filterStep(this.optimalStep[targetIter], forward, false);
                        break;
                    }
                    case 0: {
                        if (error <= 1.0) {
                            loop = false;
                            break;
                        }
                        double ratio = (double)this.sequence[k + 1] / (double)this.sequence[0];
                        if (!(error > ratio * ratio)) continue block9;
                        reject = true;
                        loop = false;
                        if (targetIter > 1 && this.costPerTimeUnit[targetIter - 1] < this.orderControl1 * this.costPerTimeUnit[targetIter]) {
                            --targetIter;
                        }
                        hNew = this.filterStep(this.optimalStep[targetIter], forward, false);
                        break;
                    }
                    case 1: {
                        if (error > 1.0) {
                            reject = true;
                            if (targetIter > 1 && this.costPerTimeUnit[targetIter - 1] < this.orderControl1 * this.costPerTimeUnit[targetIter]) {
                                --targetIter;
                            }
                            hNew = this.filterStep(this.optimalStep[targetIter], forward, false);
                        }
                        loop = false;
                        break;
                    }
                    default: {
                        if (!firstTime && !this.isLastStep() || !(error <= 1.0)) continue block9;
                        loop = false;
                    }
                }
            }
            double hInt = this.getMaxStep();
            if (!reject) {
                for (int j = 1; j <= k; ++j) {
                    this.extrapolate(0, j, diagonal, yMidDots[0]);
                }
                int mu = 2 * k - this.mudif + 3;
                for (int l = 0; l < mu; ++l) {
                    int j;
                    int i;
                    int l2 = l / 2;
                    double factor = FastMath.pow((double)(0.5 * (double)this.sequence[l2]), (int)l);
                    int middleIndex = fk[l2].length / 2;
                    for (i = 0; i < y.length; ++i) {
                        yMidDots[l + 1][i] = factor * fk[l2][middleIndex + l][i];
                    }
                    for (j = 1; j <= k - l2; ++j) {
                        factor = FastMath.pow((double)(0.5 * (double)this.sequence[j + l2]), (int)l);
                        middleIndex = fk[l2 + j].length / 2;
                        for (int i2 = 0; i2 < y.length; ++i2) {
                            diagonal[j - 1][i2] = factor * fk[l2 + j][middleIndex + l][i2];
                        }
                        this.extrapolate(l2, j, diagonal, yMidDots[l + 1]);
                    }
                    i = 0;
                    while (i < y.length) {
                        double[] dArray = yMidDots[l + 1];
                        int n = i++;
                        dArray[n] = dArray[n] * this.getStepSize();
                    }
                    for (j = (l + 1) / 2; j <= k; ++j) {
                        for (int m = fk[j].length - 1; m >= 2 * (l + 1); --m) {
                            for (int i3 = 0; i3 < y.length; ++i3) {
                                double[] dArray = fk[j][m];
                                int n = i3;
                                dArray[n] = dArray[n] - fk[j][m - 2][i3];
                            }
                        }
                    }
                }
                ODEStateAndDerivative stepEnd = equations.getMapper().mapStateAndDerivative(nextT, y1, this.computeDerivatives(nextT, y1));
                interpolator = new GraggBulirschStoerStateInterpolator(forward, this.getStepStart(), stepEnd, this.getStepStart(), stepEnd, equations.getMapper(), yMidDots, mu);
                if (mu >= 0 && this.useInterpolationError) {
                    double interpError = interpolator.estimateError(scale);
                    hInt = FastMath.abs((double)(this.getStepSize() / FastMath.max((double)FastMath.pow((double)interpError, (double)(1.0 / (double)(mu + 4))), (double)0.01)));
                    if (interpError > 10.0) {
                        hNew = this.filterStep(hInt, forward, false);
                        reject = true;
                    }
                }
            } else {
                interpolator = null;
            }
            if (!reject) {
                int optimalIter;
                this.setStepStart(this.acceptStep(interpolator, finalTime));
                y = this.getStepStart().getCompleteState();
                if (k == 1) {
                    optimalIter = 2;
                    if (previousRejected) {
                        optimalIter = 1;
                    }
                } else if (k <= targetIter) {
                    optimalIter = k;
                    if (this.costPerTimeUnit[k - 1] < this.orderControl1 * this.costPerTimeUnit[k]) {
                        optimalIter = k - 1;
                    } else if (this.costPerTimeUnit[k] < this.orderControl2 * this.costPerTimeUnit[k - 1]) {
                        optimalIter = FastMath.min((int)(k + 1), (int)(this.sequence.length - 2));
                    }
                } else {
                    optimalIter = k - 1;
                    if (k > 2 && this.costPerTimeUnit[k - 2] < this.orderControl1 * this.costPerTimeUnit[k - 1]) {
                        optimalIter = k - 2;
                    }
                    if (this.costPerTimeUnit[k] < this.orderControl2 * this.costPerTimeUnit[optimalIter]) {
                        optimalIter = FastMath.min((int)k, (int)(this.sequence.length - 2));
                    }
                }
                if (previousRejected) {
                    targetIter = FastMath.min((int)optimalIter, (int)k);
                    hNew = FastMath.min((double)FastMath.abs((double)this.getStepSize()), (double)this.optimalStep[targetIter]);
                } else {
                    hNew = optimalIter <= k ? this.filterStep(this.optimalStep[optimalIter], forward, false) : (k < targetIter && this.costPerTimeUnit[k] < this.orderControl2 * this.costPerTimeUnit[k - 1] ? this.filterStep(this.optimalStep[k] * (double)this.costPerStep[optimalIter + 1] / (double)this.costPerStep[k], forward, false) : this.filterStep(this.optimalStep[k] * (double)this.costPerStep[optimalIter] / (double)this.costPerStep[k], forward, false));
                    targetIter = optimalIter;
                }
                newStep = true;
            }
            hNew = FastMath.min((double)hNew, (double)hInt);
            if (!forward) {
                hNew = -hNew;
            }
            firstTime = false;
            if (reject) {
                this.setIsLastStep(false);
                previousRejected = true;
                continue;
            }
            previousRejected = false;
        } while (!this.isLastStep());
        ODEStateAndDerivative finalState = this.getStepStart();
        this.resetInternalState();
        return finalState;
    }
}

