/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.descriptive.moment;

import java.io.Serializable;
import org.hipparchus.exception.NullArgumentException;
import org.hipparchus.stat.descriptive.AggregatableStatistic;
import org.hipparchus.stat.descriptive.moment.FirstMoment;

public class SecondMoment
extends FirstMoment
implements AggregatableStatistic<SecondMoment>,
Serializable {
    private static final long serialVersionUID = 20150412L;
    protected double m2;

    public SecondMoment() {
        this.m2 = Double.NaN;
    }

    public SecondMoment(SecondMoment original) throws NullArgumentException {
        super(original);
        this.m2 = original.m2;
    }

    @Override
    public void increment(double d) {
        if (this.n < 1L) {
            this.m2 = 0.0;
            this.m1 = 0.0;
        }
        super.increment(d);
        this.m2 += ((double)this.n - 1.0) * this.dev * this.nDev;
    }

    @Override
    public void clear() {
        super.clear();
        this.m2 = Double.NaN;
    }

    @Override
    public double getResult() {
        return this.m2;
    }

    @Override
    public void aggregate(SecondMoment other) {
        if (other.n > 0L) {
            double oldN = this.n;
            super.aggregate(other);
            this.m2 = oldN == 0.0 ? other.m2 : (this.m2 += other.m2 + (double)other.n * oldN / (double)this.n * this.dev * this.dev);
        }
    }

    @Override
    public SecondMoment copy() {
        return new SecondMoment(this);
    }
}

