/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.integration.sdk.internal.operation.page;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import org.hisp.dhis.api.model.Page;
import org.hisp.dhis.integration.sdk.api.Dhis2ClientException;
import org.hisp.dhis.integration.sdk.api.Dhis2Response;
import org.hisp.dhis.integration.sdk.api.converter.ConverterFactory;
import org.hisp.dhis.integration.sdk.internal.DefaultDhis2Response;

public class PageIterable<T>
implements Iterable<T> {
    private Dhis2Response dhis2Response;
    private Page currentPage;
    private Iterator<T> currentIterator;
    private final ConverterFactory converterFactory;
    private final String collectionName;
    private final Class<T> responseType;
    private final OkHttpClient httpClient;

    public PageIterable(String collectionName, ConverterFactory converterFactory, OkHttpClient httpClient, Class<T> responseType, Page firstPage) {
        List collection = (List)converterFactory.createResponseConverter(responseType).convert((List)firstPage.getAdditionalProperties().get(collectionName));
        this.currentIterator = collection.iterator();
        this.currentPage = firstPage;
        this.collectionName = collectionName;
        this.converterFactory = converterFactory;
        this.httpClient = httpClient;
        this.responseType = responseType;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                if (PageIterable.this.currentIterator.hasNext()) {
                    return true;
                }
                if (PageIterable.this.currentPage.getPager().getPage() >= PageIterable.this.currentPage.getPager().getPageCount()) {
                    return false;
                }
                PageIterable.this.currentIterator = this.fetchPage();
                return PageIterable.this.currentIterator.hasNext();
            }

            @Override
            public T next() {
                if (!PageIterable.this.currentIterator.hasNext()) {
                    PageIterable.this.currentIterator = this.fetchPage();
                }
                return PageIterable.this.currentIterator.next();
            }

            private Iterator<T> fetchPage() {
                try {
                    PageIterable.this.dhis2Response = new DefaultDhis2Response(PageIterable.this.httpClient.newCall(new Request.Builder().url(PageIterable.this.currentPage.getPager().getNextPage()).build()).execute(), PageIterable.this.converterFactory);
                }
                catch (IOException e) {
                    throw new Dhis2ClientException(e);
                }
                PageIterable.this.currentPage = PageIterable.this.dhis2Response.returnAs(Page.class);
                List collection = (List)PageIterable.this.converterFactory.createResponseConverter(PageIterable.this.responseType).convert((List)PageIterable.this.currentPage.getAdditionalProperties().get(PageIterable.this.collectionName));
                return collection.iterator();
            }
        };
    }
}

