/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.integration.sdk.support.period.type;

import java.util.Calendar;
import org.hisp.dhis.integration.sdk.support.period.type.AbstractPeriod;

public class YearlyPeriod
extends AbstractPeriod {
    protected final int firstMonth;
    protected final String suffix;

    public YearlyPeriod(Calendar calendar, int firstMonth, String suffix) {
        super(calendar, "yyyy");
        this.firstMonth = firstMonth;
        this.suffix = suffix;
    }

    @Override
    protected void moveToStartOfCurrentPeriod() {
        this.calendar.set(5, 1);
        if (this.calendar.get(2) < this.firstMonth) {
            this.calendar.add(1, -1);
        }
        this.calendar.set(2, this.firstMonth);
    }

    @Override
    protected void moveToStartOfCurrentYear() {
        this.calendar.set(5, 1);
        this.calendar.set(2, this.firstMonth);
    }

    @Override
    protected String formatTime() {
        return this.idFormatter.format(this.calendar.getTime()) + this.suffix;
    }

    @Override
    protected void movePeriods(int number) {
        this.calendar.add(1, number);
    }
}

