
package org.hisp.dhis.api.model.v2_35_13;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "authorities",
    "type"
})
@Generated("jsonschema2pojo")
public class Authority implements Serializable
{

    @JsonProperty("authorities")
    private List<String> authorities = null;
    @JsonProperty("type")
    private Authority.AuthorityType type;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 2351549271784383658L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Authority() {
    }

    /**
     * 
     * @param source
     */
    public Authority(Authority source) {
        super();
        this.authorities = source.authorities;
        this.type = source.type;
    }

    /**
     * 
     * @param type
     * @param authorities
     */
    public Authority(List<String> authorities, Authority.AuthorityType type) {
        super();
        this.authorities = authorities;
        this.type = type;
    }

    @JsonProperty("authorities")
    public Optional<List<String>> getAuthorities() {
        return Optional.ofNullable(authorities);
    }

    @JsonProperty("authorities")
    public void setAuthorities(List<String> authorities) {
        this.authorities = authorities;
    }

    public Authority withAuthorities(List<String> authorities) {
        this.authorities = authorities;
        return this;
    }

    @JsonProperty("type")
    public Optional<Authority.AuthorityType> getType() {
        return Optional.ofNullable(type);
    }

    @JsonProperty("type")
    public void setType(Authority.AuthorityType type) {
        this.type = type;
    }

    public Authority withType(Authority.AuthorityType type) {
        this.type = type;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public Authority withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "authorities":
                if (value instanceof List) {
                    setAuthorities(((List<String> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"authorities\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "type":
                if (value instanceof Authority.AuthorityType) {
                    setType(((Authority.AuthorityType) value));
                } else {
                    throw new IllegalArgumentException(("property \"type\" is of type \"org.hisp.dhis.api.model.v2_35_13.Authority.AuthorityType\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "authorities":
                return getAuthorities();
            case "type":
                return getType();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, Authority.NOT_FOUND_VALUE);
        if (Authority.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public Authority with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Authority.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("authorities");
        sb.append('=');
        sb.append(((this.authorities == null)?"<null>":this.authorities));
        sb.append(',');
        sb.append("type");
        sb.append('=');
        sb.append(((this.type == null)?"<null>":this.type));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.type == null)? 0 :this.type.hashCode()));
        result = ((result* 31)+((this.authorities == null)? 0 :this.authorities.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Authority) == false) {
            return false;
        }
        Authority rhs = ((Authority) other);
        return ((((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties)))&&((this.type == rhs.type)||((this.type!= null)&&this.type.equals(rhs.type))))&&((this.authorities == rhs.authorities)||((this.authorities!= null)&&this.authorities.equals(rhs.authorities))));
    }

    @Generated("jsonschema2pojo")
    public enum AuthorityType {

        CREATE("CREATE"),
        DATA_CREATE("DATA_CREATE"),
        CREATE_PUBLIC("CREATE_PUBLIC"),
        CREATE_PRIVATE("CREATE_PRIVATE"),
        EXTERNALIZE("EXTERNALIZE"),
        READ("READ"),
        DATA_READ("DATA_READ"),
        UPDATE("UPDATE"),
        DELETE("DELETE");
        private final String value;
        private final static Map<String, Authority.AuthorityType> CONSTANTS = new HashMap<String, Authority.AuthorityType>();

        static {
            for (Authority.AuthorityType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        AuthorityType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Authority.AuthorityType fromValue(String value) {
            Authority.AuthorityType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
