
package org.hisp.dhis.api.model.v2_35_13;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "access",
    "allowMultiple",
    "attributeValues",
    "code",
    "created",
    "displayName",
    "externalAccess",
    "favorite",
    "favorites",
    "href",
    "id",
    "key",
    "lastSentAt",
    "lastUpdated",
    "lastUpdatedBy",
    "name",
    "notificationTemplateUid",
    "notificationTriggeredBy",
    "publicAccess",
    "retries",
    "translations",
    "user",
    "userAccesses",
    "userGroupAccesses"
})
@Generated("jsonschema2pojo")
public class ExternalNotificationLogEntry implements Serializable
{

    @JsonProperty("access")
    private Access access;
    @JsonProperty("allowMultiple")
    private Boolean allowMultiple;
    @JsonProperty("attributeValues")
    private List<AttributeValue> attributeValues = null;
    @JsonProperty("code")
    private String code;
    @JsonProperty("created")
    private Date created;
    @JsonProperty("displayName")
    private String displayName;
    @JsonProperty("externalAccess")
    private Boolean externalAccess;
    @JsonProperty("favorite")
    private Boolean favorite;
    @JsonProperty("favorites")
    private List<String> favorites = null;
    @JsonProperty("href")
    private String href;
    @JsonProperty("id")
    private String id;
    @JsonProperty("key")
    private String key;
    @JsonProperty("lastSentAt")
    private Date lastSentAt;
    @JsonProperty("lastUpdated")
    private Date lastUpdated;
    @JsonProperty("lastUpdatedBy")
    private User lastUpdatedBy;
    @JsonProperty("name")
    private String name;
    @JsonProperty("notificationTemplateUid")
    private String notificationTemplateUid;
    @JsonProperty("notificationTriggeredBy")
    private ExternalNotificationLogEntry.NotificationTriggerEvent notificationTriggeredBy;
    @JsonProperty("publicAccess")
    private String publicAccess;
    @JsonProperty("retries")
    private Integer retries;
    @JsonProperty("translations")
    private List<Translation> translations = null;
    @JsonProperty("user")
    private User user;
    @JsonProperty("userAccesses")
    private List<UserAccess> userAccesses = null;
    @JsonProperty("userGroupAccesses")
    private List<UserGroupAccess> userGroupAccesses = null;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -1777353564355726188L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ExternalNotificationLogEntry() {
    }

    /**
     * 
     * @param source
     */
    public ExternalNotificationLogEntry(ExternalNotificationLogEntry source) {
        super();
        this.access = source.access;
        this.allowMultiple = source.allowMultiple;
        this.attributeValues = source.attributeValues;
        this.code = source.code;
        this.created = source.created;
        this.displayName = source.displayName;
        this.externalAccess = source.externalAccess;
        this.favorite = source.favorite;
        this.favorites = source.favorites;
        this.href = source.href;
        this.id = source.id;
        this.key = source.key;
        this.lastSentAt = source.lastSentAt;
        this.lastUpdated = source.lastUpdated;
        this.lastUpdatedBy = source.lastUpdatedBy;
        this.name = source.name;
        this.notificationTemplateUid = source.notificationTemplateUid;
        this.notificationTriggeredBy = source.notificationTriggeredBy;
        this.publicAccess = source.publicAccess;
        this.retries = source.retries;
        this.translations = source.translations;
        this.user = source.user;
        this.userAccesses = source.userAccesses;
        this.userGroupAccesses = source.userGroupAccesses;
    }

    /**
     * 
     * @param favorites
     * @param lastUpdatedBy
     * @param access
     * @param code
     * @param userGroupAccesses
     * @param created
     * @param displayName
     * @param publicAccess
     * @param attributeValues
     * @param lastSentAt
     * @param notificationTriggeredBy
     * @param externalAccess
     * @param lastUpdated
     * @param retries
     * @param allowMultiple
     * @param translations
     * @param userAccesses
     * @param name
     * @param href
     * @param id
     * @param notificationTemplateUid
     * @param favorite
     * @param user
     * @param key
     */
    public ExternalNotificationLogEntry(Access access, Boolean allowMultiple, List<AttributeValue> attributeValues, String code, Date created, String displayName, Boolean externalAccess, Boolean favorite, List<String> favorites, String href, String id, String key, Date lastSentAt, Date lastUpdated, User lastUpdatedBy, String name, String notificationTemplateUid, ExternalNotificationLogEntry.NotificationTriggerEvent notificationTriggeredBy, String publicAccess, Integer retries, List<Translation> translations, User user, List<UserAccess> userAccesses, List<UserGroupAccess> userGroupAccesses) {
        super();
        this.access = access;
        this.allowMultiple = allowMultiple;
        this.attributeValues = attributeValues;
        this.code = code;
        this.created = created;
        this.displayName = displayName;
        this.externalAccess = externalAccess;
        this.favorite = favorite;
        this.favorites = favorites;
        this.href = href;
        this.id = id;
        this.key = key;
        this.lastSentAt = lastSentAt;
        this.lastUpdated = lastUpdated;
        this.lastUpdatedBy = lastUpdatedBy;
        this.name = name;
        this.notificationTemplateUid = notificationTemplateUid;
        this.notificationTriggeredBy = notificationTriggeredBy;
        this.publicAccess = publicAccess;
        this.retries = retries;
        this.translations = translations;
        this.user = user;
        this.userAccesses = userAccesses;
        this.userGroupAccesses = userGroupAccesses;
    }

    @JsonProperty("access")
    public Optional<Access> getAccess() {
        return Optional.ofNullable(access);
    }

    @JsonProperty("access")
    public void setAccess(Access access) {
        this.access = access;
    }

    public ExternalNotificationLogEntry withAccess(Access access) {
        this.access = access;
        return this;
    }

    @JsonProperty("allowMultiple")
    public Optional<Boolean> getAllowMultiple() {
        return Optional.ofNullable(allowMultiple);
    }

    @JsonProperty("allowMultiple")
    public void setAllowMultiple(Boolean allowMultiple) {
        this.allowMultiple = allowMultiple;
    }

    public ExternalNotificationLogEntry withAllowMultiple(Boolean allowMultiple) {
        this.allowMultiple = allowMultiple;
        return this;
    }

    @JsonProperty("attributeValues")
    public Optional<List<AttributeValue>> getAttributeValues() {
        return Optional.ofNullable(attributeValues);
    }

    @JsonProperty("attributeValues")
    public void setAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
    }

    public ExternalNotificationLogEntry withAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
        return this;
    }

    @JsonProperty("code")
    public Optional<String> getCode() {
        return Optional.ofNullable(code);
    }

    @JsonProperty("code")
    public void setCode(String code) {
        this.code = code;
    }

    public ExternalNotificationLogEntry withCode(String code) {
        this.code = code;
        return this;
    }

    @JsonProperty("created")
    public Optional<Date> getCreated() {
        return Optional.ofNullable(created);
    }

    @JsonProperty("created")
    public void setCreated(Date created) {
        this.created = created;
    }

    public ExternalNotificationLogEntry withCreated(Date created) {
        this.created = created;
        return this;
    }

    @JsonProperty("displayName")
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    @JsonProperty("displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public ExternalNotificationLogEntry withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @JsonProperty("externalAccess")
    public Optional<Boolean> getExternalAccess() {
        return Optional.ofNullable(externalAccess);
    }

    @JsonProperty("externalAccess")
    public void setExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
    }

    public ExternalNotificationLogEntry withExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
        return this;
    }

    @JsonProperty("favorite")
    public Optional<Boolean> getFavorite() {
        return Optional.ofNullable(favorite);
    }

    @JsonProperty("favorite")
    public void setFavorite(Boolean favorite) {
        this.favorite = favorite;
    }

    public ExternalNotificationLogEntry withFavorite(Boolean favorite) {
        this.favorite = favorite;
        return this;
    }

    @JsonProperty("favorites")
    public Optional<List<String>> getFavorites() {
        return Optional.ofNullable(favorites);
    }

    @JsonProperty("favorites")
    public void setFavorites(List<String> favorites) {
        this.favorites = favorites;
    }

    public ExternalNotificationLogEntry withFavorites(List<String> favorites) {
        this.favorites = favorites;
        return this;
    }

    @JsonProperty("href")
    public Optional<String> getHref() {
        return Optional.ofNullable(href);
    }

    @JsonProperty("href")
    public void setHref(String href) {
        this.href = href;
    }

    public ExternalNotificationLogEntry withHref(String href) {
        this.href = href;
        return this;
    }

    @JsonProperty("id")
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    @JsonProperty("id")
    public void setId(String id) {
        this.id = id;
    }

    public ExternalNotificationLogEntry withId(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty("key")
    public Optional<String> getKey() {
        return Optional.ofNullable(key);
    }

    @JsonProperty("key")
    public void setKey(String key) {
        this.key = key;
    }

    public ExternalNotificationLogEntry withKey(String key) {
        this.key = key;
        return this;
    }

    @JsonProperty("lastSentAt")
    public Optional<Date> getLastSentAt() {
        return Optional.ofNullable(lastSentAt);
    }

    @JsonProperty("lastSentAt")
    public void setLastSentAt(Date lastSentAt) {
        this.lastSentAt = lastSentAt;
    }

    public ExternalNotificationLogEntry withLastSentAt(Date lastSentAt) {
        this.lastSentAt = lastSentAt;
        return this;
    }

    @JsonProperty("lastUpdated")
    public Optional<Date> getLastUpdated() {
        return Optional.ofNullable(lastUpdated);
    }

    @JsonProperty("lastUpdated")
    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public ExternalNotificationLogEntry withLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
        return this;
    }

    @JsonProperty("lastUpdatedBy")
    public Optional<User> getLastUpdatedBy() {
        return Optional.ofNullable(lastUpdatedBy);
    }

    @JsonProperty("lastUpdatedBy")
    public void setLastUpdatedBy(User lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
    }

    public ExternalNotificationLogEntry withLastUpdatedBy(User lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
        return this;
    }

    @JsonProperty("name")
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public ExternalNotificationLogEntry withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty("notificationTemplateUid")
    public Optional<String> getNotificationTemplateUid() {
        return Optional.ofNullable(notificationTemplateUid);
    }

    @JsonProperty("notificationTemplateUid")
    public void setNotificationTemplateUid(String notificationTemplateUid) {
        this.notificationTemplateUid = notificationTemplateUid;
    }

    public ExternalNotificationLogEntry withNotificationTemplateUid(String notificationTemplateUid) {
        this.notificationTemplateUid = notificationTemplateUid;
        return this;
    }

    @JsonProperty("notificationTriggeredBy")
    public Optional<ExternalNotificationLogEntry.NotificationTriggerEvent> getNotificationTriggeredBy() {
        return Optional.ofNullable(notificationTriggeredBy);
    }

    @JsonProperty("notificationTriggeredBy")
    public void setNotificationTriggeredBy(ExternalNotificationLogEntry.NotificationTriggerEvent notificationTriggeredBy) {
        this.notificationTriggeredBy = notificationTriggeredBy;
    }

    public ExternalNotificationLogEntry withNotificationTriggeredBy(ExternalNotificationLogEntry.NotificationTriggerEvent notificationTriggeredBy) {
        this.notificationTriggeredBy = notificationTriggeredBy;
        return this;
    }

    @JsonProperty("publicAccess")
    public Optional<String> getPublicAccess() {
        return Optional.ofNullable(publicAccess);
    }

    @JsonProperty("publicAccess")
    public void setPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
    }

    public ExternalNotificationLogEntry withPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
        return this;
    }

    @JsonProperty("retries")
    public Optional<Integer> getRetries() {
        return Optional.ofNullable(retries);
    }

    @JsonProperty("retries")
    public void setRetries(Integer retries) {
        this.retries = retries;
    }

    public ExternalNotificationLogEntry withRetries(Integer retries) {
        this.retries = retries;
        return this;
    }

    @JsonProperty("translations")
    public Optional<List<Translation>> getTranslations() {
        return Optional.ofNullable(translations);
    }

    @JsonProperty("translations")
    public void setTranslations(List<Translation> translations) {
        this.translations = translations;
    }

    public ExternalNotificationLogEntry withTranslations(List<Translation> translations) {
        this.translations = translations;
        return this;
    }

    @JsonProperty("user")
    public Optional<User> getUser() {
        return Optional.ofNullable(user);
    }

    @JsonProperty("user")
    public void setUser(User user) {
        this.user = user;
    }

    public ExternalNotificationLogEntry withUser(User user) {
        this.user = user;
        return this;
    }

    @JsonProperty("userAccesses")
    public Optional<List<UserAccess>> getUserAccesses() {
        return Optional.ofNullable(userAccesses);
    }

    @JsonProperty("userAccesses")
    public void setUserAccesses(List<UserAccess> userAccesses) {
        this.userAccesses = userAccesses;
    }

    public ExternalNotificationLogEntry withUserAccesses(List<UserAccess> userAccesses) {
        this.userAccesses = userAccesses;
        return this;
    }

    @JsonProperty("userGroupAccesses")
    public Optional<List<UserGroupAccess>> getUserGroupAccesses() {
        return Optional.ofNullable(userGroupAccesses);
    }

    @JsonProperty("userGroupAccesses")
    public void setUserGroupAccesses(List<UserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
    }

    public ExternalNotificationLogEntry withUserGroupAccesses(List<UserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public ExternalNotificationLogEntry withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "access":
                if (value instanceof Access) {
                    setAccess(((Access) value));
                } else {
                    throw new IllegalArgumentException(("property \"access\" is of type \"org.hisp.dhis.api.model.v2_35_13.Access\", but got "+ value.getClass().toString()));
                }
                return true;
            case "allowMultiple":
                if (value instanceof Boolean) {
                    setAllowMultiple(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"allowMultiple\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "attributeValues":
                if (value instanceof List) {
                    setAttributeValues(((List<AttributeValue> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"attributeValues\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.AttributeValue>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "code":
                if (value instanceof String) {
                    setCode(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"code\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "created":
                if (value instanceof Date) {
                    setCreated(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"created\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "displayName":
                if (value instanceof String) {
                    setDisplayName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "externalAccess":
                if (value instanceof Boolean) {
                    setExternalAccess(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"externalAccess\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "favorite":
                if (value instanceof Boolean) {
                    setFavorite(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"favorite\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "favorites":
                if (value instanceof List) {
                    setFavorites(((List<String> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"favorites\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "href":
                if (value instanceof String) {
                    setHref(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"href\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "id":
                if (value instanceof String) {
                    setId(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"id\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "key":
                if (value instanceof String) {
                    setKey(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"key\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "lastSentAt":
                if (value instanceof Date) {
                    setLastSentAt(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"lastSentAt\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "lastUpdated":
                if (value instanceof Date) {
                    setLastUpdated(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"lastUpdated\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "lastUpdatedBy":
                if (value instanceof User) {
                    setLastUpdatedBy(((User) value));
                } else {
                    throw new IllegalArgumentException(("property \"lastUpdatedBy\" is of type \"org.hisp.dhis.api.model.v2_35_13.User\", but got "+ value.getClass().toString()));
                }
                return true;
            case "name":
                if (value instanceof String) {
                    setName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"name\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "notificationTemplateUid":
                if (value instanceof String) {
                    setNotificationTemplateUid(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"notificationTemplateUid\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "notificationTriggeredBy":
                if (value instanceof ExternalNotificationLogEntry.NotificationTriggerEvent) {
                    setNotificationTriggeredBy(((ExternalNotificationLogEntry.NotificationTriggerEvent) value));
                } else {
                    throw new IllegalArgumentException(("property \"notificationTriggeredBy\" is of type \"org.hisp.dhis.api.model.v2_35_13.ExternalNotificationLogEntry.NotificationTriggerEvent\", but got "+ value.getClass().toString()));
                }
                return true;
            case "publicAccess":
                if (value instanceof String) {
                    setPublicAccess(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"publicAccess\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "retries":
                if (value instanceof Integer) {
                    setRetries(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"retries\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "translations":
                if (value instanceof List) {
                    setTranslations(((List<Translation> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"translations\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.Translation>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "user":
                if (value instanceof User) {
                    setUser(((User) value));
                } else {
                    throw new IllegalArgumentException(("property \"user\" is of type \"org.hisp.dhis.api.model.v2_35_13.User\", but got "+ value.getClass().toString()));
                }
                return true;
            case "userAccesses":
                if (value instanceof List) {
                    setUserAccesses(((List<UserAccess> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"userAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.UserAccess>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "userGroupAccesses":
                if (value instanceof List) {
                    setUserGroupAccesses(((List<UserGroupAccess> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"userGroupAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.UserGroupAccess>\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "access":
                return getAccess();
            case "allowMultiple":
                return getAllowMultiple();
            case "attributeValues":
                return getAttributeValues();
            case "code":
                return getCode();
            case "created":
                return getCreated();
            case "displayName":
                return getDisplayName();
            case "externalAccess":
                return getExternalAccess();
            case "favorite":
                return getFavorite();
            case "favorites":
                return getFavorites();
            case "href":
                return getHref();
            case "id":
                return getId();
            case "key":
                return getKey();
            case "lastSentAt":
                return getLastSentAt();
            case "lastUpdated":
                return getLastUpdated();
            case "lastUpdatedBy":
                return getLastUpdatedBy();
            case "name":
                return getName();
            case "notificationTemplateUid":
                return getNotificationTemplateUid();
            case "notificationTriggeredBy":
                return getNotificationTriggeredBy();
            case "publicAccess":
                return getPublicAccess();
            case "retries":
                return getRetries();
            case "translations":
                return getTranslations();
            case "user":
                return getUser();
            case "userAccesses":
                return getUserAccesses();
            case "userGroupAccesses":
                return getUserGroupAccesses();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, ExternalNotificationLogEntry.NOT_FOUND_VALUE);
        if (ExternalNotificationLogEntry.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public ExternalNotificationLogEntry with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ExternalNotificationLogEntry.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("access");
        sb.append('=');
        sb.append(((this.access == null)?"<null>":this.access));
        sb.append(',');
        sb.append("allowMultiple");
        sb.append('=');
        sb.append(((this.allowMultiple == null)?"<null>":this.allowMultiple));
        sb.append(',');
        sb.append("attributeValues");
        sb.append('=');
        sb.append(((this.attributeValues == null)?"<null>":this.attributeValues));
        sb.append(',');
        sb.append("code");
        sb.append('=');
        sb.append(((this.code == null)?"<null>":this.code));
        sb.append(',');
        sb.append("created");
        sb.append('=');
        sb.append(((this.created == null)?"<null>":this.created));
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(((this.displayName == null)?"<null>":this.displayName));
        sb.append(',');
        sb.append("externalAccess");
        sb.append('=');
        sb.append(((this.externalAccess == null)?"<null>":this.externalAccess));
        sb.append(',');
        sb.append("favorite");
        sb.append('=');
        sb.append(((this.favorite == null)?"<null>":this.favorite));
        sb.append(',');
        sb.append("favorites");
        sb.append('=');
        sb.append(((this.favorites == null)?"<null>":this.favorites));
        sb.append(',');
        sb.append("href");
        sb.append('=');
        sb.append(((this.href == null)?"<null>":this.href));
        sb.append(',');
        sb.append("id");
        sb.append('=');
        sb.append(((this.id == null)?"<null>":this.id));
        sb.append(',');
        sb.append("key");
        sb.append('=');
        sb.append(((this.key == null)?"<null>":this.key));
        sb.append(',');
        sb.append("lastSentAt");
        sb.append('=');
        sb.append(((this.lastSentAt == null)?"<null>":this.lastSentAt));
        sb.append(',');
        sb.append("lastUpdated");
        sb.append('=');
        sb.append(((this.lastUpdated == null)?"<null>":this.lastUpdated));
        sb.append(',');
        sb.append("lastUpdatedBy");
        sb.append('=');
        sb.append(((this.lastUpdatedBy == null)?"<null>":this.lastUpdatedBy));
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("notificationTemplateUid");
        sb.append('=');
        sb.append(((this.notificationTemplateUid == null)?"<null>":this.notificationTemplateUid));
        sb.append(',');
        sb.append("notificationTriggeredBy");
        sb.append('=');
        sb.append(((this.notificationTriggeredBy == null)?"<null>":this.notificationTriggeredBy));
        sb.append(',');
        sb.append("publicAccess");
        sb.append('=');
        sb.append(((this.publicAccess == null)?"<null>":this.publicAccess));
        sb.append(',');
        sb.append("retries");
        sb.append('=');
        sb.append(((this.retries == null)?"<null>":this.retries));
        sb.append(',');
        sb.append("translations");
        sb.append('=');
        sb.append(((this.translations == null)?"<null>":this.translations));
        sb.append(',');
        sb.append("user");
        sb.append('=');
        sb.append(((this.user == null)?"<null>":this.user));
        sb.append(',');
        sb.append("userAccesses");
        sb.append('=');
        sb.append(((this.userAccesses == null)?"<null>":this.userAccesses));
        sb.append(',');
        sb.append("userGroupAccesses");
        sb.append('=');
        sb.append(((this.userGroupAccesses == null)?"<null>":this.userGroupAccesses));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.favorites == null)? 0 :this.favorites.hashCode()));
        result = ((result* 31)+((this.access == null)? 0 :this.access.hashCode()));
        result = ((result* 31)+((this.code == null)? 0 :this.code.hashCode()));
        result = ((result* 31)+((this.displayName == null)? 0 :this.displayName.hashCode()));
        result = ((result* 31)+((this.publicAccess == null)? 0 :this.publicAccess.hashCode()));
        result = ((result* 31)+((this.externalAccess == null)? 0 :this.externalAccess.hashCode()));
        result = ((result* 31)+((this.lastUpdated == null)? 0 :this.lastUpdated.hashCode()));
        result = ((result* 31)+((this.translations == null)? 0 :this.translations.hashCode()));
        result = ((result* 31)+((this.href == null)? 0 :this.href.hashCode()));
        result = ((result* 31)+((this.id == null)? 0 :this.id.hashCode()));
        result = ((result* 31)+((this.notificationTemplateUid == null)? 0 :this.notificationTemplateUid.hashCode()));
        result = ((result* 31)+((this.key == null)? 0 :this.key.hashCode()));
        result = ((result* 31)+((this.lastUpdatedBy == null)? 0 :this.lastUpdatedBy.hashCode()));
        result = ((result* 31)+((this.userGroupAccesses == null)? 0 :this.userGroupAccesses.hashCode()));
        result = ((result* 31)+((this.created == null)? 0 :this.created.hashCode()));
        result = ((result* 31)+((this.attributeValues == null)? 0 :this.attributeValues.hashCode()));
        result = ((result* 31)+((this.lastSentAt == null)? 0 :this.lastSentAt.hashCode()));
        result = ((result* 31)+((this.notificationTriggeredBy == null)? 0 :this.notificationTriggeredBy.hashCode()));
        result = ((result* 31)+((this.retries == null)? 0 :this.retries.hashCode()));
        result = ((result* 31)+((this.allowMultiple == null)? 0 :this.allowMultiple.hashCode()));
        result = ((result* 31)+((this.userAccesses == null)? 0 :this.userAccesses.hashCode()));
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.favorite == null)? 0 :this.favorite.hashCode()));
        result = ((result* 31)+((this.user == null)? 0 :this.user.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof ExternalNotificationLogEntry) == false) {
            return false;
        }
        ExternalNotificationLogEntry rhs = ((ExternalNotificationLogEntry) other);
        return ((((((((((((((((((((((((((this.favorites == rhs.favorites)||((this.favorites!= null)&&this.favorites.equals(rhs.favorites)))&&((this.access == rhs.access)||((this.access!= null)&&this.access.equals(rhs.access))))&&((this.code == rhs.code)||((this.code!= null)&&this.code.equals(rhs.code))))&&((this.displayName == rhs.displayName)||((this.displayName!= null)&&this.displayName.equals(rhs.displayName))))&&((this.publicAccess == rhs.publicAccess)||((this.publicAccess!= null)&&this.publicAccess.equals(rhs.publicAccess))))&&((this.externalAccess == rhs.externalAccess)||((this.externalAccess!= null)&&this.externalAccess.equals(rhs.externalAccess))))&&((this.lastUpdated == rhs.lastUpdated)||((this.lastUpdated!= null)&&this.lastUpdated.equals(rhs.lastUpdated))))&&((this.translations == rhs.translations)||((this.translations!= null)&&this.translations.equals(rhs.translations))))&&((this.href == rhs.href)||((this.href!= null)&&this.href.equals(rhs.href))))&&((this.id == rhs.id)||((this.id!= null)&&this.id.equals(rhs.id))))&&((this.notificationTemplateUid == rhs.notificationTemplateUid)||((this.notificationTemplateUid!= null)&&this.notificationTemplateUid.equals(rhs.notificationTemplateUid))))&&((this.key == rhs.key)||((this.key!= null)&&this.key.equals(rhs.key))))&&((this.lastUpdatedBy == rhs.lastUpdatedBy)||((this.lastUpdatedBy!= null)&&this.lastUpdatedBy.equals(rhs.lastUpdatedBy))))&&((this.userGroupAccesses == rhs.userGroupAccesses)||((this.userGroupAccesses!= null)&&this.userGroupAccesses.equals(rhs.userGroupAccesses))))&&((this.created == rhs.created)||((this.created!= null)&&this.created.equals(rhs.created))))&&((this.attributeValues == rhs.attributeValues)||((this.attributeValues!= null)&&this.attributeValues.equals(rhs.attributeValues))))&&((this.lastSentAt == rhs.lastSentAt)||((this.lastSentAt!= null)&&this.lastSentAt.equals(rhs.lastSentAt))))&&((this.notificationTriggeredBy == rhs.notificationTriggeredBy)||((this.notificationTriggeredBy!= null)&&this.notificationTriggeredBy.equals(rhs.notificationTriggeredBy))))&&((this.retries == rhs.retries)||((this.retries!= null)&&this.retries.equals(rhs.retries))))&&((this.allowMultiple == rhs.allowMultiple)||((this.allowMultiple!= null)&&this.allowMultiple.equals(rhs.allowMultiple))))&&((this.userAccesses == rhs.userAccesses)||((this.userAccesses!= null)&&this.userAccesses.equals(rhs.userAccesses))))&&((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.favorite == rhs.favorite)||((this.favorite!= null)&&this.favorite.equals(rhs.favorite))))&&((this.user == rhs.user)||((this.user!= null)&&this.user.equals(rhs.user))));
    }

    @Generated("jsonschema2pojo")
    public enum NotificationTriggerEvent {

        PROGRAM("PROGRAM"),
        PROGRAM_STAGE("PROGRAM_STAGE"),
        DATA_SET("DATA_SET"),
        VALIDATION_RULE("VALIDATION_RULE");
        private final String value;
        private final static Map<String, ExternalNotificationLogEntry.NotificationTriggerEvent> CONSTANTS = new HashMap<String, ExternalNotificationLogEntry.NotificationTriggerEvent>();

        static {
            for (ExternalNotificationLogEntry.NotificationTriggerEvent c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        NotificationTriggerEvent(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ExternalNotificationLogEntry.NotificationTriggerEvent fromValue(String value) {
            ExternalNotificationLogEntry.NotificationTriggerEvent constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
