
package org.hisp.dhis.api.model.v2_35_13;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "access",
    "aggregateExportAttributeOptionCombo",
    "aggregateExportCategoryOptionCombo",
    "aggregationType",
    "annualized",
    "attributeValues",
    "code",
    "created",
    "dataSets",
    "decimals",
    "denominator",
    "denominatorDescription",
    "description",
    "dimensionItem",
    "dimensionItemType",
    "displayDenominatorDescription",
    "displayDescription",
    "displayFormName",
    "displayName",
    "displayNumeratorDescription",
    "displayShortName",
    "externalAccess",
    "favorite",
    "favorites",
    "formName",
    "href",
    "id",
    "indicatorGroups",
    "indicatorType",
    "lastUpdated",
    "lastUpdatedBy",
    "legendSet",
    "legendSets",
    "name",
    "numerator",
    "numeratorDescription",
    "periodOffset",
    "publicAccess",
    "shortName",
    "style",
    "translations",
    "url",
    "user",
    "userAccesses",
    "userGroupAccesses"
})
@Generated("jsonschema2pojo")
public class Indicator implements Serializable
{

    @JsonProperty("access")
    private Access access;
    @JsonProperty("aggregateExportAttributeOptionCombo")
    private String aggregateExportAttributeOptionCombo;
    @JsonProperty("aggregateExportCategoryOptionCombo")
    private String aggregateExportCategoryOptionCombo;
    @JsonProperty("aggregationType")
    private AggregationType aggregationType;
    @JsonProperty("annualized")
    private Boolean annualized;
    @JsonProperty("attributeValues")
    private List<AttributeValue> attributeValues = null;
    @JsonProperty("code")
    private String code;
    @JsonProperty("created")
    private Date created;
    @JsonProperty("dataSets")
    private List<DataSet> dataSets = null;
    @JsonProperty("decimals")
    private Integer decimals;
    @JsonProperty("denominator")
    private String denominator;
    @JsonProperty("denominatorDescription")
    private String denominatorDescription;
    @JsonProperty("description")
    private String description;
    @JsonProperty("dimensionItem")
    private String dimensionItem;
    @JsonProperty("dimensionItemType")
    private org.hisp.dhis.api.model.v2_35_13.CategoryOptionCombo.DimensionItemType dimensionItemType;
    @JsonProperty("displayDenominatorDescription")
    private String displayDenominatorDescription;
    @JsonProperty("displayDescription")
    private String displayDescription;
    @JsonProperty("displayFormName")
    private String displayFormName;
    @JsonProperty("displayName")
    private String displayName;
    @JsonProperty("displayNumeratorDescription")
    private String displayNumeratorDescription;
    @JsonProperty("displayShortName")
    private String displayShortName;
    @JsonProperty("externalAccess")
    private Boolean externalAccess;
    @JsonProperty("favorite")
    private Boolean favorite;
    @JsonProperty("favorites")
    private List<String> favorites = null;
    @JsonProperty("formName")
    private String formName;
    @JsonProperty("href")
    private String href;
    @JsonProperty("id")
    private String id;
    @JsonProperty("indicatorGroups")
    private List<IndicatorGroup> indicatorGroups = null;
    @JsonProperty("indicatorType")
    private IndicatorType indicatorType;
    @JsonProperty("lastUpdated")
    private Date lastUpdated;
    @JsonProperty("lastUpdatedBy")
    private User lastUpdatedBy;
    @JsonProperty("legendSet")
    private LegendSet legendSet;
    @JsonProperty("legendSets")
    private List<LegendSet> legendSets = null;
    @JsonProperty("name")
    private String name;
    @JsonProperty("numerator")
    private String numerator;
    @JsonProperty("numeratorDescription")
    private String numeratorDescription;
    @JsonProperty("periodOffset")
    private Integer periodOffset;
    @JsonProperty("publicAccess")
    private String publicAccess;
    @JsonProperty("shortName")
    private String shortName;
    @JsonProperty("style")
    private ObjectStyle style;
    @JsonProperty("translations")
    private List<Translation> translations = null;
    @JsonProperty("url")
    private String url;
    @JsonProperty("user")
    private User user;
    @JsonProperty("userAccesses")
    private List<UserAccess> userAccesses = null;
    @JsonProperty("userGroupAccesses")
    private List<UserGroupAccess> userGroupAccesses = null;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 8556690084786092958L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Indicator() {
    }

    /**
     * 
     * @param source
     */
    public Indicator(Indicator source) {
        super();
        this.access = source.access;
        this.aggregateExportAttributeOptionCombo = source.aggregateExportAttributeOptionCombo;
        this.aggregateExportCategoryOptionCombo = source.aggregateExportCategoryOptionCombo;
        this.aggregationType = source.aggregationType;
        this.annualized = source.annualized;
        this.attributeValues = source.attributeValues;
        this.code = source.code;
        this.created = source.created;
        this.dataSets = source.dataSets;
        this.decimals = source.decimals;
        this.denominator = source.denominator;
        this.denominatorDescription = source.denominatorDescription;
        this.description = source.description;
        this.dimensionItem = source.dimensionItem;
        this.dimensionItemType = source.dimensionItemType;
        this.displayDenominatorDescription = source.displayDenominatorDescription;
        this.displayDescription = source.displayDescription;
        this.displayFormName = source.displayFormName;
        this.displayName = source.displayName;
        this.displayNumeratorDescription = source.displayNumeratorDescription;
        this.displayShortName = source.displayShortName;
        this.externalAccess = source.externalAccess;
        this.favorite = source.favorite;
        this.favorites = source.favorites;
        this.formName = source.formName;
        this.href = source.href;
        this.id = source.id;
        this.indicatorGroups = source.indicatorGroups;
        this.indicatorType = source.indicatorType;
        this.lastUpdated = source.lastUpdated;
        this.lastUpdatedBy = source.lastUpdatedBy;
        this.legendSet = source.legendSet;
        this.legendSets = source.legendSets;
        this.name = source.name;
        this.numerator = source.numerator;
        this.numeratorDescription = source.numeratorDescription;
        this.periodOffset = source.periodOffset;
        this.publicAccess = source.publicAccess;
        this.shortName = source.shortName;
        this.style = source.style;
        this.translations = source.translations;
        this.url = source.url;
        this.user = source.user;
        this.userAccesses = source.userAccesses;
        this.userGroupAccesses = source.userGroupAccesses;
    }

    /**
     * 
     * @param favorites
     * @param aggregationType
     * @param access
     * @param code
     * @param displayName
     * @param publicAccess
     * @param aggregateExportCategoryOptionCombo
     * @param description
     * @param displayShortName
     * @param externalAccess
     * @param displayNumeratorDescription
     * @param lastUpdated
     * @param denominatorDescription
     * @param periodOffset
     * @param indicatorType
     * @param translations
     * @param formName
     * @param href
     * @param id
     * @param displayDenominatorDescription
     * @param numeratorDescription
     * @param displayDescription
     * @param lastUpdatedBy
     * @param userGroupAccesses
     * @param dimensionItem
     * @param created
     * @param attributeValues
     * @param indicatorGroups
     * @param displayFormName
     * @param url
     * @param denominator
     * @param numerator
     * @param annualized
     * @param decimals
     * @param userAccesses
     * @param legendSet
     * @param name
     * @param dataSets
     * @param legendSets
     * @param style
     * @param shortName
     * @param aggregateExportAttributeOptionCombo
     * @param favorite
     * @param user
     * @param dimensionItemType
     */
    public Indicator(Access access, String aggregateExportAttributeOptionCombo, String aggregateExportCategoryOptionCombo, AggregationType aggregationType, Boolean annualized, List<AttributeValue> attributeValues, String code, Date created, List<DataSet> dataSets, Integer decimals, String denominator, String denominatorDescription, String description, String dimensionItem, org.hisp.dhis.api.model.v2_35_13.CategoryOptionCombo.DimensionItemType dimensionItemType, String displayDenominatorDescription, String displayDescription, String displayFormName, String displayName, String displayNumeratorDescription, String displayShortName, Boolean externalAccess, Boolean favorite, List<String> favorites, String formName, String href, String id, List<IndicatorGroup> indicatorGroups, IndicatorType indicatorType, Date lastUpdated, User lastUpdatedBy, LegendSet legendSet, List<LegendSet> legendSets, String name, String numerator, String numeratorDescription, Integer periodOffset, String publicAccess, String shortName, ObjectStyle style, List<Translation> translations, String url, User user, List<UserAccess> userAccesses, List<UserGroupAccess> userGroupAccesses) {
        super();
        this.access = access;
        this.aggregateExportAttributeOptionCombo = aggregateExportAttributeOptionCombo;
        this.aggregateExportCategoryOptionCombo = aggregateExportCategoryOptionCombo;
        this.aggregationType = aggregationType;
        this.annualized = annualized;
        this.attributeValues = attributeValues;
        this.code = code;
        this.created = created;
        this.dataSets = dataSets;
        this.decimals = decimals;
        this.denominator = denominator;
        this.denominatorDescription = denominatorDescription;
        this.description = description;
        this.dimensionItem = dimensionItem;
        this.dimensionItemType = dimensionItemType;
        this.displayDenominatorDescription = displayDenominatorDescription;
        this.displayDescription = displayDescription;
        this.displayFormName = displayFormName;
        this.displayName = displayName;
        this.displayNumeratorDescription = displayNumeratorDescription;
        this.displayShortName = displayShortName;
        this.externalAccess = externalAccess;
        this.favorite = favorite;
        this.favorites = favorites;
        this.formName = formName;
        this.href = href;
        this.id = id;
        this.indicatorGroups = indicatorGroups;
        this.indicatorType = indicatorType;
        this.lastUpdated = lastUpdated;
        this.lastUpdatedBy = lastUpdatedBy;
        this.legendSet = legendSet;
        this.legendSets = legendSets;
        this.name = name;
        this.numerator = numerator;
        this.numeratorDescription = numeratorDescription;
        this.periodOffset = periodOffset;
        this.publicAccess = publicAccess;
        this.shortName = shortName;
        this.style = style;
        this.translations = translations;
        this.url = url;
        this.user = user;
        this.userAccesses = userAccesses;
        this.userGroupAccesses = userGroupAccesses;
    }

    @JsonProperty("access")
    public Optional<Access> getAccess() {
        return Optional.ofNullable(access);
    }

    @JsonProperty("access")
    public void setAccess(Access access) {
        this.access = access;
    }

    public Indicator withAccess(Access access) {
        this.access = access;
        return this;
    }

    @JsonProperty("aggregateExportAttributeOptionCombo")
    public Optional<String> getAggregateExportAttributeOptionCombo() {
        return Optional.ofNullable(aggregateExportAttributeOptionCombo);
    }

    @JsonProperty("aggregateExportAttributeOptionCombo")
    public void setAggregateExportAttributeOptionCombo(String aggregateExportAttributeOptionCombo) {
        this.aggregateExportAttributeOptionCombo = aggregateExportAttributeOptionCombo;
    }

    public Indicator withAggregateExportAttributeOptionCombo(String aggregateExportAttributeOptionCombo) {
        this.aggregateExportAttributeOptionCombo = aggregateExportAttributeOptionCombo;
        return this;
    }

    @JsonProperty("aggregateExportCategoryOptionCombo")
    public Optional<String> getAggregateExportCategoryOptionCombo() {
        return Optional.ofNullable(aggregateExportCategoryOptionCombo);
    }

    @JsonProperty("aggregateExportCategoryOptionCombo")
    public void setAggregateExportCategoryOptionCombo(String aggregateExportCategoryOptionCombo) {
        this.aggregateExportCategoryOptionCombo = aggregateExportCategoryOptionCombo;
    }

    public Indicator withAggregateExportCategoryOptionCombo(String aggregateExportCategoryOptionCombo) {
        this.aggregateExportCategoryOptionCombo = aggregateExportCategoryOptionCombo;
        return this;
    }

    @JsonProperty("aggregationType")
    public Optional<AggregationType> getAggregationType() {
        return Optional.ofNullable(aggregationType);
    }

    @JsonProperty("aggregationType")
    public void setAggregationType(AggregationType aggregationType) {
        this.aggregationType = aggregationType;
    }

    public Indicator withAggregationType(AggregationType aggregationType) {
        this.aggregationType = aggregationType;
        return this;
    }

    @JsonProperty("annualized")
    public Optional<Boolean> getAnnualized() {
        return Optional.ofNullable(annualized);
    }

    @JsonProperty("annualized")
    public void setAnnualized(Boolean annualized) {
        this.annualized = annualized;
    }

    public Indicator withAnnualized(Boolean annualized) {
        this.annualized = annualized;
        return this;
    }

    @JsonProperty("attributeValues")
    public Optional<List<AttributeValue>> getAttributeValues() {
        return Optional.ofNullable(attributeValues);
    }

    @JsonProperty("attributeValues")
    public void setAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
    }

    public Indicator withAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
        return this;
    }

    @JsonProperty("code")
    public Optional<String> getCode() {
        return Optional.ofNullable(code);
    }

    @JsonProperty("code")
    public void setCode(String code) {
        this.code = code;
    }

    public Indicator withCode(String code) {
        this.code = code;
        return this;
    }

    @JsonProperty("created")
    public Optional<Date> getCreated() {
        return Optional.ofNullable(created);
    }

    @JsonProperty("created")
    public void setCreated(Date created) {
        this.created = created;
    }

    public Indicator withCreated(Date created) {
        this.created = created;
        return this;
    }

    @JsonProperty("dataSets")
    public Optional<List<DataSet>> getDataSets() {
        return Optional.ofNullable(dataSets);
    }

    @JsonProperty("dataSets")
    public void setDataSets(List<DataSet> dataSets) {
        this.dataSets = dataSets;
    }

    public Indicator withDataSets(List<DataSet> dataSets) {
        this.dataSets = dataSets;
        return this;
    }

    @JsonProperty("decimals")
    public Optional<Integer> getDecimals() {
        return Optional.ofNullable(decimals);
    }

    @JsonProperty("decimals")
    public void setDecimals(Integer decimals) {
        this.decimals = decimals;
    }

    public Indicator withDecimals(Integer decimals) {
        this.decimals = decimals;
        return this;
    }

    @JsonProperty("denominator")
    public Optional<String> getDenominator() {
        return Optional.ofNullable(denominator);
    }

    @JsonProperty("denominator")
    public void setDenominator(String denominator) {
        this.denominator = denominator;
    }

    public Indicator withDenominator(String denominator) {
        this.denominator = denominator;
        return this;
    }

    @JsonProperty("denominatorDescription")
    public Optional<String> getDenominatorDescription() {
        return Optional.ofNullable(denominatorDescription);
    }

    @JsonProperty("denominatorDescription")
    public void setDenominatorDescription(String denominatorDescription) {
        this.denominatorDescription = denominatorDescription;
    }

    public Indicator withDenominatorDescription(String denominatorDescription) {
        this.denominatorDescription = denominatorDescription;
        return this;
    }

    @JsonProperty("description")
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    @JsonProperty("description")
    public void setDescription(String description) {
        this.description = description;
    }

    public Indicator withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty("dimensionItem")
    public Optional<String> getDimensionItem() {
        return Optional.ofNullable(dimensionItem);
    }

    @JsonProperty("dimensionItem")
    public void setDimensionItem(String dimensionItem) {
        this.dimensionItem = dimensionItem;
    }

    public Indicator withDimensionItem(String dimensionItem) {
        this.dimensionItem = dimensionItem;
        return this;
    }

    @JsonProperty("dimensionItemType")
    public Optional<org.hisp.dhis.api.model.v2_35_13.CategoryOptionCombo.DimensionItemType> getDimensionItemType() {
        return Optional.ofNullable(dimensionItemType);
    }

    @JsonProperty("dimensionItemType")
    public void setDimensionItemType(org.hisp.dhis.api.model.v2_35_13.CategoryOptionCombo.DimensionItemType dimensionItemType) {
        this.dimensionItemType = dimensionItemType;
    }

    public Indicator withDimensionItemType(org.hisp.dhis.api.model.v2_35_13.CategoryOptionCombo.DimensionItemType dimensionItemType) {
        this.dimensionItemType = dimensionItemType;
        return this;
    }

    @JsonProperty("displayDenominatorDescription")
    public Optional<String> getDisplayDenominatorDescription() {
        return Optional.ofNullable(displayDenominatorDescription);
    }

    @JsonProperty("displayDenominatorDescription")
    public void setDisplayDenominatorDescription(String displayDenominatorDescription) {
        this.displayDenominatorDescription = displayDenominatorDescription;
    }

    public Indicator withDisplayDenominatorDescription(String displayDenominatorDescription) {
        this.displayDenominatorDescription = displayDenominatorDescription;
        return this;
    }

    @JsonProperty("displayDescription")
    public Optional<String> getDisplayDescription() {
        return Optional.ofNullable(displayDescription);
    }

    @JsonProperty("displayDescription")
    public void setDisplayDescription(String displayDescription) {
        this.displayDescription = displayDescription;
    }

    public Indicator withDisplayDescription(String displayDescription) {
        this.displayDescription = displayDescription;
        return this;
    }

    @JsonProperty("displayFormName")
    public Optional<String> getDisplayFormName() {
        return Optional.ofNullable(displayFormName);
    }

    @JsonProperty("displayFormName")
    public void setDisplayFormName(String displayFormName) {
        this.displayFormName = displayFormName;
    }

    public Indicator withDisplayFormName(String displayFormName) {
        this.displayFormName = displayFormName;
        return this;
    }

    @JsonProperty("displayName")
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    @JsonProperty("displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public Indicator withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @JsonProperty("displayNumeratorDescription")
    public Optional<String> getDisplayNumeratorDescription() {
        return Optional.ofNullable(displayNumeratorDescription);
    }

    @JsonProperty("displayNumeratorDescription")
    public void setDisplayNumeratorDescription(String displayNumeratorDescription) {
        this.displayNumeratorDescription = displayNumeratorDescription;
    }

    public Indicator withDisplayNumeratorDescription(String displayNumeratorDescription) {
        this.displayNumeratorDescription = displayNumeratorDescription;
        return this;
    }

    @JsonProperty("displayShortName")
    public Optional<String> getDisplayShortName() {
        return Optional.ofNullable(displayShortName);
    }

    @JsonProperty("displayShortName")
    public void setDisplayShortName(String displayShortName) {
        this.displayShortName = displayShortName;
    }

    public Indicator withDisplayShortName(String displayShortName) {
        this.displayShortName = displayShortName;
        return this;
    }

    @JsonProperty("externalAccess")
    public Optional<Boolean> getExternalAccess() {
        return Optional.ofNullable(externalAccess);
    }

    @JsonProperty("externalAccess")
    public void setExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
    }

    public Indicator withExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
        return this;
    }

    @JsonProperty("favorite")
    public Optional<Boolean> getFavorite() {
        return Optional.ofNullable(favorite);
    }

    @JsonProperty("favorite")
    public void setFavorite(Boolean favorite) {
        this.favorite = favorite;
    }

    public Indicator withFavorite(Boolean favorite) {
        this.favorite = favorite;
        return this;
    }

    @JsonProperty("favorites")
    public Optional<List<String>> getFavorites() {
        return Optional.ofNullable(favorites);
    }

    @JsonProperty("favorites")
    public void setFavorites(List<String> favorites) {
        this.favorites = favorites;
    }

    public Indicator withFavorites(List<String> favorites) {
        this.favorites = favorites;
        return this;
    }

    @JsonProperty("formName")
    public Optional<String> getFormName() {
        return Optional.ofNullable(formName);
    }

    @JsonProperty("formName")
    public void setFormName(String formName) {
        this.formName = formName;
    }

    public Indicator withFormName(String formName) {
        this.formName = formName;
        return this;
    }

    @JsonProperty("href")
    public Optional<String> getHref() {
        return Optional.ofNullable(href);
    }

    @JsonProperty("href")
    public void setHref(String href) {
        this.href = href;
    }

    public Indicator withHref(String href) {
        this.href = href;
        return this;
    }

    @JsonProperty("id")
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    @JsonProperty("id")
    public void setId(String id) {
        this.id = id;
    }

    public Indicator withId(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty("indicatorGroups")
    public Optional<List<IndicatorGroup>> getIndicatorGroups() {
        return Optional.ofNullable(indicatorGroups);
    }

    @JsonProperty("indicatorGroups")
    public void setIndicatorGroups(List<IndicatorGroup> indicatorGroups) {
        this.indicatorGroups = indicatorGroups;
    }

    public Indicator withIndicatorGroups(List<IndicatorGroup> indicatorGroups) {
        this.indicatorGroups = indicatorGroups;
        return this;
    }

    @JsonProperty("indicatorType")
    public Optional<IndicatorType> getIndicatorType() {
        return Optional.ofNullable(indicatorType);
    }

    @JsonProperty("indicatorType")
    public void setIndicatorType(IndicatorType indicatorType) {
        this.indicatorType = indicatorType;
    }

    public Indicator withIndicatorType(IndicatorType indicatorType) {
        this.indicatorType = indicatorType;
        return this;
    }

    @JsonProperty("lastUpdated")
    public Optional<Date> getLastUpdated() {
        return Optional.ofNullable(lastUpdated);
    }

    @JsonProperty("lastUpdated")
    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public Indicator withLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
        return this;
    }

    @JsonProperty("lastUpdatedBy")
    public Optional<User> getLastUpdatedBy() {
        return Optional.ofNullable(lastUpdatedBy);
    }

    @JsonProperty("lastUpdatedBy")
    public void setLastUpdatedBy(User lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
    }

    public Indicator withLastUpdatedBy(User lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
        return this;
    }

    @JsonProperty("legendSet")
    public Optional<LegendSet> getLegendSet() {
        return Optional.ofNullable(legendSet);
    }

    @JsonProperty("legendSet")
    public void setLegendSet(LegendSet legendSet) {
        this.legendSet = legendSet;
    }

    public Indicator withLegendSet(LegendSet legendSet) {
        this.legendSet = legendSet;
        return this;
    }

    @JsonProperty("legendSets")
    public Optional<List<LegendSet>> getLegendSets() {
        return Optional.ofNullable(legendSets);
    }

    @JsonProperty("legendSets")
    public void setLegendSets(List<LegendSet> legendSets) {
        this.legendSets = legendSets;
    }

    public Indicator withLegendSets(List<LegendSet> legendSets) {
        this.legendSets = legendSets;
        return this;
    }

    @JsonProperty("name")
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public Indicator withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty("numerator")
    public Optional<String> getNumerator() {
        return Optional.ofNullable(numerator);
    }

    @JsonProperty("numerator")
    public void setNumerator(String numerator) {
        this.numerator = numerator;
    }

    public Indicator withNumerator(String numerator) {
        this.numerator = numerator;
        return this;
    }

    @JsonProperty("numeratorDescription")
    public Optional<String> getNumeratorDescription() {
        return Optional.ofNullable(numeratorDescription);
    }

    @JsonProperty("numeratorDescription")
    public void setNumeratorDescription(String numeratorDescription) {
        this.numeratorDescription = numeratorDescription;
    }

    public Indicator withNumeratorDescription(String numeratorDescription) {
        this.numeratorDescription = numeratorDescription;
        return this;
    }

    @JsonProperty("periodOffset")
    public Optional<Integer> getPeriodOffset() {
        return Optional.ofNullable(periodOffset);
    }

    @JsonProperty("periodOffset")
    public void setPeriodOffset(Integer periodOffset) {
        this.periodOffset = periodOffset;
    }

    public Indicator withPeriodOffset(Integer periodOffset) {
        this.periodOffset = periodOffset;
        return this;
    }

    @JsonProperty("publicAccess")
    public Optional<String> getPublicAccess() {
        return Optional.ofNullable(publicAccess);
    }

    @JsonProperty("publicAccess")
    public void setPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
    }

    public Indicator withPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
        return this;
    }

    @JsonProperty("shortName")
    public Optional<String> getShortName() {
        return Optional.ofNullable(shortName);
    }

    @JsonProperty("shortName")
    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public Indicator withShortName(String shortName) {
        this.shortName = shortName;
        return this;
    }

    @JsonProperty("style")
    public Optional<ObjectStyle> getStyle() {
        return Optional.ofNullable(style);
    }

    @JsonProperty("style")
    public void setStyle(ObjectStyle style) {
        this.style = style;
    }

    public Indicator withStyle(ObjectStyle style) {
        this.style = style;
        return this;
    }

    @JsonProperty("translations")
    public Optional<List<Translation>> getTranslations() {
        return Optional.ofNullable(translations);
    }

    @JsonProperty("translations")
    public void setTranslations(List<Translation> translations) {
        this.translations = translations;
    }

    public Indicator withTranslations(List<Translation> translations) {
        this.translations = translations;
        return this;
    }

    @JsonProperty("url")
    public Optional<String> getUrl() {
        return Optional.ofNullable(url);
    }

    @JsonProperty("url")
    public void setUrl(String url) {
        this.url = url;
    }

    public Indicator withUrl(String url) {
        this.url = url;
        return this;
    }

    @JsonProperty("user")
    public Optional<User> getUser() {
        return Optional.ofNullable(user);
    }

    @JsonProperty("user")
    public void setUser(User user) {
        this.user = user;
    }

    public Indicator withUser(User user) {
        this.user = user;
        return this;
    }

    @JsonProperty("userAccesses")
    public Optional<List<UserAccess>> getUserAccesses() {
        return Optional.ofNullable(userAccesses);
    }

    @JsonProperty("userAccesses")
    public void setUserAccesses(List<UserAccess> userAccesses) {
        this.userAccesses = userAccesses;
    }

    public Indicator withUserAccesses(List<UserAccess> userAccesses) {
        this.userAccesses = userAccesses;
        return this;
    }

    @JsonProperty("userGroupAccesses")
    public Optional<List<UserGroupAccess>> getUserGroupAccesses() {
        return Optional.ofNullable(userGroupAccesses);
    }

    @JsonProperty("userGroupAccesses")
    public void setUserGroupAccesses(List<UserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
    }

    public Indicator withUserGroupAccesses(List<UserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public Indicator withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "access":
                if (value instanceof Access) {
                    setAccess(((Access) value));
                } else {
                    throw new IllegalArgumentException(("property \"access\" is of type \"org.hisp.dhis.api.model.v2_35_13.Access\", but got "+ value.getClass().toString()));
                }
                return true;
            case "aggregateExportAttributeOptionCombo":
                if (value instanceof String) {
                    setAggregateExportAttributeOptionCombo(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"aggregateExportAttributeOptionCombo\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "aggregateExportCategoryOptionCombo":
                if (value instanceof String) {
                    setAggregateExportCategoryOptionCombo(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"aggregateExportCategoryOptionCombo\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "aggregationType":
                if (value instanceof AggregationType) {
                    setAggregationType(((AggregationType) value));
                } else {
                    throw new IllegalArgumentException(("property \"aggregationType\" is of type \"org.hisp.dhis.api.model.v2_35_13.AggregationType\", but got "+ value.getClass().toString()));
                }
                return true;
            case "annualized":
                if (value instanceof Boolean) {
                    setAnnualized(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"annualized\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "attributeValues":
                if (value instanceof List) {
                    setAttributeValues(((List<AttributeValue> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"attributeValues\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.AttributeValue>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "code":
                if (value instanceof String) {
                    setCode(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"code\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "created":
                if (value instanceof Date) {
                    setCreated(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"created\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dataSets":
                if (value instanceof List) {
                    setDataSets(((List<DataSet> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"dataSets\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.DataSet>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "decimals":
                if (value instanceof Integer) {
                    setDecimals(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"decimals\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "denominator":
                if (value instanceof String) {
                    setDenominator(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"denominator\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "denominatorDescription":
                if (value instanceof String) {
                    setDenominatorDescription(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"denominatorDescription\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "description":
                if (value instanceof String) {
                    setDescription(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"description\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dimensionItem":
                if (value instanceof String) {
                    setDimensionItem(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"dimensionItem\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dimensionItemType":
                if (value instanceof org.hisp.dhis.api.model.v2_35_13.CategoryOptionCombo.DimensionItemType) {
                    setDimensionItemType(((org.hisp.dhis.api.model.v2_35_13.CategoryOptionCombo.DimensionItemType) value));
                } else {
                    throw new IllegalArgumentException(("property \"dimensionItemType\" is of type \"org.hisp.dhis.api.model.v2_35_13.CategoryOptionCombo.DimensionItemType\", but got "+ value.getClass().toString()));
                }
                return true;
            case "displayDenominatorDescription":
                if (value instanceof String) {
                    setDisplayDenominatorDescription(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayDenominatorDescription\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "displayDescription":
                if (value instanceof String) {
                    setDisplayDescription(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayDescription\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "displayFormName":
                if (value instanceof String) {
                    setDisplayFormName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayFormName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "displayName":
                if (value instanceof String) {
                    setDisplayName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "displayNumeratorDescription":
                if (value instanceof String) {
                    setDisplayNumeratorDescription(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayNumeratorDescription\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "displayShortName":
                if (value instanceof String) {
                    setDisplayShortName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayShortName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "externalAccess":
                if (value instanceof Boolean) {
                    setExternalAccess(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"externalAccess\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "favorite":
                if (value instanceof Boolean) {
                    setFavorite(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"favorite\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "favorites":
                if (value instanceof List) {
                    setFavorites(((List<String> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"favorites\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "formName":
                if (value instanceof String) {
                    setFormName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"formName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "href":
                if (value instanceof String) {
                    setHref(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"href\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "id":
                if (value instanceof String) {
                    setId(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"id\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "indicatorGroups":
                if (value instanceof List) {
                    setIndicatorGroups(((List<IndicatorGroup> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"indicatorGroups\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.IndicatorGroup>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "indicatorType":
                if (value instanceof IndicatorType) {
                    setIndicatorType(((IndicatorType) value));
                } else {
                    throw new IllegalArgumentException(("property \"indicatorType\" is of type \"org.hisp.dhis.api.model.v2_35_13.IndicatorType\", but got "+ value.getClass().toString()));
                }
                return true;
            case "lastUpdated":
                if (value instanceof Date) {
                    setLastUpdated(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"lastUpdated\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "lastUpdatedBy":
                if (value instanceof User) {
                    setLastUpdatedBy(((User) value));
                } else {
                    throw new IllegalArgumentException(("property \"lastUpdatedBy\" is of type \"org.hisp.dhis.api.model.v2_35_13.User\", but got "+ value.getClass().toString()));
                }
                return true;
            case "legendSet":
                if (value instanceof LegendSet) {
                    setLegendSet(((LegendSet) value));
                } else {
                    throw new IllegalArgumentException(("property \"legendSet\" is of type \"org.hisp.dhis.api.model.v2_35_13.LegendSet\", but got "+ value.getClass().toString()));
                }
                return true;
            case "legendSets":
                if (value instanceof List) {
                    setLegendSets(((List<LegendSet> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"legendSets\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.LegendSet>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "name":
                if (value instanceof String) {
                    setName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"name\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "numerator":
                if (value instanceof String) {
                    setNumerator(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"numerator\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "numeratorDescription":
                if (value instanceof String) {
                    setNumeratorDescription(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"numeratorDescription\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "periodOffset":
                if (value instanceof Integer) {
                    setPeriodOffset(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"periodOffset\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "publicAccess":
                if (value instanceof String) {
                    setPublicAccess(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"publicAccess\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "shortName":
                if (value instanceof String) {
                    setShortName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"shortName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "style":
                if (value instanceof ObjectStyle) {
                    setStyle(((ObjectStyle) value));
                } else {
                    throw new IllegalArgumentException(("property \"style\" is of type \"org.hisp.dhis.api.model.v2_35_13.ObjectStyle\", but got "+ value.getClass().toString()));
                }
                return true;
            case "translations":
                if (value instanceof List) {
                    setTranslations(((List<Translation> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"translations\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.Translation>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "url":
                if (value instanceof String) {
                    setUrl(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"url\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "user":
                if (value instanceof User) {
                    setUser(((User) value));
                } else {
                    throw new IllegalArgumentException(("property \"user\" is of type \"org.hisp.dhis.api.model.v2_35_13.User\", but got "+ value.getClass().toString()));
                }
                return true;
            case "userAccesses":
                if (value instanceof List) {
                    setUserAccesses(((List<UserAccess> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"userAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.UserAccess>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "userGroupAccesses":
                if (value instanceof List) {
                    setUserGroupAccesses(((List<UserGroupAccess> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"userGroupAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.UserGroupAccess>\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "access":
                return getAccess();
            case "aggregateExportAttributeOptionCombo":
                return getAggregateExportAttributeOptionCombo();
            case "aggregateExportCategoryOptionCombo":
                return getAggregateExportCategoryOptionCombo();
            case "aggregationType":
                return getAggregationType();
            case "annualized":
                return getAnnualized();
            case "attributeValues":
                return getAttributeValues();
            case "code":
                return getCode();
            case "created":
                return getCreated();
            case "dataSets":
                return getDataSets();
            case "decimals":
                return getDecimals();
            case "denominator":
                return getDenominator();
            case "denominatorDescription":
                return getDenominatorDescription();
            case "description":
                return getDescription();
            case "dimensionItem":
                return getDimensionItem();
            case "dimensionItemType":
                return getDimensionItemType();
            case "displayDenominatorDescription":
                return getDisplayDenominatorDescription();
            case "displayDescription":
                return getDisplayDescription();
            case "displayFormName":
                return getDisplayFormName();
            case "displayName":
                return getDisplayName();
            case "displayNumeratorDescription":
                return getDisplayNumeratorDescription();
            case "displayShortName":
                return getDisplayShortName();
            case "externalAccess":
                return getExternalAccess();
            case "favorite":
                return getFavorite();
            case "favorites":
                return getFavorites();
            case "formName":
                return getFormName();
            case "href":
                return getHref();
            case "id":
                return getId();
            case "indicatorGroups":
                return getIndicatorGroups();
            case "indicatorType":
                return getIndicatorType();
            case "lastUpdated":
                return getLastUpdated();
            case "lastUpdatedBy":
                return getLastUpdatedBy();
            case "legendSet":
                return getLegendSet();
            case "legendSets":
                return getLegendSets();
            case "name":
                return getName();
            case "numerator":
                return getNumerator();
            case "numeratorDescription":
                return getNumeratorDescription();
            case "periodOffset":
                return getPeriodOffset();
            case "publicAccess":
                return getPublicAccess();
            case "shortName":
                return getShortName();
            case "style":
                return getStyle();
            case "translations":
                return getTranslations();
            case "url":
                return getUrl();
            case "user":
                return getUser();
            case "userAccesses":
                return getUserAccesses();
            case "userGroupAccesses":
                return getUserGroupAccesses();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, Indicator.NOT_FOUND_VALUE);
        if (Indicator.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public Indicator with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Indicator.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("access");
        sb.append('=');
        sb.append(((this.access == null)?"<null>":this.access));
        sb.append(',');
        sb.append("aggregateExportAttributeOptionCombo");
        sb.append('=');
        sb.append(((this.aggregateExportAttributeOptionCombo == null)?"<null>":this.aggregateExportAttributeOptionCombo));
        sb.append(',');
        sb.append("aggregateExportCategoryOptionCombo");
        sb.append('=');
        sb.append(((this.aggregateExportCategoryOptionCombo == null)?"<null>":this.aggregateExportCategoryOptionCombo));
        sb.append(',');
        sb.append("aggregationType");
        sb.append('=');
        sb.append(((this.aggregationType == null)?"<null>":this.aggregationType));
        sb.append(',');
        sb.append("annualized");
        sb.append('=');
        sb.append(((this.annualized == null)?"<null>":this.annualized));
        sb.append(',');
        sb.append("attributeValues");
        sb.append('=');
        sb.append(((this.attributeValues == null)?"<null>":this.attributeValues));
        sb.append(',');
        sb.append("code");
        sb.append('=');
        sb.append(((this.code == null)?"<null>":this.code));
        sb.append(',');
        sb.append("created");
        sb.append('=');
        sb.append(((this.created == null)?"<null>":this.created));
        sb.append(',');
        sb.append("dataSets");
        sb.append('=');
        sb.append(((this.dataSets == null)?"<null>":this.dataSets));
        sb.append(',');
        sb.append("decimals");
        sb.append('=');
        sb.append(((this.decimals == null)?"<null>":this.decimals));
        sb.append(',');
        sb.append("denominator");
        sb.append('=');
        sb.append(((this.denominator == null)?"<null>":this.denominator));
        sb.append(',');
        sb.append("denominatorDescription");
        sb.append('=');
        sb.append(((this.denominatorDescription == null)?"<null>":this.denominatorDescription));
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(((this.description == null)?"<null>":this.description));
        sb.append(',');
        sb.append("dimensionItem");
        sb.append('=');
        sb.append(((this.dimensionItem == null)?"<null>":this.dimensionItem));
        sb.append(',');
        sb.append("dimensionItemType");
        sb.append('=');
        sb.append(((this.dimensionItemType == null)?"<null>":this.dimensionItemType));
        sb.append(',');
        sb.append("displayDenominatorDescription");
        sb.append('=');
        sb.append(((this.displayDenominatorDescription == null)?"<null>":this.displayDenominatorDescription));
        sb.append(',');
        sb.append("displayDescription");
        sb.append('=');
        sb.append(((this.displayDescription == null)?"<null>":this.displayDescription));
        sb.append(',');
        sb.append("displayFormName");
        sb.append('=');
        sb.append(((this.displayFormName == null)?"<null>":this.displayFormName));
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(((this.displayName == null)?"<null>":this.displayName));
        sb.append(',');
        sb.append("displayNumeratorDescription");
        sb.append('=');
        sb.append(((this.displayNumeratorDescription == null)?"<null>":this.displayNumeratorDescription));
        sb.append(',');
        sb.append("displayShortName");
        sb.append('=');
        sb.append(((this.displayShortName == null)?"<null>":this.displayShortName));
        sb.append(',');
        sb.append("externalAccess");
        sb.append('=');
        sb.append(((this.externalAccess == null)?"<null>":this.externalAccess));
        sb.append(',');
        sb.append("favorite");
        sb.append('=');
        sb.append(((this.favorite == null)?"<null>":this.favorite));
        sb.append(',');
        sb.append("favorites");
        sb.append('=');
        sb.append(((this.favorites == null)?"<null>":this.favorites));
        sb.append(',');
        sb.append("formName");
        sb.append('=');
        sb.append(((this.formName == null)?"<null>":this.formName));
        sb.append(',');
        sb.append("href");
        sb.append('=');
        sb.append(((this.href == null)?"<null>":this.href));
        sb.append(',');
        sb.append("id");
        sb.append('=');
        sb.append(((this.id == null)?"<null>":this.id));
        sb.append(',');
        sb.append("indicatorGroups");
        sb.append('=');
        sb.append(((this.indicatorGroups == null)?"<null>":this.indicatorGroups));
        sb.append(',');
        sb.append("indicatorType");
        sb.append('=');
        sb.append(((this.indicatorType == null)?"<null>":this.indicatorType));
        sb.append(',');
        sb.append("lastUpdated");
        sb.append('=');
        sb.append(((this.lastUpdated == null)?"<null>":this.lastUpdated));
        sb.append(',');
        sb.append("lastUpdatedBy");
        sb.append('=');
        sb.append(((this.lastUpdatedBy == null)?"<null>":this.lastUpdatedBy));
        sb.append(',');
        sb.append("legendSet");
        sb.append('=');
        sb.append(((this.legendSet == null)?"<null>":this.legendSet));
        sb.append(',');
        sb.append("legendSets");
        sb.append('=');
        sb.append(((this.legendSets == null)?"<null>":this.legendSets));
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("numerator");
        sb.append('=');
        sb.append(((this.numerator == null)?"<null>":this.numerator));
        sb.append(',');
        sb.append("numeratorDescription");
        sb.append('=');
        sb.append(((this.numeratorDescription == null)?"<null>":this.numeratorDescription));
        sb.append(',');
        sb.append("periodOffset");
        sb.append('=');
        sb.append(((this.periodOffset == null)?"<null>":this.periodOffset));
        sb.append(',');
        sb.append("publicAccess");
        sb.append('=');
        sb.append(((this.publicAccess == null)?"<null>":this.publicAccess));
        sb.append(',');
        sb.append("shortName");
        sb.append('=');
        sb.append(((this.shortName == null)?"<null>":this.shortName));
        sb.append(',');
        sb.append("style");
        sb.append('=');
        sb.append(((this.style == null)?"<null>":this.style));
        sb.append(',');
        sb.append("translations");
        sb.append('=');
        sb.append(((this.translations == null)?"<null>":this.translations));
        sb.append(',');
        sb.append("url");
        sb.append('=');
        sb.append(((this.url == null)?"<null>":this.url));
        sb.append(',');
        sb.append("user");
        sb.append('=');
        sb.append(((this.user == null)?"<null>":this.user));
        sb.append(',');
        sb.append("userAccesses");
        sb.append('=');
        sb.append(((this.userAccesses == null)?"<null>":this.userAccesses));
        sb.append(',');
        sb.append("userGroupAccesses");
        sb.append('=');
        sb.append(((this.userGroupAccesses == null)?"<null>":this.userGroupAccesses));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.favorites == null)? 0 :this.favorites.hashCode()));
        result = ((result* 31)+((this.aggregationType == null)? 0 :this.aggregationType.hashCode()));
        result = ((result* 31)+((this.access == null)? 0 :this.access.hashCode()));
        result = ((result* 31)+((this.code == null)? 0 :this.code.hashCode()));
        result = ((result* 31)+((this.displayName == null)? 0 :this.displayName.hashCode()));
        result = ((result* 31)+((this.publicAccess == null)? 0 :this.publicAccess.hashCode()));
        result = ((result* 31)+((this.aggregateExportCategoryOptionCombo == null)? 0 :this.aggregateExportCategoryOptionCombo.hashCode()));
        result = ((result* 31)+((this.description == null)? 0 :this.description.hashCode()));
        result = ((result* 31)+((this.displayShortName == null)? 0 :this.displayShortName.hashCode()));
        result = ((result* 31)+((this.externalAccess == null)? 0 :this.externalAccess.hashCode()));
        result = ((result* 31)+((this.displayNumeratorDescription == null)? 0 :this.displayNumeratorDescription.hashCode()));
        result = ((result* 31)+((this.lastUpdated == null)? 0 :this.lastUpdated.hashCode()));
        result = ((result* 31)+((this.denominatorDescription == null)? 0 :this.denominatorDescription.hashCode()));
        result = ((result* 31)+((this.periodOffset == null)? 0 :this.periodOffset.hashCode()));
        result = ((result* 31)+((this.indicatorType == null)? 0 :this.indicatorType.hashCode()));
        result = ((result* 31)+((this.translations == null)? 0 :this.translations.hashCode()));
        result = ((result* 31)+((this.formName == null)? 0 :this.formName.hashCode()));
        result = ((result* 31)+((this.href == null)? 0 :this.href.hashCode()));
        result = ((result* 31)+((this.id == null)? 0 :this.id.hashCode()));
        result = ((result* 31)+((this.displayDenominatorDescription == null)? 0 :this.displayDenominatorDescription.hashCode()));
        result = ((result* 31)+((this.numeratorDescription == null)? 0 :this.numeratorDescription.hashCode()));
        result = ((result* 31)+((this.displayDescription == null)? 0 :this.displayDescription.hashCode()));
        result = ((result* 31)+((this.lastUpdatedBy == null)? 0 :this.lastUpdatedBy.hashCode()));
        result = ((result* 31)+((this.userGroupAccesses == null)? 0 :this.userGroupAccesses.hashCode()));
        result = ((result* 31)+((this.dimensionItem == null)? 0 :this.dimensionItem.hashCode()));
        result = ((result* 31)+((this.created == null)? 0 :this.created.hashCode()));
        result = ((result* 31)+((this.attributeValues == null)? 0 :this.attributeValues.hashCode()));
        result = ((result* 31)+((this.indicatorGroups == null)? 0 :this.indicatorGroups.hashCode()));
        result = ((result* 31)+((this.displayFormName == null)? 0 :this.displayFormName.hashCode()));
        result = ((result* 31)+((this.url == null)? 0 :this.url.hashCode()));
        result = ((result* 31)+((this.denominator == null)? 0 :this.denominator.hashCode()));
        result = ((result* 31)+((this.numerator == null)? 0 :this.numerator.hashCode()));
        result = ((result* 31)+((this.annualized == null)? 0 :this.annualized.hashCode()));
        result = ((result* 31)+((this.decimals == null)? 0 :this.decimals.hashCode()));
        result = ((result* 31)+((this.userAccesses == null)? 0 :this.userAccesses.hashCode()));
        result = ((result* 31)+((this.legendSet == null)? 0 :this.legendSet.hashCode()));
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.dataSets == null)? 0 :this.dataSets.hashCode()));
        result = ((result* 31)+((this.legendSets == null)? 0 :this.legendSets.hashCode()));
        result = ((result* 31)+((this.style == null)? 0 :this.style.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.shortName == null)? 0 :this.shortName.hashCode()));
        result = ((result* 31)+((this.aggregateExportAttributeOptionCombo == null)? 0 :this.aggregateExportAttributeOptionCombo.hashCode()));
        result = ((result* 31)+((this.favorite == null)? 0 :this.favorite.hashCode()));
        result = ((result* 31)+((this.user == null)? 0 :this.user.hashCode()));
        result = ((result* 31)+((this.dimensionItemType == null)? 0 :this.dimensionItemType.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Indicator) == false) {
            return false;
        }
        Indicator rhs = ((Indicator) other);
        return (((((((((((((((((((((((((((((((((((((((((((((((this.favorites == rhs.favorites)||((this.favorites!= null)&&this.favorites.equals(rhs.favorites)))&&((this.aggregationType == rhs.aggregationType)||((this.aggregationType!= null)&&this.aggregationType.equals(rhs.aggregationType))))&&((this.access == rhs.access)||((this.access!= null)&&this.access.equals(rhs.access))))&&((this.code == rhs.code)||((this.code!= null)&&this.code.equals(rhs.code))))&&((this.displayName == rhs.displayName)||((this.displayName!= null)&&this.displayName.equals(rhs.displayName))))&&((this.publicAccess == rhs.publicAccess)||((this.publicAccess!= null)&&this.publicAccess.equals(rhs.publicAccess))))&&((this.aggregateExportCategoryOptionCombo == rhs.aggregateExportCategoryOptionCombo)||((this.aggregateExportCategoryOptionCombo!= null)&&this.aggregateExportCategoryOptionCombo.equals(rhs.aggregateExportCategoryOptionCombo))))&&((this.description == rhs.description)||((this.description!= null)&&this.description.equals(rhs.description))))&&((this.displayShortName == rhs.displayShortName)||((this.displayShortName!= null)&&this.displayShortName.equals(rhs.displayShortName))))&&((this.externalAccess == rhs.externalAccess)||((this.externalAccess!= null)&&this.externalAccess.equals(rhs.externalAccess))))&&((this.displayNumeratorDescription == rhs.displayNumeratorDescription)||((this.displayNumeratorDescription!= null)&&this.displayNumeratorDescription.equals(rhs.displayNumeratorDescription))))&&((this.lastUpdated == rhs.lastUpdated)||((this.lastUpdated!= null)&&this.lastUpdated.equals(rhs.lastUpdated))))&&((this.denominatorDescription == rhs.denominatorDescription)||((this.denominatorDescription!= null)&&this.denominatorDescription.equals(rhs.denominatorDescription))))&&((this.periodOffset == rhs.periodOffset)||((this.periodOffset!= null)&&this.periodOffset.equals(rhs.periodOffset))))&&((this.indicatorType == rhs.indicatorType)||((this.indicatorType!= null)&&this.indicatorType.equals(rhs.indicatorType))))&&((this.translations == rhs.translations)||((this.translations!= null)&&this.translations.equals(rhs.translations))))&&((this.formName == rhs.formName)||((this.formName!= null)&&this.formName.equals(rhs.formName))))&&((this.href == rhs.href)||((this.href!= null)&&this.href.equals(rhs.href))))&&((this.id == rhs.id)||((this.id!= null)&&this.id.equals(rhs.id))))&&((this.displayDenominatorDescription == rhs.displayDenominatorDescription)||((this.displayDenominatorDescription!= null)&&this.displayDenominatorDescription.equals(rhs.displayDenominatorDescription))))&&((this.numeratorDescription == rhs.numeratorDescription)||((this.numeratorDescription!= null)&&this.numeratorDescription.equals(rhs.numeratorDescription))))&&((this.displayDescription == rhs.displayDescription)||((this.displayDescription!= null)&&this.displayDescription.equals(rhs.displayDescription))))&&((this.lastUpdatedBy == rhs.lastUpdatedBy)||((this.lastUpdatedBy!= null)&&this.lastUpdatedBy.equals(rhs.lastUpdatedBy))))&&((this.userGroupAccesses == rhs.userGroupAccesses)||((this.userGroupAccesses!= null)&&this.userGroupAccesses.equals(rhs.userGroupAccesses))))&&((this.dimensionItem == rhs.dimensionItem)||((this.dimensionItem!= null)&&this.dimensionItem.equals(rhs.dimensionItem))))&&((this.created == rhs.created)||((this.created!= null)&&this.created.equals(rhs.created))))&&((this.attributeValues == rhs.attributeValues)||((this.attributeValues!= null)&&this.attributeValues.equals(rhs.attributeValues))))&&((this.indicatorGroups == rhs.indicatorGroups)||((this.indicatorGroups!= null)&&this.indicatorGroups.equals(rhs.indicatorGroups))))&&((this.displayFormName == rhs.displayFormName)||((this.displayFormName!= null)&&this.displayFormName.equals(rhs.displayFormName))))&&((this.url == rhs.url)||((this.url!= null)&&this.url.equals(rhs.url))))&&((this.denominator == rhs.denominator)||((this.denominator!= null)&&this.denominator.equals(rhs.denominator))))&&((this.numerator == rhs.numerator)||((this.numerator!= null)&&this.numerator.equals(rhs.numerator))))&&((this.annualized == rhs.annualized)||((this.annualized!= null)&&this.annualized.equals(rhs.annualized))))&&((this.decimals == rhs.decimals)||((this.decimals!= null)&&this.decimals.equals(rhs.decimals))))&&((this.userAccesses == rhs.userAccesses)||((this.userAccesses!= null)&&this.userAccesses.equals(rhs.userAccesses))))&&((this.legendSet == rhs.legendSet)||((this.legendSet!= null)&&this.legendSet.equals(rhs.legendSet))))&&((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name))))&&((this.dataSets == rhs.dataSets)||((this.dataSets!= null)&&this.dataSets.equals(rhs.dataSets))))&&((this.legendSets == rhs.legendSets)||((this.legendSets!= null)&&this.legendSets.equals(rhs.legendSets))))&&((this.style == rhs.style)||((this.style!= null)&&this.style.equals(rhs.style))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.shortName == rhs.shortName)||((this.shortName!= null)&&this.shortName.equals(rhs.shortName))))&&((this.aggregateExportAttributeOptionCombo == rhs.aggregateExportAttributeOptionCombo)||((this.aggregateExportAttributeOptionCombo!= null)&&this.aggregateExportAttributeOptionCombo.equals(rhs.aggregateExportAttributeOptionCombo))))&&((this.favorite == rhs.favorite)||((this.favorite!= null)&&this.favorite.equals(rhs.favorite))))&&((this.user == rhs.user)||((this.user!= null)&&this.user.equals(rhs.user))))&&((this.dimensionItemType == rhs.dimensionItemType)||((this.dimensionItemType!= null)&&this.dimensionItemType.equals(rhs.dimensionItemType))));
    }

}
