
package org.hisp.dhis.api.model.v2_35_13;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "access",
    "assignee",
    "attributeValues",
    "code",
    "created",
    "displayName",
    "externalAccess",
    "favorite",
    "favorites",
    "followUp",
    "href",
    "id",
    "lastMessage",
    "lastSender",
    "lastSenderFirstname",
    "lastSenderSurname",
    "lastUpdated",
    "lastUpdatedBy",
    "messageCount",
    "messageType",
    "messages",
    "name",
    "priority",
    "publicAccess",
    "read",
    "status",
    "subject",
    "translations",
    "user",
    "userAccesses",
    "userFirstname",
    "userGroupAccesses",
    "userMessages",
    "userSurname"
})
@Generated("jsonschema2pojo")
public class MessageConversation implements Serializable
{

    @JsonProperty("access")
    private Access access;
    @JsonProperty("assignee")
    private User assignee;
    @JsonProperty("attributeValues")
    private List<AttributeValue> attributeValues = null;
    @JsonProperty("code")
    private String code;
    @JsonProperty("created")
    private Date created;
    @JsonProperty("displayName")
    private String displayName;
    @JsonProperty("externalAccess")
    private Boolean externalAccess;
    @JsonProperty("favorite")
    private Boolean favorite;
    @JsonProperty("favorites")
    private List<String> favorites = null;
    @JsonProperty("followUp")
    private Boolean followUp;
    @JsonProperty("href")
    private String href;
    @JsonProperty("id")
    private String id;
    @JsonProperty("lastMessage")
    private Date lastMessage;
    @JsonProperty("lastSender")
    private User lastSender;
    @JsonProperty("lastSenderFirstname")
    private String lastSenderFirstname;
    @JsonProperty("lastSenderSurname")
    private String lastSenderSurname;
    @JsonProperty("lastUpdated")
    private Date lastUpdated;
    @JsonProperty("lastUpdatedBy")
    private User lastUpdatedBy;
    @JsonProperty("messageCount")
    private Integer messageCount;
    @JsonProperty("messageType")
    private MessageConversation.MessageType messageType;
    @JsonProperty("messages")
    private List<Message> messages = null;
    @JsonProperty("name")
    private String name;
    @JsonProperty("priority")
    private MessageConversation.MessageConversationPriority priority;
    @JsonProperty("publicAccess")
    private String publicAccess;
    @JsonProperty("read")
    private Boolean read;
    @JsonProperty("status")
    private MessageConversation.MessageConversationStatus status;
    @JsonProperty("subject")
    private String subject;
    @JsonProperty("translations")
    private List<Translation> translations = null;
    @JsonProperty("user")
    private User user;
    @JsonProperty("userAccesses")
    private List<UserAccess> userAccesses = null;
    @JsonProperty("userFirstname")
    private String userFirstname;
    @JsonProperty("userGroupAccesses")
    private List<UserGroupAccess> userGroupAccesses = null;
    @JsonProperty("userMessages")
    private List<UserMessage> userMessages = null;
    @JsonProperty("userSurname")
    private String userSurname;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -5737098376438676022L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public MessageConversation() {
    }

    /**
     * 
     * @param source
     */
    public MessageConversation(MessageConversation source) {
        super();
        this.access = source.access;
        this.assignee = source.assignee;
        this.attributeValues = source.attributeValues;
        this.code = source.code;
        this.created = source.created;
        this.displayName = source.displayName;
        this.externalAccess = source.externalAccess;
        this.favorite = source.favorite;
        this.favorites = source.favorites;
        this.followUp = source.followUp;
        this.href = source.href;
        this.id = source.id;
        this.lastMessage = source.lastMessage;
        this.lastSender = source.lastSender;
        this.lastSenderFirstname = source.lastSenderFirstname;
        this.lastSenderSurname = source.lastSenderSurname;
        this.lastUpdated = source.lastUpdated;
        this.lastUpdatedBy = source.lastUpdatedBy;
        this.messageCount = source.messageCount;
        this.messageType = source.messageType;
        this.messages = source.messages;
        this.name = source.name;
        this.priority = source.priority;
        this.publicAccess = source.publicAccess;
        this.read = source.read;
        this.status = source.status;
        this.subject = source.subject;
        this.translations = source.translations;
        this.user = source.user;
        this.userAccesses = source.userAccesses;
        this.userFirstname = source.userFirstname;
        this.userGroupAccesses = source.userGroupAccesses;
        this.userMessages = source.userMessages;
        this.userSurname = source.userSurname;
    }

    /**
     * 
     * @param favorites
     * @param access
     * @param code
     * @param messageCount
     * @param displayName
     * @param publicAccess
     * @param subject
     * @param externalAccess
     * @param followUp
     * @param lastUpdated
     * @param messageType
     * @param translations
     * @param userMessages
     * @param href
     * @param id
     * @param userSurname
     * @param lastSenderSurname
     * @param lastUpdatedBy
     * @param lastSender
     * @param read
     * @param userGroupAccesses
     * @param created
     * @param attributeValues
     * @param lastMessage
     * @param priority
     * @param lastSenderFirstname
     * @param userAccesses
     * @param name
     * @param messages
     * @param userFirstname
     * @param assignee
     * @param favorite
     * @param user
     * @param status
     */
    public MessageConversation(Access access, User assignee, List<AttributeValue> attributeValues, String code, Date created, String displayName, Boolean externalAccess, Boolean favorite, List<String> favorites, Boolean followUp, String href, String id, Date lastMessage, User lastSender, String lastSenderFirstname, String lastSenderSurname, Date lastUpdated, User lastUpdatedBy, Integer messageCount, MessageConversation.MessageType messageType, List<Message> messages, String name, MessageConversation.MessageConversationPriority priority, String publicAccess, Boolean read, MessageConversation.MessageConversationStatus status, String subject, List<Translation> translations, User user, List<UserAccess> userAccesses, String userFirstname, List<UserGroupAccess> userGroupAccesses, List<UserMessage> userMessages, String userSurname) {
        super();
        this.access = access;
        this.assignee = assignee;
        this.attributeValues = attributeValues;
        this.code = code;
        this.created = created;
        this.displayName = displayName;
        this.externalAccess = externalAccess;
        this.favorite = favorite;
        this.favorites = favorites;
        this.followUp = followUp;
        this.href = href;
        this.id = id;
        this.lastMessage = lastMessage;
        this.lastSender = lastSender;
        this.lastSenderFirstname = lastSenderFirstname;
        this.lastSenderSurname = lastSenderSurname;
        this.lastUpdated = lastUpdated;
        this.lastUpdatedBy = lastUpdatedBy;
        this.messageCount = messageCount;
        this.messageType = messageType;
        this.messages = messages;
        this.name = name;
        this.priority = priority;
        this.publicAccess = publicAccess;
        this.read = read;
        this.status = status;
        this.subject = subject;
        this.translations = translations;
        this.user = user;
        this.userAccesses = userAccesses;
        this.userFirstname = userFirstname;
        this.userGroupAccesses = userGroupAccesses;
        this.userMessages = userMessages;
        this.userSurname = userSurname;
    }

    @JsonProperty("access")
    public Optional<Access> getAccess() {
        return Optional.ofNullable(access);
    }

    @JsonProperty("access")
    public void setAccess(Access access) {
        this.access = access;
    }

    public MessageConversation withAccess(Access access) {
        this.access = access;
        return this;
    }

    @JsonProperty("assignee")
    public Optional<User> getAssignee() {
        return Optional.ofNullable(assignee);
    }

    @JsonProperty("assignee")
    public void setAssignee(User assignee) {
        this.assignee = assignee;
    }

    public MessageConversation withAssignee(User assignee) {
        this.assignee = assignee;
        return this;
    }

    @JsonProperty("attributeValues")
    public Optional<List<AttributeValue>> getAttributeValues() {
        return Optional.ofNullable(attributeValues);
    }

    @JsonProperty("attributeValues")
    public void setAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
    }

    public MessageConversation withAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
        return this;
    }

    @JsonProperty("code")
    public Optional<String> getCode() {
        return Optional.ofNullable(code);
    }

    @JsonProperty("code")
    public void setCode(String code) {
        this.code = code;
    }

    public MessageConversation withCode(String code) {
        this.code = code;
        return this;
    }

    @JsonProperty("created")
    public Optional<Date> getCreated() {
        return Optional.ofNullable(created);
    }

    @JsonProperty("created")
    public void setCreated(Date created) {
        this.created = created;
    }

    public MessageConversation withCreated(Date created) {
        this.created = created;
        return this;
    }

    @JsonProperty("displayName")
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    @JsonProperty("displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public MessageConversation withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @JsonProperty("externalAccess")
    public Optional<Boolean> getExternalAccess() {
        return Optional.ofNullable(externalAccess);
    }

    @JsonProperty("externalAccess")
    public void setExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
    }

    public MessageConversation withExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
        return this;
    }

    @JsonProperty("favorite")
    public Optional<Boolean> getFavorite() {
        return Optional.ofNullable(favorite);
    }

    @JsonProperty("favorite")
    public void setFavorite(Boolean favorite) {
        this.favorite = favorite;
    }

    public MessageConversation withFavorite(Boolean favorite) {
        this.favorite = favorite;
        return this;
    }

    @JsonProperty("favorites")
    public Optional<List<String>> getFavorites() {
        return Optional.ofNullable(favorites);
    }

    @JsonProperty("favorites")
    public void setFavorites(List<String> favorites) {
        this.favorites = favorites;
    }

    public MessageConversation withFavorites(List<String> favorites) {
        this.favorites = favorites;
        return this;
    }

    @JsonProperty("followUp")
    public Optional<Boolean> getFollowUp() {
        return Optional.ofNullable(followUp);
    }

    @JsonProperty("followUp")
    public void setFollowUp(Boolean followUp) {
        this.followUp = followUp;
    }

    public MessageConversation withFollowUp(Boolean followUp) {
        this.followUp = followUp;
        return this;
    }

    @JsonProperty("href")
    public Optional<String> getHref() {
        return Optional.ofNullable(href);
    }

    @JsonProperty("href")
    public void setHref(String href) {
        this.href = href;
    }

    public MessageConversation withHref(String href) {
        this.href = href;
        return this;
    }

    @JsonProperty("id")
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    @JsonProperty("id")
    public void setId(String id) {
        this.id = id;
    }

    public MessageConversation withId(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty("lastMessage")
    public Optional<Date> getLastMessage() {
        return Optional.ofNullable(lastMessage);
    }

    @JsonProperty("lastMessage")
    public void setLastMessage(Date lastMessage) {
        this.lastMessage = lastMessage;
    }

    public MessageConversation withLastMessage(Date lastMessage) {
        this.lastMessage = lastMessage;
        return this;
    }

    @JsonProperty("lastSender")
    public Optional<User> getLastSender() {
        return Optional.ofNullable(lastSender);
    }

    @JsonProperty("lastSender")
    public void setLastSender(User lastSender) {
        this.lastSender = lastSender;
    }

    public MessageConversation withLastSender(User lastSender) {
        this.lastSender = lastSender;
        return this;
    }

    @JsonProperty("lastSenderFirstname")
    public Optional<String> getLastSenderFirstname() {
        return Optional.ofNullable(lastSenderFirstname);
    }

    @JsonProperty("lastSenderFirstname")
    public void setLastSenderFirstname(String lastSenderFirstname) {
        this.lastSenderFirstname = lastSenderFirstname;
    }

    public MessageConversation withLastSenderFirstname(String lastSenderFirstname) {
        this.lastSenderFirstname = lastSenderFirstname;
        return this;
    }

    @JsonProperty("lastSenderSurname")
    public Optional<String> getLastSenderSurname() {
        return Optional.ofNullable(lastSenderSurname);
    }

    @JsonProperty("lastSenderSurname")
    public void setLastSenderSurname(String lastSenderSurname) {
        this.lastSenderSurname = lastSenderSurname;
    }

    public MessageConversation withLastSenderSurname(String lastSenderSurname) {
        this.lastSenderSurname = lastSenderSurname;
        return this;
    }

    @JsonProperty("lastUpdated")
    public Optional<Date> getLastUpdated() {
        return Optional.ofNullable(lastUpdated);
    }

    @JsonProperty("lastUpdated")
    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public MessageConversation withLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
        return this;
    }

    @JsonProperty("lastUpdatedBy")
    public Optional<User> getLastUpdatedBy() {
        return Optional.ofNullable(lastUpdatedBy);
    }

    @JsonProperty("lastUpdatedBy")
    public void setLastUpdatedBy(User lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
    }

    public MessageConversation withLastUpdatedBy(User lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
        return this;
    }

    @JsonProperty("messageCount")
    public Optional<Integer> getMessageCount() {
        return Optional.ofNullable(messageCount);
    }

    @JsonProperty("messageCount")
    public void setMessageCount(Integer messageCount) {
        this.messageCount = messageCount;
    }

    public MessageConversation withMessageCount(Integer messageCount) {
        this.messageCount = messageCount;
        return this;
    }

    @JsonProperty("messageType")
    public Optional<MessageConversation.MessageType> getMessageType() {
        return Optional.ofNullable(messageType);
    }

    @JsonProperty("messageType")
    public void setMessageType(MessageConversation.MessageType messageType) {
        this.messageType = messageType;
    }

    public MessageConversation withMessageType(MessageConversation.MessageType messageType) {
        this.messageType = messageType;
        return this;
    }

    @JsonProperty("messages")
    public Optional<List<Message>> getMessages() {
        return Optional.ofNullable(messages);
    }

    @JsonProperty("messages")
    public void setMessages(List<Message> messages) {
        this.messages = messages;
    }

    public MessageConversation withMessages(List<Message> messages) {
        this.messages = messages;
        return this;
    }

    @JsonProperty("name")
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public MessageConversation withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty("priority")
    public Optional<MessageConversation.MessageConversationPriority> getPriority() {
        return Optional.ofNullable(priority);
    }

    @JsonProperty("priority")
    public void setPriority(MessageConversation.MessageConversationPriority priority) {
        this.priority = priority;
    }

    public MessageConversation withPriority(MessageConversation.MessageConversationPriority priority) {
        this.priority = priority;
        return this;
    }

    @JsonProperty("publicAccess")
    public Optional<String> getPublicAccess() {
        return Optional.ofNullable(publicAccess);
    }

    @JsonProperty("publicAccess")
    public void setPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
    }

    public MessageConversation withPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
        return this;
    }

    @JsonProperty("read")
    public Optional<Boolean> getRead() {
        return Optional.ofNullable(read);
    }

    @JsonProperty("read")
    public void setRead(Boolean read) {
        this.read = read;
    }

    public MessageConversation withRead(Boolean read) {
        this.read = read;
        return this;
    }

    @JsonProperty("status")
    public Optional<MessageConversation.MessageConversationStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    @JsonProperty("status")
    public void setStatus(MessageConversation.MessageConversationStatus status) {
        this.status = status;
    }

    public MessageConversation withStatus(MessageConversation.MessageConversationStatus status) {
        this.status = status;
        return this;
    }

    @JsonProperty("subject")
    public Optional<String> getSubject() {
        return Optional.ofNullable(subject);
    }

    @JsonProperty("subject")
    public void setSubject(String subject) {
        this.subject = subject;
    }

    public MessageConversation withSubject(String subject) {
        this.subject = subject;
        return this;
    }

    @JsonProperty("translations")
    public Optional<List<Translation>> getTranslations() {
        return Optional.ofNullable(translations);
    }

    @JsonProperty("translations")
    public void setTranslations(List<Translation> translations) {
        this.translations = translations;
    }

    public MessageConversation withTranslations(List<Translation> translations) {
        this.translations = translations;
        return this;
    }

    @JsonProperty("user")
    public Optional<User> getUser() {
        return Optional.ofNullable(user);
    }

    @JsonProperty("user")
    public void setUser(User user) {
        this.user = user;
    }

    public MessageConversation withUser(User user) {
        this.user = user;
        return this;
    }

    @JsonProperty("userAccesses")
    public Optional<List<UserAccess>> getUserAccesses() {
        return Optional.ofNullable(userAccesses);
    }

    @JsonProperty("userAccesses")
    public void setUserAccesses(List<UserAccess> userAccesses) {
        this.userAccesses = userAccesses;
    }

    public MessageConversation withUserAccesses(List<UserAccess> userAccesses) {
        this.userAccesses = userAccesses;
        return this;
    }

    @JsonProperty("userFirstname")
    public Optional<String> getUserFirstname() {
        return Optional.ofNullable(userFirstname);
    }

    @JsonProperty("userFirstname")
    public void setUserFirstname(String userFirstname) {
        this.userFirstname = userFirstname;
    }

    public MessageConversation withUserFirstname(String userFirstname) {
        this.userFirstname = userFirstname;
        return this;
    }

    @JsonProperty("userGroupAccesses")
    public Optional<List<UserGroupAccess>> getUserGroupAccesses() {
        return Optional.ofNullable(userGroupAccesses);
    }

    @JsonProperty("userGroupAccesses")
    public void setUserGroupAccesses(List<UserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
    }

    public MessageConversation withUserGroupAccesses(List<UserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
        return this;
    }

    @JsonProperty("userMessages")
    public Optional<List<UserMessage>> getUserMessages() {
        return Optional.ofNullable(userMessages);
    }

    @JsonProperty("userMessages")
    public void setUserMessages(List<UserMessage> userMessages) {
        this.userMessages = userMessages;
    }

    public MessageConversation withUserMessages(List<UserMessage> userMessages) {
        this.userMessages = userMessages;
        return this;
    }

    @JsonProperty("userSurname")
    public Optional<String> getUserSurname() {
        return Optional.ofNullable(userSurname);
    }

    @JsonProperty("userSurname")
    public void setUserSurname(String userSurname) {
        this.userSurname = userSurname;
    }

    public MessageConversation withUserSurname(String userSurname) {
        this.userSurname = userSurname;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public MessageConversation withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "access":
                if (value instanceof Access) {
                    setAccess(((Access) value));
                } else {
                    throw new IllegalArgumentException(("property \"access\" is of type \"org.hisp.dhis.api.model.v2_35_13.Access\", but got "+ value.getClass().toString()));
                }
                return true;
            case "assignee":
                if (value instanceof User) {
                    setAssignee(((User) value));
                } else {
                    throw new IllegalArgumentException(("property \"assignee\" is of type \"org.hisp.dhis.api.model.v2_35_13.User\", but got "+ value.getClass().toString()));
                }
                return true;
            case "attributeValues":
                if (value instanceof List) {
                    setAttributeValues(((List<AttributeValue> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"attributeValues\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.AttributeValue>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "code":
                if (value instanceof String) {
                    setCode(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"code\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "created":
                if (value instanceof Date) {
                    setCreated(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"created\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "displayName":
                if (value instanceof String) {
                    setDisplayName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "externalAccess":
                if (value instanceof Boolean) {
                    setExternalAccess(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"externalAccess\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "favorite":
                if (value instanceof Boolean) {
                    setFavorite(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"favorite\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "favorites":
                if (value instanceof List) {
                    setFavorites(((List<String> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"favorites\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "followUp":
                if (value instanceof Boolean) {
                    setFollowUp(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"followUp\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "href":
                if (value instanceof String) {
                    setHref(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"href\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "id":
                if (value instanceof String) {
                    setId(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"id\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "lastMessage":
                if (value instanceof Date) {
                    setLastMessage(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"lastMessage\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "lastSender":
                if (value instanceof User) {
                    setLastSender(((User) value));
                } else {
                    throw new IllegalArgumentException(("property \"lastSender\" is of type \"org.hisp.dhis.api.model.v2_35_13.User\", but got "+ value.getClass().toString()));
                }
                return true;
            case "lastSenderFirstname":
                if (value instanceof String) {
                    setLastSenderFirstname(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"lastSenderFirstname\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "lastSenderSurname":
                if (value instanceof String) {
                    setLastSenderSurname(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"lastSenderSurname\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "lastUpdated":
                if (value instanceof Date) {
                    setLastUpdated(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"lastUpdated\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "lastUpdatedBy":
                if (value instanceof User) {
                    setLastUpdatedBy(((User) value));
                } else {
                    throw new IllegalArgumentException(("property \"lastUpdatedBy\" is of type \"org.hisp.dhis.api.model.v2_35_13.User\", but got "+ value.getClass().toString()));
                }
                return true;
            case "messageCount":
                if (value instanceof Integer) {
                    setMessageCount(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"messageCount\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "messageType":
                if (value instanceof MessageConversation.MessageType) {
                    setMessageType(((MessageConversation.MessageType) value));
                } else {
                    throw new IllegalArgumentException(("property \"messageType\" is of type \"org.hisp.dhis.api.model.v2_35_13.MessageConversation.MessageType\", but got "+ value.getClass().toString()));
                }
                return true;
            case "messages":
                if (value instanceof List) {
                    setMessages(((List<Message> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"messages\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.Message>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "name":
                if (value instanceof String) {
                    setName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"name\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "priority":
                if (value instanceof MessageConversation.MessageConversationPriority) {
                    setPriority(((MessageConversation.MessageConversationPriority) value));
                } else {
                    throw new IllegalArgumentException(("property \"priority\" is of type \"org.hisp.dhis.api.model.v2_35_13.MessageConversation.MessageConversationPriority\", but got "+ value.getClass().toString()));
                }
                return true;
            case "publicAccess":
                if (value instanceof String) {
                    setPublicAccess(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"publicAccess\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "read":
                if (value instanceof Boolean) {
                    setRead(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"read\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "status":
                if (value instanceof MessageConversation.MessageConversationStatus) {
                    setStatus(((MessageConversation.MessageConversationStatus) value));
                } else {
                    throw new IllegalArgumentException(("property \"status\" is of type \"org.hisp.dhis.api.model.v2_35_13.MessageConversation.MessageConversationStatus\", but got "+ value.getClass().toString()));
                }
                return true;
            case "subject":
                if (value instanceof String) {
                    setSubject(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"subject\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "translations":
                if (value instanceof List) {
                    setTranslations(((List<Translation> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"translations\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.Translation>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "user":
                if (value instanceof User) {
                    setUser(((User) value));
                } else {
                    throw new IllegalArgumentException(("property \"user\" is of type \"org.hisp.dhis.api.model.v2_35_13.User\", but got "+ value.getClass().toString()));
                }
                return true;
            case "userAccesses":
                if (value instanceof List) {
                    setUserAccesses(((List<UserAccess> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"userAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.UserAccess>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "userFirstname":
                if (value instanceof String) {
                    setUserFirstname(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"userFirstname\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "userGroupAccesses":
                if (value instanceof List) {
                    setUserGroupAccesses(((List<UserGroupAccess> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"userGroupAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.UserGroupAccess>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "userMessages":
                if (value instanceof List) {
                    setUserMessages(((List<UserMessage> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"userMessages\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.UserMessage>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "userSurname":
                if (value instanceof String) {
                    setUserSurname(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"userSurname\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "access":
                return getAccess();
            case "assignee":
                return getAssignee();
            case "attributeValues":
                return getAttributeValues();
            case "code":
                return getCode();
            case "created":
                return getCreated();
            case "displayName":
                return getDisplayName();
            case "externalAccess":
                return getExternalAccess();
            case "favorite":
                return getFavorite();
            case "favorites":
                return getFavorites();
            case "followUp":
                return getFollowUp();
            case "href":
                return getHref();
            case "id":
                return getId();
            case "lastMessage":
                return getLastMessage();
            case "lastSender":
                return getLastSender();
            case "lastSenderFirstname":
                return getLastSenderFirstname();
            case "lastSenderSurname":
                return getLastSenderSurname();
            case "lastUpdated":
                return getLastUpdated();
            case "lastUpdatedBy":
                return getLastUpdatedBy();
            case "messageCount":
                return getMessageCount();
            case "messageType":
                return getMessageType();
            case "messages":
                return getMessages();
            case "name":
                return getName();
            case "priority":
                return getPriority();
            case "publicAccess":
                return getPublicAccess();
            case "read":
                return getRead();
            case "status":
                return getStatus();
            case "subject":
                return getSubject();
            case "translations":
                return getTranslations();
            case "user":
                return getUser();
            case "userAccesses":
                return getUserAccesses();
            case "userFirstname":
                return getUserFirstname();
            case "userGroupAccesses":
                return getUserGroupAccesses();
            case "userMessages":
                return getUserMessages();
            case "userSurname":
                return getUserSurname();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, MessageConversation.NOT_FOUND_VALUE);
        if (MessageConversation.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public MessageConversation with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(MessageConversation.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("access");
        sb.append('=');
        sb.append(((this.access == null)?"<null>":this.access));
        sb.append(',');
        sb.append("assignee");
        sb.append('=');
        sb.append(((this.assignee == null)?"<null>":this.assignee));
        sb.append(',');
        sb.append("attributeValues");
        sb.append('=');
        sb.append(((this.attributeValues == null)?"<null>":this.attributeValues));
        sb.append(',');
        sb.append("code");
        sb.append('=');
        sb.append(((this.code == null)?"<null>":this.code));
        sb.append(',');
        sb.append("created");
        sb.append('=');
        sb.append(((this.created == null)?"<null>":this.created));
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(((this.displayName == null)?"<null>":this.displayName));
        sb.append(',');
        sb.append("externalAccess");
        sb.append('=');
        sb.append(((this.externalAccess == null)?"<null>":this.externalAccess));
        sb.append(',');
        sb.append("favorite");
        sb.append('=');
        sb.append(((this.favorite == null)?"<null>":this.favorite));
        sb.append(',');
        sb.append("favorites");
        sb.append('=');
        sb.append(((this.favorites == null)?"<null>":this.favorites));
        sb.append(',');
        sb.append("followUp");
        sb.append('=');
        sb.append(((this.followUp == null)?"<null>":this.followUp));
        sb.append(',');
        sb.append("href");
        sb.append('=');
        sb.append(((this.href == null)?"<null>":this.href));
        sb.append(',');
        sb.append("id");
        sb.append('=');
        sb.append(((this.id == null)?"<null>":this.id));
        sb.append(',');
        sb.append("lastMessage");
        sb.append('=');
        sb.append(((this.lastMessage == null)?"<null>":this.lastMessage));
        sb.append(',');
        sb.append("lastSender");
        sb.append('=');
        sb.append(((this.lastSender == null)?"<null>":this.lastSender));
        sb.append(',');
        sb.append("lastSenderFirstname");
        sb.append('=');
        sb.append(((this.lastSenderFirstname == null)?"<null>":this.lastSenderFirstname));
        sb.append(',');
        sb.append("lastSenderSurname");
        sb.append('=');
        sb.append(((this.lastSenderSurname == null)?"<null>":this.lastSenderSurname));
        sb.append(',');
        sb.append("lastUpdated");
        sb.append('=');
        sb.append(((this.lastUpdated == null)?"<null>":this.lastUpdated));
        sb.append(',');
        sb.append("lastUpdatedBy");
        sb.append('=');
        sb.append(((this.lastUpdatedBy == null)?"<null>":this.lastUpdatedBy));
        sb.append(',');
        sb.append("messageCount");
        sb.append('=');
        sb.append(((this.messageCount == null)?"<null>":this.messageCount));
        sb.append(',');
        sb.append("messageType");
        sb.append('=');
        sb.append(((this.messageType == null)?"<null>":this.messageType));
        sb.append(',');
        sb.append("messages");
        sb.append('=');
        sb.append(((this.messages == null)?"<null>":this.messages));
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("priority");
        sb.append('=');
        sb.append(((this.priority == null)?"<null>":this.priority));
        sb.append(',');
        sb.append("publicAccess");
        sb.append('=');
        sb.append(((this.publicAccess == null)?"<null>":this.publicAccess));
        sb.append(',');
        sb.append("read");
        sb.append('=');
        sb.append(((this.read == null)?"<null>":this.read));
        sb.append(',');
        sb.append("status");
        sb.append('=');
        sb.append(((this.status == null)?"<null>":this.status));
        sb.append(',');
        sb.append("subject");
        sb.append('=');
        sb.append(((this.subject == null)?"<null>":this.subject));
        sb.append(',');
        sb.append("translations");
        sb.append('=');
        sb.append(((this.translations == null)?"<null>":this.translations));
        sb.append(',');
        sb.append("user");
        sb.append('=');
        sb.append(((this.user == null)?"<null>":this.user));
        sb.append(',');
        sb.append("userAccesses");
        sb.append('=');
        sb.append(((this.userAccesses == null)?"<null>":this.userAccesses));
        sb.append(',');
        sb.append("userFirstname");
        sb.append('=');
        sb.append(((this.userFirstname == null)?"<null>":this.userFirstname));
        sb.append(',');
        sb.append("userGroupAccesses");
        sb.append('=');
        sb.append(((this.userGroupAccesses == null)?"<null>":this.userGroupAccesses));
        sb.append(',');
        sb.append("userMessages");
        sb.append('=');
        sb.append(((this.userMessages == null)?"<null>":this.userMessages));
        sb.append(',');
        sb.append("userSurname");
        sb.append('=');
        sb.append(((this.userSurname == null)?"<null>":this.userSurname));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.favorites == null)? 0 :this.favorites.hashCode()));
        result = ((result* 31)+((this.access == null)? 0 :this.access.hashCode()));
        result = ((result* 31)+((this.code == null)? 0 :this.code.hashCode()));
        result = ((result* 31)+((this.messageCount == null)? 0 :this.messageCount.hashCode()));
        result = ((result* 31)+((this.displayName == null)? 0 :this.displayName.hashCode()));
        result = ((result* 31)+((this.publicAccess == null)? 0 :this.publicAccess.hashCode()));
        result = ((result* 31)+((this.subject == null)? 0 :this.subject.hashCode()));
        result = ((result* 31)+((this.externalAccess == null)? 0 :this.externalAccess.hashCode()));
        result = ((result* 31)+((this.followUp == null)? 0 :this.followUp.hashCode()));
        result = ((result* 31)+((this.lastUpdated == null)? 0 :this.lastUpdated.hashCode()));
        result = ((result* 31)+((this.messageType == null)? 0 :this.messageType.hashCode()));
        result = ((result* 31)+((this.translations == null)? 0 :this.translations.hashCode()));
        result = ((result* 31)+((this.userMessages == null)? 0 :this.userMessages.hashCode()));
        result = ((result* 31)+((this.href == null)? 0 :this.href.hashCode()));
        result = ((result* 31)+((this.id == null)? 0 :this.id.hashCode()));
        result = ((result* 31)+((this.userSurname == null)? 0 :this.userSurname.hashCode()));
        result = ((result* 31)+((this.lastSenderSurname == null)? 0 :this.lastSenderSurname.hashCode()));
        result = ((result* 31)+((this.lastUpdatedBy == null)? 0 :this.lastUpdatedBy.hashCode()));
        result = ((result* 31)+((this.lastSender == null)? 0 :this.lastSender.hashCode()));
        result = ((result* 31)+((this.read == null)? 0 :this.read.hashCode()));
        result = ((result* 31)+((this.userGroupAccesses == null)? 0 :this.userGroupAccesses.hashCode()));
        result = ((result* 31)+((this.created == null)? 0 :this.created.hashCode()));
        result = ((result* 31)+((this.attributeValues == null)? 0 :this.attributeValues.hashCode()));
        result = ((result* 31)+((this.lastMessage == null)? 0 :this.lastMessage.hashCode()));
        result = ((result* 31)+((this.priority == null)? 0 :this.priority.hashCode()));
        result = ((result* 31)+((this.lastSenderFirstname == null)? 0 :this.lastSenderFirstname.hashCode()));
        result = ((result* 31)+((this.userAccesses == null)? 0 :this.userAccesses.hashCode()));
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.messages == null)? 0 :this.messages.hashCode()));
        result = ((result* 31)+((this.userFirstname == null)? 0 :this.userFirstname.hashCode()));
        result = ((result* 31)+((this.assignee == null)? 0 :this.assignee.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.favorite == null)? 0 :this.favorite.hashCode()));
        result = ((result* 31)+((this.user == null)? 0 :this.user.hashCode()));
        result = ((result* 31)+((this.status == null)? 0 :this.status.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof MessageConversation) == false) {
            return false;
        }
        MessageConversation rhs = ((MessageConversation) other);
        return ((((((((((((((((((((((((((((((((((((this.favorites == rhs.favorites)||((this.favorites!= null)&&this.favorites.equals(rhs.favorites)))&&((this.access == rhs.access)||((this.access!= null)&&this.access.equals(rhs.access))))&&((this.code == rhs.code)||((this.code!= null)&&this.code.equals(rhs.code))))&&((this.messageCount == rhs.messageCount)||((this.messageCount!= null)&&this.messageCount.equals(rhs.messageCount))))&&((this.displayName == rhs.displayName)||((this.displayName!= null)&&this.displayName.equals(rhs.displayName))))&&((this.publicAccess == rhs.publicAccess)||((this.publicAccess!= null)&&this.publicAccess.equals(rhs.publicAccess))))&&((this.subject == rhs.subject)||((this.subject!= null)&&this.subject.equals(rhs.subject))))&&((this.externalAccess == rhs.externalAccess)||((this.externalAccess!= null)&&this.externalAccess.equals(rhs.externalAccess))))&&((this.followUp == rhs.followUp)||((this.followUp!= null)&&this.followUp.equals(rhs.followUp))))&&((this.lastUpdated == rhs.lastUpdated)||((this.lastUpdated!= null)&&this.lastUpdated.equals(rhs.lastUpdated))))&&((this.messageType == rhs.messageType)||((this.messageType!= null)&&this.messageType.equals(rhs.messageType))))&&((this.translations == rhs.translations)||((this.translations!= null)&&this.translations.equals(rhs.translations))))&&((this.userMessages == rhs.userMessages)||((this.userMessages!= null)&&this.userMessages.equals(rhs.userMessages))))&&((this.href == rhs.href)||((this.href!= null)&&this.href.equals(rhs.href))))&&((this.id == rhs.id)||((this.id!= null)&&this.id.equals(rhs.id))))&&((this.userSurname == rhs.userSurname)||((this.userSurname!= null)&&this.userSurname.equals(rhs.userSurname))))&&((this.lastSenderSurname == rhs.lastSenderSurname)||((this.lastSenderSurname!= null)&&this.lastSenderSurname.equals(rhs.lastSenderSurname))))&&((this.lastUpdatedBy == rhs.lastUpdatedBy)||((this.lastUpdatedBy!= null)&&this.lastUpdatedBy.equals(rhs.lastUpdatedBy))))&&((this.lastSender == rhs.lastSender)||((this.lastSender!= null)&&this.lastSender.equals(rhs.lastSender))))&&((this.read == rhs.read)||((this.read!= null)&&this.read.equals(rhs.read))))&&((this.userGroupAccesses == rhs.userGroupAccesses)||((this.userGroupAccesses!= null)&&this.userGroupAccesses.equals(rhs.userGroupAccesses))))&&((this.created == rhs.created)||((this.created!= null)&&this.created.equals(rhs.created))))&&((this.attributeValues == rhs.attributeValues)||((this.attributeValues!= null)&&this.attributeValues.equals(rhs.attributeValues))))&&((this.lastMessage == rhs.lastMessage)||((this.lastMessage!= null)&&this.lastMessage.equals(rhs.lastMessage))))&&((this.priority == rhs.priority)||((this.priority!= null)&&this.priority.equals(rhs.priority))))&&((this.lastSenderFirstname == rhs.lastSenderFirstname)||((this.lastSenderFirstname!= null)&&this.lastSenderFirstname.equals(rhs.lastSenderFirstname))))&&((this.userAccesses == rhs.userAccesses)||((this.userAccesses!= null)&&this.userAccesses.equals(rhs.userAccesses))))&&((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name))))&&((this.messages == rhs.messages)||((this.messages!= null)&&this.messages.equals(rhs.messages))))&&((this.userFirstname == rhs.userFirstname)||((this.userFirstname!= null)&&this.userFirstname.equals(rhs.userFirstname))))&&((this.assignee == rhs.assignee)||((this.assignee!= null)&&this.assignee.equals(rhs.assignee))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.favorite == rhs.favorite)||((this.favorite!= null)&&this.favorite.equals(rhs.favorite))))&&((this.user == rhs.user)||((this.user!= null)&&this.user.equals(rhs.user))))&&((this.status == rhs.status)||((this.status!= null)&&this.status.equals(rhs.status))));
    }

    @Generated("jsonschema2pojo")
    public enum MessageConversationPriority {

        NONE("NONE"),
        LOW("LOW"),
        MEDIUM("MEDIUM"),
        HIGH("HIGH");
        private final String value;
        private final static Map<String, MessageConversation.MessageConversationPriority> CONSTANTS = new HashMap<String, MessageConversation.MessageConversationPriority>();

        static {
            for (MessageConversation.MessageConversationPriority c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        MessageConversationPriority(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static MessageConversation.MessageConversationPriority fromValue(String value) {
            MessageConversation.MessageConversationPriority constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum MessageConversationStatus {

        NONE("NONE"),
        OPEN("OPEN"),
        PENDING("PENDING"),
        INVALID("INVALID"),
        SOLVED("SOLVED");
        private final String value;
        private final static Map<String, MessageConversation.MessageConversationStatus> CONSTANTS = new HashMap<String, MessageConversation.MessageConversationStatus>();

        static {
            for (MessageConversation.MessageConversationStatus c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        MessageConversationStatus(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static MessageConversation.MessageConversationStatus fromValue(String value) {
            MessageConversation.MessageConversationStatus constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum MessageType {

        PRIVATE("PRIVATE"),
        SYSTEM("SYSTEM"),
        VALIDATION_RESULT("VALIDATION_RESULT"),
        TICKET("TICKET");
        private final String value;
        private final static Map<String, MessageConversation.MessageType> CONSTANTS = new HashMap<String, MessageConversation.MessageType>();

        static {
            for (MessageConversation.MessageType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        MessageType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static MessageConversation.MessageType fromValue(String value) {
            MessageConversation.MessageType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
