
package org.hisp.dhis.api.model.v2_35_13;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "access",
    "address",
    "aggregationType",
    "ancestors",
    "attributeValues",
    "children",
    "closedDate",
    "code",
    "comment",
    "contactPerson",
    "created",
    "dataSets",
    "description",
    "dimensionItem",
    "dimensionItemType",
    "displayDescription",
    "displayFormName",
    "displayName",
    "displayShortName",
    "email",
    "externalAccess",
    "favorite",
    "favorites",
    "formName",
    "geometry",
    "href",
    "id",
    "lastUpdated",
    "lastUpdatedBy",
    "leaf",
    "legendSet",
    "legendSets",
    "level",
    "memberCount",
    "name",
    "openingDate",
    "organisationUnitGroups",
    "parent",
    "path",
    "periodOffset",
    "phoneNumber",
    "programs",
    "publicAccess",
    "shortName",
    "translations",
    "type",
    "url",
    "user",
    "userAccesses",
    "userGroupAccesses",
    "users"
})
@Generated("jsonschema2pojo")
public class OrganisationUnit implements Serializable
{

    @JsonProperty("access")
    private Access access;
    @JsonProperty("address")
    private String address;
    @JsonProperty("aggregationType")
    private AggregationType aggregationType;
    @JsonProperty("ancestors")
    private List<OrganisationUnit> ancestors = null;
    @JsonProperty("attributeValues")
    private List<AttributeValue> attributeValues = null;
    @JsonProperty("children")
    private List<OrganisationUnit> children = null;
    @JsonProperty("closedDate")
    private Date closedDate;
    @JsonProperty("code")
    private String code;
    @JsonProperty("comment")
    private String comment;
    @JsonProperty("contactPerson")
    private String contactPerson;
    @JsonProperty("created")
    private Date created;
    @JsonProperty("dataSets")
    private List<DataSet> dataSets = null;
    @JsonProperty("description")
    private String description;
    @JsonProperty("dimensionItem")
    private String dimensionItem;
    @JsonProperty("dimensionItemType")
    private org.hisp.dhis.api.model.v2_35_13.CategoryOptionCombo.DimensionItemType dimensionItemType;
    @JsonProperty("displayDescription")
    private String displayDescription;
    @JsonProperty("displayFormName")
    private String displayFormName;
    @JsonProperty("displayName")
    private String displayName;
    @JsonProperty("displayShortName")
    private String displayShortName;
    @JsonProperty("email")
    private String email;
    @JsonProperty("externalAccess")
    private Boolean externalAccess;
    @JsonProperty("favorite")
    private Boolean favorite;
    @JsonProperty("favorites")
    private List<String> favorites = null;
    @JsonProperty("formName")
    private String formName;
    /**
     * Undefined
     * 
     */
    @JsonProperty("geometry")
    private Object geometry;
    @JsonProperty("href")
    private String href;
    @JsonProperty("id")
    private String id;
    @JsonProperty("lastUpdated")
    private Date lastUpdated;
    @JsonProperty("lastUpdatedBy")
    private User lastUpdatedBy;
    @JsonProperty("leaf")
    private Boolean leaf;
    @JsonProperty("legendSet")
    private LegendSet legendSet;
    @JsonProperty("legendSets")
    private List<LegendSet> legendSets = null;
    @JsonProperty("level")
    private Integer level;
    @JsonProperty("memberCount")
    private Integer memberCount;
    @JsonProperty("name")
    private String name;
    @JsonProperty("openingDate")
    private Date openingDate;
    @JsonProperty("organisationUnitGroups")
    private List<OrganisationUnitGroup> organisationUnitGroups = null;
    @JsonProperty("parent")
    private OrganisationUnit parent;
    @JsonProperty("path")
    private String path;
    @JsonProperty("periodOffset")
    private Integer periodOffset;
    @JsonProperty("phoneNumber")
    private String phoneNumber;
    @JsonProperty("programs")
    private List<Program> programs = null;
    @JsonProperty("publicAccess")
    private String publicAccess;
    @JsonProperty("shortName")
    private String shortName;
    @JsonProperty("translations")
    private List<Translation> translations = null;
    @JsonProperty("type")
    private String type;
    @JsonProperty("url")
    private String url;
    @JsonProperty("user")
    private User user;
    @JsonProperty("userAccesses")
    private List<UserAccess> userAccesses = null;
    @JsonProperty("userGroupAccesses")
    private List<UserGroupAccess> userGroupAccesses = null;
    @JsonProperty("users")
    private List<User> users = null;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -7954510866522253479L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public OrganisationUnit() {
    }

    /**
     * 
     * @param source
     */
    public OrganisationUnit(OrganisationUnit source) {
        super();
        this.access = source.access;
        this.address = source.address;
        this.aggregationType = source.aggregationType;
        this.ancestors = source.ancestors;
        this.attributeValues = source.attributeValues;
        this.children = source.children;
        this.closedDate = source.closedDate;
        this.code = source.code;
        this.comment = source.comment;
        this.contactPerson = source.contactPerson;
        this.created = source.created;
        this.dataSets = source.dataSets;
        this.description = source.description;
        this.dimensionItem = source.dimensionItem;
        this.dimensionItemType = source.dimensionItemType;
        this.displayDescription = source.displayDescription;
        this.displayFormName = source.displayFormName;
        this.displayName = source.displayName;
        this.displayShortName = source.displayShortName;
        this.email = source.email;
        this.externalAccess = source.externalAccess;
        this.favorite = source.favorite;
        this.favorites = source.favorites;
        this.formName = source.formName;
        this.geometry = source.geometry;
        this.href = source.href;
        this.id = source.id;
        this.lastUpdated = source.lastUpdated;
        this.lastUpdatedBy = source.lastUpdatedBy;
        this.leaf = source.leaf;
        this.legendSet = source.legendSet;
        this.legendSets = source.legendSets;
        this.level = source.level;
        this.memberCount = source.memberCount;
        this.name = source.name;
        this.openingDate = source.openingDate;
        this.organisationUnitGroups = source.organisationUnitGroups;
        this.parent = source.parent;
        this.path = source.path;
        this.periodOffset = source.periodOffset;
        this.phoneNumber = source.phoneNumber;
        this.programs = source.programs;
        this.publicAccess = source.publicAccess;
        this.shortName = source.shortName;
        this.translations = source.translations;
        this.type = source.type;
        this.url = source.url;
        this.user = source.user;
        this.userAccesses = source.userAccesses;
        this.userGroupAccesses = source.userGroupAccesses;
        this.users = source.users;
    }

    /**
     * 
     * @param parent
     * @param publicAccess
     * @param type
     * @param lastUpdated
     * @param path
     * @param children
     * @param translations
     * @param href
     * @param id
     * @param ancestors
     * @param organisationUnitGroups
     * @param displayDescription
     * @param lastUpdatedBy
     * @param userGroupAccesses
     * @param level
     * @param created
     * @param attributeValues
     * @param displayFormName
     * @param users
     * @param phoneNumber
     * @param userAccesses
     * @param name
     * @param dataSets
     * @param legendSets
     * @param programs
     * @param shortName
     * @param favorite
     * @param dimensionItemType
     * @param favorites
     * @param aggregationType
     * @param access
     * @param code
     * @param displayName
     * @param contactPerson
     * @param description
     * @param displayShortName
     * @param externalAccess
     * @param periodOffset
     * @param formName
     * @param openingDate
     * @param email
     * @param address
     * @param dimensionItem
     * @param memberCount
     * @param leaf
     * @param url
     * @param closedDate
     * @param legendSet
     * @param comment
     * @param geometry
     * @param user
     */
    public OrganisationUnit(Access access, String address, AggregationType aggregationType, List<OrganisationUnit> ancestors, List<AttributeValue> attributeValues, List<OrganisationUnit> children, Date closedDate, String code, String comment, String contactPerson, Date created, List<DataSet> dataSets, String description, String dimensionItem, org.hisp.dhis.api.model.v2_35_13.CategoryOptionCombo.DimensionItemType dimensionItemType, String displayDescription, String displayFormName, String displayName, String displayShortName, String email, Boolean externalAccess, Boolean favorite, List<String> favorites, String formName, Object geometry, String href, String id, Date lastUpdated, User lastUpdatedBy, Boolean leaf, LegendSet legendSet, List<LegendSet> legendSets, Integer level, Integer memberCount, String name, Date openingDate, List<OrganisationUnitGroup> organisationUnitGroups, OrganisationUnit parent, String path, Integer periodOffset, String phoneNumber, List<Program> programs, String publicAccess, String shortName, List<Translation> translations, String type, String url, User user, List<UserAccess> userAccesses, List<UserGroupAccess> userGroupAccesses, List<User> users) {
        super();
        this.access = access;
        this.address = address;
        this.aggregationType = aggregationType;
        this.ancestors = ancestors;
        this.attributeValues = attributeValues;
        this.children = children;
        this.closedDate = closedDate;
        this.code = code;
        this.comment = comment;
        this.contactPerson = contactPerson;
        this.created = created;
        this.dataSets = dataSets;
        this.description = description;
        this.dimensionItem = dimensionItem;
        this.dimensionItemType = dimensionItemType;
        this.displayDescription = displayDescription;
        this.displayFormName = displayFormName;
        this.displayName = displayName;
        this.displayShortName = displayShortName;
        this.email = email;
        this.externalAccess = externalAccess;
        this.favorite = favorite;
        this.favorites = favorites;
        this.formName = formName;
        this.geometry = geometry;
        this.href = href;
        this.id = id;
        this.lastUpdated = lastUpdated;
        this.lastUpdatedBy = lastUpdatedBy;
        this.leaf = leaf;
        this.legendSet = legendSet;
        this.legendSets = legendSets;
        this.level = level;
        this.memberCount = memberCount;
        this.name = name;
        this.openingDate = openingDate;
        this.organisationUnitGroups = organisationUnitGroups;
        this.parent = parent;
        this.path = path;
        this.periodOffset = periodOffset;
        this.phoneNumber = phoneNumber;
        this.programs = programs;
        this.publicAccess = publicAccess;
        this.shortName = shortName;
        this.translations = translations;
        this.type = type;
        this.url = url;
        this.user = user;
        this.userAccesses = userAccesses;
        this.userGroupAccesses = userGroupAccesses;
        this.users = users;
    }

    @JsonProperty("access")
    public Optional<Access> getAccess() {
        return Optional.ofNullable(access);
    }

    @JsonProperty("access")
    public void setAccess(Access access) {
        this.access = access;
    }

    public OrganisationUnit withAccess(Access access) {
        this.access = access;
        return this;
    }

    @JsonProperty("address")
    public Optional<String> getAddress() {
        return Optional.ofNullable(address);
    }

    @JsonProperty("address")
    public void setAddress(String address) {
        this.address = address;
    }

    public OrganisationUnit withAddress(String address) {
        this.address = address;
        return this;
    }

    @JsonProperty("aggregationType")
    public Optional<AggregationType> getAggregationType() {
        return Optional.ofNullable(aggregationType);
    }

    @JsonProperty("aggregationType")
    public void setAggregationType(AggregationType aggregationType) {
        this.aggregationType = aggregationType;
    }

    public OrganisationUnit withAggregationType(AggregationType aggregationType) {
        this.aggregationType = aggregationType;
        return this;
    }

    @JsonProperty("ancestors")
    public Optional<List<OrganisationUnit>> getAncestors() {
        return Optional.ofNullable(ancestors);
    }

    @JsonProperty("ancestors")
    public void setAncestors(List<OrganisationUnit> ancestors) {
        this.ancestors = ancestors;
    }

    public OrganisationUnit withAncestors(List<OrganisationUnit> ancestors) {
        this.ancestors = ancestors;
        return this;
    }

    @JsonProperty("attributeValues")
    public Optional<List<AttributeValue>> getAttributeValues() {
        return Optional.ofNullable(attributeValues);
    }

    @JsonProperty("attributeValues")
    public void setAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
    }

    public OrganisationUnit withAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
        return this;
    }

    @JsonProperty("children")
    public Optional<List<OrganisationUnit>> getChildren() {
        return Optional.ofNullable(children);
    }

    @JsonProperty("children")
    public void setChildren(List<OrganisationUnit> children) {
        this.children = children;
    }

    public OrganisationUnit withChildren(List<OrganisationUnit> children) {
        this.children = children;
        return this;
    }

    @JsonProperty("closedDate")
    public Optional<Date> getClosedDate() {
        return Optional.ofNullable(closedDate);
    }

    @JsonProperty("closedDate")
    public void setClosedDate(Date closedDate) {
        this.closedDate = closedDate;
    }

    public OrganisationUnit withClosedDate(Date closedDate) {
        this.closedDate = closedDate;
        return this;
    }

    @JsonProperty("code")
    public Optional<String> getCode() {
        return Optional.ofNullable(code);
    }

    @JsonProperty("code")
    public void setCode(String code) {
        this.code = code;
    }

    public OrganisationUnit withCode(String code) {
        this.code = code;
        return this;
    }

    @JsonProperty("comment")
    public Optional<String> getComment() {
        return Optional.ofNullable(comment);
    }

    @JsonProperty("comment")
    public void setComment(String comment) {
        this.comment = comment;
    }

    public OrganisationUnit withComment(String comment) {
        this.comment = comment;
        return this;
    }

    @JsonProperty("contactPerson")
    public Optional<String> getContactPerson() {
        return Optional.ofNullable(contactPerson);
    }

    @JsonProperty("contactPerson")
    public void setContactPerson(String contactPerson) {
        this.contactPerson = contactPerson;
    }

    public OrganisationUnit withContactPerson(String contactPerson) {
        this.contactPerson = contactPerson;
        return this;
    }

    @JsonProperty("created")
    public Optional<Date> getCreated() {
        return Optional.ofNullable(created);
    }

    @JsonProperty("created")
    public void setCreated(Date created) {
        this.created = created;
    }

    public OrganisationUnit withCreated(Date created) {
        this.created = created;
        return this;
    }

    @JsonProperty("dataSets")
    public Optional<List<DataSet>> getDataSets() {
        return Optional.ofNullable(dataSets);
    }

    @JsonProperty("dataSets")
    public void setDataSets(List<DataSet> dataSets) {
        this.dataSets = dataSets;
    }

    public OrganisationUnit withDataSets(List<DataSet> dataSets) {
        this.dataSets = dataSets;
        return this;
    }

    @JsonProperty("description")
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    @JsonProperty("description")
    public void setDescription(String description) {
        this.description = description;
    }

    public OrganisationUnit withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty("dimensionItem")
    public Optional<String> getDimensionItem() {
        return Optional.ofNullable(dimensionItem);
    }

    @JsonProperty("dimensionItem")
    public void setDimensionItem(String dimensionItem) {
        this.dimensionItem = dimensionItem;
    }

    public OrganisationUnit withDimensionItem(String dimensionItem) {
        this.dimensionItem = dimensionItem;
        return this;
    }

    @JsonProperty("dimensionItemType")
    public Optional<org.hisp.dhis.api.model.v2_35_13.CategoryOptionCombo.DimensionItemType> getDimensionItemType() {
        return Optional.ofNullable(dimensionItemType);
    }

    @JsonProperty("dimensionItemType")
    public void setDimensionItemType(org.hisp.dhis.api.model.v2_35_13.CategoryOptionCombo.DimensionItemType dimensionItemType) {
        this.dimensionItemType = dimensionItemType;
    }

    public OrganisationUnit withDimensionItemType(org.hisp.dhis.api.model.v2_35_13.CategoryOptionCombo.DimensionItemType dimensionItemType) {
        this.dimensionItemType = dimensionItemType;
        return this;
    }

    @JsonProperty("displayDescription")
    public Optional<String> getDisplayDescription() {
        return Optional.ofNullable(displayDescription);
    }

    @JsonProperty("displayDescription")
    public void setDisplayDescription(String displayDescription) {
        this.displayDescription = displayDescription;
    }

    public OrganisationUnit withDisplayDescription(String displayDescription) {
        this.displayDescription = displayDescription;
        return this;
    }

    @JsonProperty("displayFormName")
    public Optional<String> getDisplayFormName() {
        return Optional.ofNullable(displayFormName);
    }

    @JsonProperty("displayFormName")
    public void setDisplayFormName(String displayFormName) {
        this.displayFormName = displayFormName;
    }

    public OrganisationUnit withDisplayFormName(String displayFormName) {
        this.displayFormName = displayFormName;
        return this;
    }

    @JsonProperty("displayName")
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    @JsonProperty("displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public OrganisationUnit withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @JsonProperty("displayShortName")
    public Optional<String> getDisplayShortName() {
        return Optional.ofNullable(displayShortName);
    }

    @JsonProperty("displayShortName")
    public void setDisplayShortName(String displayShortName) {
        this.displayShortName = displayShortName;
    }

    public OrganisationUnit withDisplayShortName(String displayShortName) {
        this.displayShortName = displayShortName;
        return this;
    }

    @JsonProperty("email")
    public Optional<String> getEmail() {
        return Optional.ofNullable(email);
    }

    @JsonProperty("email")
    public void setEmail(String email) {
        this.email = email;
    }

    public OrganisationUnit withEmail(String email) {
        this.email = email;
        return this;
    }

    @JsonProperty("externalAccess")
    public Optional<Boolean> getExternalAccess() {
        return Optional.ofNullable(externalAccess);
    }

    @JsonProperty("externalAccess")
    public void setExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
    }

    public OrganisationUnit withExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
        return this;
    }

    @JsonProperty("favorite")
    public Optional<Boolean> getFavorite() {
        return Optional.ofNullable(favorite);
    }

    @JsonProperty("favorite")
    public void setFavorite(Boolean favorite) {
        this.favorite = favorite;
    }

    public OrganisationUnit withFavorite(Boolean favorite) {
        this.favorite = favorite;
        return this;
    }

    @JsonProperty("favorites")
    public Optional<List<String>> getFavorites() {
        return Optional.ofNullable(favorites);
    }

    @JsonProperty("favorites")
    public void setFavorites(List<String> favorites) {
        this.favorites = favorites;
    }

    public OrganisationUnit withFavorites(List<String> favorites) {
        this.favorites = favorites;
        return this;
    }

    @JsonProperty("formName")
    public Optional<String> getFormName() {
        return Optional.ofNullable(formName);
    }

    @JsonProperty("formName")
    public void setFormName(String formName) {
        this.formName = formName;
    }

    public OrganisationUnit withFormName(String formName) {
        this.formName = formName;
        return this;
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("geometry")
    public Optional<Object> getGeometry() {
        return Optional.ofNullable(geometry);
    }

    /**
     * Undefined
     * 
     */
    @JsonProperty("geometry")
    public void setGeometry(Object geometry) {
        this.geometry = geometry;
    }

    public OrganisationUnit withGeometry(Object geometry) {
        this.geometry = geometry;
        return this;
    }

    @JsonProperty("href")
    public Optional<String> getHref() {
        return Optional.ofNullable(href);
    }

    @JsonProperty("href")
    public void setHref(String href) {
        this.href = href;
    }

    public OrganisationUnit withHref(String href) {
        this.href = href;
        return this;
    }

    @JsonProperty("id")
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    @JsonProperty("id")
    public void setId(String id) {
        this.id = id;
    }

    public OrganisationUnit withId(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty("lastUpdated")
    public Optional<Date> getLastUpdated() {
        return Optional.ofNullable(lastUpdated);
    }

    @JsonProperty("lastUpdated")
    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public OrganisationUnit withLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
        return this;
    }

    @JsonProperty("lastUpdatedBy")
    public Optional<User> getLastUpdatedBy() {
        return Optional.ofNullable(lastUpdatedBy);
    }

    @JsonProperty("lastUpdatedBy")
    public void setLastUpdatedBy(User lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
    }

    public OrganisationUnit withLastUpdatedBy(User lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
        return this;
    }

    @JsonProperty("leaf")
    public Optional<Boolean> getLeaf() {
        return Optional.ofNullable(leaf);
    }

    @JsonProperty("leaf")
    public void setLeaf(Boolean leaf) {
        this.leaf = leaf;
    }

    public OrganisationUnit withLeaf(Boolean leaf) {
        this.leaf = leaf;
        return this;
    }

    @JsonProperty("legendSet")
    public Optional<LegendSet> getLegendSet() {
        return Optional.ofNullable(legendSet);
    }

    @JsonProperty("legendSet")
    public void setLegendSet(LegendSet legendSet) {
        this.legendSet = legendSet;
    }

    public OrganisationUnit withLegendSet(LegendSet legendSet) {
        this.legendSet = legendSet;
        return this;
    }

    @JsonProperty("legendSets")
    public Optional<List<LegendSet>> getLegendSets() {
        return Optional.ofNullable(legendSets);
    }

    @JsonProperty("legendSets")
    public void setLegendSets(List<LegendSet> legendSets) {
        this.legendSets = legendSets;
    }

    public OrganisationUnit withLegendSets(List<LegendSet> legendSets) {
        this.legendSets = legendSets;
        return this;
    }

    @JsonProperty("level")
    public Optional<Integer> getLevel() {
        return Optional.ofNullable(level);
    }

    @JsonProperty("level")
    public void setLevel(Integer level) {
        this.level = level;
    }

    public OrganisationUnit withLevel(Integer level) {
        this.level = level;
        return this;
    }

    @JsonProperty("memberCount")
    public Optional<Integer> getMemberCount() {
        return Optional.ofNullable(memberCount);
    }

    @JsonProperty("memberCount")
    public void setMemberCount(Integer memberCount) {
        this.memberCount = memberCount;
    }

    public OrganisationUnit withMemberCount(Integer memberCount) {
        this.memberCount = memberCount;
        return this;
    }

    @JsonProperty("name")
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public OrganisationUnit withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty("openingDate")
    public Optional<Date> getOpeningDate() {
        return Optional.ofNullable(openingDate);
    }

    @JsonProperty("openingDate")
    public void setOpeningDate(Date openingDate) {
        this.openingDate = openingDate;
    }

    public OrganisationUnit withOpeningDate(Date openingDate) {
        this.openingDate = openingDate;
        return this;
    }

    @JsonProperty("organisationUnitGroups")
    public Optional<List<OrganisationUnitGroup>> getOrganisationUnitGroups() {
        return Optional.ofNullable(organisationUnitGroups);
    }

    @JsonProperty("organisationUnitGroups")
    public void setOrganisationUnitGroups(List<OrganisationUnitGroup> organisationUnitGroups) {
        this.organisationUnitGroups = organisationUnitGroups;
    }

    public OrganisationUnit withOrganisationUnitGroups(List<OrganisationUnitGroup> organisationUnitGroups) {
        this.organisationUnitGroups = organisationUnitGroups;
        return this;
    }

    @JsonProperty("parent")
    public Optional<OrganisationUnit> getParent() {
        return Optional.ofNullable(parent);
    }

    @JsonProperty("parent")
    public void setParent(OrganisationUnit parent) {
        this.parent = parent;
    }

    public OrganisationUnit withParent(OrganisationUnit parent) {
        this.parent = parent;
        return this;
    }

    @JsonProperty("path")
    public Optional<String> getPath() {
        return Optional.ofNullable(path);
    }

    @JsonProperty("path")
    public void setPath(String path) {
        this.path = path;
    }

    public OrganisationUnit withPath(String path) {
        this.path = path;
        return this;
    }

    @JsonProperty("periodOffset")
    public Optional<Integer> getPeriodOffset() {
        return Optional.ofNullable(periodOffset);
    }

    @JsonProperty("periodOffset")
    public void setPeriodOffset(Integer periodOffset) {
        this.periodOffset = periodOffset;
    }

    public OrganisationUnit withPeriodOffset(Integer periodOffset) {
        this.periodOffset = periodOffset;
        return this;
    }

    @JsonProperty("phoneNumber")
    public Optional<String> getPhoneNumber() {
        return Optional.ofNullable(phoneNumber);
    }

    @JsonProperty("phoneNumber")
    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public OrganisationUnit withPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    @JsonProperty("programs")
    public Optional<List<Program>> getPrograms() {
        return Optional.ofNullable(programs);
    }

    @JsonProperty("programs")
    public void setPrograms(List<Program> programs) {
        this.programs = programs;
    }

    public OrganisationUnit withPrograms(List<Program> programs) {
        this.programs = programs;
        return this;
    }

    @JsonProperty("publicAccess")
    public Optional<String> getPublicAccess() {
        return Optional.ofNullable(publicAccess);
    }

    @JsonProperty("publicAccess")
    public void setPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
    }

    public OrganisationUnit withPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
        return this;
    }

    @JsonProperty("shortName")
    public Optional<String> getShortName() {
        return Optional.ofNullable(shortName);
    }

    @JsonProperty("shortName")
    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public OrganisationUnit withShortName(String shortName) {
        this.shortName = shortName;
        return this;
    }

    @JsonProperty("translations")
    public Optional<List<Translation>> getTranslations() {
        return Optional.ofNullable(translations);
    }

    @JsonProperty("translations")
    public void setTranslations(List<Translation> translations) {
        this.translations = translations;
    }

    public OrganisationUnit withTranslations(List<Translation> translations) {
        this.translations = translations;
        return this;
    }

    @JsonProperty("type")
    public Optional<String> getType() {
        return Optional.ofNullable(type);
    }

    @JsonProperty("type")
    public void setType(String type) {
        this.type = type;
    }

    public OrganisationUnit withType(String type) {
        this.type = type;
        return this;
    }

    @JsonProperty("url")
    public Optional<String> getUrl() {
        return Optional.ofNullable(url);
    }

    @JsonProperty("url")
    public void setUrl(String url) {
        this.url = url;
    }

    public OrganisationUnit withUrl(String url) {
        this.url = url;
        return this;
    }

    @JsonProperty("user")
    public Optional<User> getUser() {
        return Optional.ofNullable(user);
    }

    @JsonProperty("user")
    public void setUser(User user) {
        this.user = user;
    }

    public OrganisationUnit withUser(User user) {
        this.user = user;
        return this;
    }

    @JsonProperty("userAccesses")
    public Optional<List<UserAccess>> getUserAccesses() {
        return Optional.ofNullable(userAccesses);
    }

    @JsonProperty("userAccesses")
    public void setUserAccesses(List<UserAccess> userAccesses) {
        this.userAccesses = userAccesses;
    }

    public OrganisationUnit withUserAccesses(List<UserAccess> userAccesses) {
        this.userAccesses = userAccesses;
        return this;
    }

    @JsonProperty("userGroupAccesses")
    public Optional<List<UserGroupAccess>> getUserGroupAccesses() {
        return Optional.ofNullable(userGroupAccesses);
    }

    @JsonProperty("userGroupAccesses")
    public void setUserGroupAccesses(List<UserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
    }

    public OrganisationUnit withUserGroupAccesses(List<UserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
        return this;
    }

    @JsonProperty("users")
    public Optional<List<User>> getUsers() {
        return Optional.ofNullable(users);
    }

    @JsonProperty("users")
    public void setUsers(List<User> users) {
        this.users = users;
    }

    public OrganisationUnit withUsers(List<User> users) {
        this.users = users;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public OrganisationUnit withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "access":
                if (value instanceof Access) {
                    setAccess(((Access) value));
                } else {
                    throw new IllegalArgumentException(("property \"access\" is of type \"org.hisp.dhis.api.model.v2_35_13.Access\", but got "+ value.getClass().toString()));
                }
                return true;
            case "address":
                if (value instanceof String) {
                    setAddress(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"address\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "aggregationType":
                if (value instanceof AggregationType) {
                    setAggregationType(((AggregationType) value));
                } else {
                    throw new IllegalArgumentException(("property \"aggregationType\" is of type \"org.hisp.dhis.api.model.v2_35_13.AggregationType\", but got "+ value.getClass().toString()));
                }
                return true;
            case "ancestors":
                if (value instanceof List) {
                    setAncestors(((List<OrganisationUnit> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"ancestors\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.OrganisationUnit>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "attributeValues":
                if (value instanceof List) {
                    setAttributeValues(((List<AttributeValue> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"attributeValues\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.AttributeValue>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "children":
                if (value instanceof List) {
                    setChildren(((List<OrganisationUnit> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"children\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.OrganisationUnit>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "closedDate":
                if (value instanceof Date) {
                    setClosedDate(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"closedDate\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "code":
                if (value instanceof String) {
                    setCode(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"code\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "comment":
                if (value instanceof String) {
                    setComment(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"comment\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "contactPerson":
                if (value instanceof String) {
                    setContactPerson(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"contactPerson\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "created":
                if (value instanceof Date) {
                    setCreated(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"created\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dataSets":
                if (value instanceof List) {
                    setDataSets(((List<DataSet> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"dataSets\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.DataSet>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "description":
                if (value instanceof String) {
                    setDescription(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"description\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dimensionItem":
                if (value instanceof String) {
                    setDimensionItem(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"dimensionItem\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "dimensionItemType":
                if (value instanceof org.hisp.dhis.api.model.v2_35_13.CategoryOptionCombo.DimensionItemType) {
                    setDimensionItemType(((org.hisp.dhis.api.model.v2_35_13.CategoryOptionCombo.DimensionItemType) value));
                } else {
                    throw new IllegalArgumentException(("property \"dimensionItemType\" is of type \"org.hisp.dhis.api.model.v2_35_13.CategoryOptionCombo.DimensionItemType\", but got "+ value.getClass().toString()));
                }
                return true;
            case "displayDescription":
                if (value instanceof String) {
                    setDisplayDescription(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayDescription\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "displayFormName":
                if (value instanceof String) {
                    setDisplayFormName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayFormName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "displayName":
                if (value instanceof String) {
                    setDisplayName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "displayShortName":
                if (value instanceof String) {
                    setDisplayShortName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayShortName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "email":
                if (value instanceof String) {
                    setEmail(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"email\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "externalAccess":
                if (value instanceof Boolean) {
                    setExternalAccess(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"externalAccess\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "favorite":
                if (value instanceof Boolean) {
                    setFavorite(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"favorite\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "favorites":
                if (value instanceof List) {
                    setFavorites(((List<String> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"favorites\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "formName":
                if (value instanceof String) {
                    setFormName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"formName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "geometry":
                if (value instanceof Object) {
                    setGeometry(((Object) value));
                } else {
                    throw new IllegalArgumentException(("property \"geometry\" is of type \"java.lang.Object\", but got "+ value.getClass().toString()));
                }
                return true;
            case "href":
                if (value instanceof String) {
                    setHref(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"href\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "id":
                if (value instanceof String) {
                    setId(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"id\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "lastUpdated":
                if (value instanceof Date) {
                    setLastUpdated(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"lastUpdated\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "lastUpdatedBy":
                if (value instanceof User) {
                    setLastUpdatedBy(((User) value));
                } else {
                    throw new IllegalArgumentException(("property \"lastUpdatedBy\" is of type \"org.hisp.dhis.api.model.v2_35_13.User\", but got "+ value.getClass().toString()));
                }
                return true;
            case "leaf":
                if (value instanceof Boolean) {
                    setLeaf(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"leaf\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            case "legendSet":
                if (value instanceof LegendSet) {
                    setLegendSet(((LegendSet) value));
                } else {
                    throw new IllegalArgumentException(("property \"legendSet\" is of type \"org.hisp.dhis.api.model.v2_35_13.LegendSet\", but got "+ value.getClass().toString()));
                }
                return true;
            case "legendSets":
                if (value instanceof List) {
                    setLegendSets(((List<LegendSet> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"legendSets\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.LegendSet>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "level":
                if (value instanceof Integer) {
                    setLevel(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"level\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "memberCount":
                if (value instanceof Integer) {
                    setMemberCount(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"memberCount\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "name":
                if (value instanceof String) {
                    setName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"name\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "openingDate":
                if (value instanceof Date) {
                    setOpeningDate(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"openingDate\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            case "organisationUnitGroups":
                if (value instanceof List) {
                    setOrganisationUnitGroups(((List<OrganisationUnitGroup> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"organisationUnitGroups\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.OrganisationUnitGroup>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "parent":
                if (value instanceof OrganisationUnit) {
                    setParent(((OrganisationUnit) value));
                } else {
                    throw new IllegalArgumentException(("property \"parent\" is of type \"org.hisp.dhis.api.model.v2_35_13.OrganisationUnit\", but got "+ value.getClass().toString()));
                }
                return true;
            case "path":
                if (value instanceof String) {
                    setPath(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"path\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "periodOffset":
                if (value instanceof Integer) {
                    setPeriodOffset(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"periodOffset\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            case "phoneNumber":
                if (value instanceof String) {
                    setPhoneNumber(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"phoneNumber\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "programs":
                if (value instanceof List) {
                    setPrograms(((List<Program> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"programs\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.Program>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "publicAccess":
                if (value instanceof String) {
                    setPublicAccess(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"publicAccess\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "shortName":
                if (value instanceof String) {
                    setShortName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"shortName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "translations":
                if (value instanceof List) {
                    setTranslations(((List<Translation> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"translations\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.Translation>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "type":
                if (value instanceof String) {
                    setType(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"type\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "url":
                if (value instanceof String) {
                    setUrl(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"url\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "user":
                if (value instanceof User) {
                    setUser(((User) value));
                } else {
                    throw new IllegalArgumentException(("property \"user\" is of type \"org.hisp.dhis.api.model.v2_35_13.User\", but got "+ value.getClass().toString()));
                }
                return true;
            case "userAccesses":
                if (value instanceof List) {
                    setUserAccesses(((List<UserAccess> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"userAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.UserAccess>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "userGroupAccesses":
                if (value instanceof List) {
                    setUserGroupAccesses(((List<UserGroupAccess> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"userGroupAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.UserGroupAccess>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "users":
                if (value instanceof List) {
                    setUsers(((List<User> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"users\" is of type \"java.util.List<org.hisp.dhis.api.model.v2_35_13.User>\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "access":
                return getAccess();
            case "address":
                return getAddress();
            case "aggregationType":
                return getAggregationType();
            case "ancestors":
                return getAncestors();
            case "attributeValues":
                return getAttributeValues();
            case "children":
                return getChildren();
            case "closedDate":
                return getClosedDate();
            case "code":
                return getCode();
            case "comment":
                return getComment();
            case "contactPerson":
                return getContactPerson();
            case "created":
                return getCreated();
            case "dataSets":
                return getDataSets();
            case "description":
                return getDescription();
            case "dimensionItem":
                return getDimensionItem();
            case "dimensionItemType":
                return getDimensionItemType();
            case "displayDescription":
                return getDisplayDescription();
            case "displayFormName":
                return getDisplayFormName();
            case "displayName":
                return getDisplayName();
            case "displayShortName":
                return getDisplayShortName();
            case "email":
                return getEmail();
            case "externalAccess":
                return getExternalAccess();
            case "favorite":
                return getFavorite();
            case "favorites":
                return getFavorites();
            case "formName":
                return getFormName();
            case "geometry":
                return getGeometry();
            case "href":
                return getHref();
            case "id":
                return getId();
            case "lastUpdated":
                return getLastUpdated();
            case "lastUpdatedBy":
                return getLastUpdatedBy();
            case "leaf":
                return getLeaf();
            case "legendSet":
                return getLegendSet();
            case "legendSets":
                return getLegendSets();
            case "level":
                return getLevel();
            case "memberCount":
                return getMemberCount();
            case "name":
                return getName();
            case "openingDate":
                return getOpeningDate();
            case "organisationUnitGroups":
                return getOrganisationUnitGroups();
            case "parent":
                return getParent();
            case "path":
                return getPath();
            case "periodOffset":
                return getPeriodOffset();
            case "phoneNumber":
                return getPhoneNumber();
            case "programs":
                return getPrograms();
            case "publicAccess":
                return getPublicAccess();
            case "shortName":
                return getShortName();
            case "translations":
                return getTranslations();
            case "type":
                return getType();
            case "url":
                return getUrl();
            case "user":
                return getUser();
            case "userAccesses":
                return getUserAccesses();
            case "userGroupAccesses":
                return getUserGroupAccesses();
            case "users":
                return getUsers();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, OrganisationUnit.NOT_FOUND_VALUE);
        if (OrganisationUnit.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public OrganisationUnit with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OrganisationUnit.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("access");
        sb.append('=');
        sb.append(((this.access == null)?"<null>":this.access));
        sb.append(',');
        sb.append("address");
        sb.append('=');
        sb.append(((this.address == null)?"<null>":this.address));
        sb.append(',');
        sb.append("aggregationType");
        sb.append('=');
        sb.append(((this.aggregationType == null)?"<null>":this.aggregationType));
        sb.append(',');
        sb.append("ancestors");
        sb.append('=');
        sb.append(((this.ancestors == null)?"<null>":this.ancestors));
        sb.append(',');
        sb.append("attributeValues");
        sb.append('=');
        sb.append(((this.attributeValues == null)?"<null>":this.attributeValues));
        sb.append(',');
        sb.append("children");
        sb.append('=');
        sb.append(((this.children == null)?"<null>":this.children));
        sb.append(',');
        sb.append("closedDate");
        sb.append('=');
        sb.append(((this.closedDate == null)?"<null>":this.closedDate));
        sb.append(',');
        sb.append("code");
        sb.append('=');
        sb.append(((this.code == null)?"<null>":this.code));
        sb.append(',');
        sb.append("comment");
        sb.append('=');
        sb.append(((this.comment == null)?"<null>":this.comment));
        sb.append(',');
        sb.append("contactPerson");
        sb.append('=');
        sb.append(((this.contactPerson == null)?"<null>":this.contactPerson));
        sb.append(',');
        sb.append("created");
        sb.append('=');
        sb.append(((this.created == null)?"<null>":this.created));
        sb.append(',');
        sb.append("dataSets");
        sb.append('=');
        sb.append(((this.dataSets == null)?"<null>":this.dataSets));
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(((this.description == null)?"<null>":this.description));
        sb.append(',');
        sb.append("dimensionItem");
        sb.append('=');
        sb.append(((this.dimensionItem == null)?"<null>":this.dimensionItem));
        sb.append(',');
        sb.append("dimensionItemType");
        sb.append('=');
        sb.append(((this.dimensionItemType == null)?"<null>":this.dimensionItemType));
        sb.append(',');
        sb.append("displayDescription");
        sb.append('=');
        sb.append(((this.displayDescription == null)?"<null>":this.displayDescription));
        sb.append(',');
        sb.append("displayFormName");
        sb.append('=');
        sb.append(((this.displayFormName == null)?"<null>":this.displayFormName));
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(((this.displayName == null)?"<null>":this.displayName));
        sb.append(',');
        sb.append("displayShortName");
        sb.append('=');
        sb.append(((this.displayShortName == null)?"<null>":this.displayShortName));
        sb.append(',');
        sb.append("email");
        sb.append('=');
        sb.append(((this.email == null)?"<null>":this.email));
        sb.append(',');
        sb.append("externalAccess");
        sb.append('=');
        sb.append(((this.externalAccess == null)?"<null>":this.externalAccess));
        sb.append(',');
        sb.append("favorite");
        sb.append('=');
        sb.append(((this.favorite == null)?"<null>":this.favorite));
        sb.append(',');
        sb.append("favorites");
        sb.append('=');
        sb.append(((this.favorites == null)?"<null>":this.favorites));
        sb.append(',');
        sb.append("formName");
        sb.append('=');
        sb.append(((this.formName == null)?"<null>":this.formName));
        sb.append(',');
        sb.append("geometry");
        sb.append('=');
        sb.append(((this.geometry == null)?"<null>":this.geometry));
        sb.append(',');
        sb.append("href");
        sb.append('=');
        sb.append(((this.href == null)?"<null>":this.href));
        sb.append(',');
        sb.append("id");
        sb.append('=');
        sb.append(((this.id == null)?"<null>":this.id));
        sb.append(',');
        sb.append("lastUpdated");
        sb.append('=');
        sb.append(((this.lastUpdated == null)?"<null>":this.lastUpdated));
        sb.append(',');
        sb.append("lastUpdatedBy");
        sb.append('=');
        sb.append(((this.lastUpdatedBy == null)?"<null>":this.lastUpdatedBy));
        sb.append(',');
        sb.append("leaf");
        sb.append('=');
        sb.append(((this.leaf == null)?"<null>":this.leaf));
        sb.append(',');
        sb.append("legendSet");
        sb.append('=');
        sb.append(((this.legendSet == null)?"<null>":this.legendSet));
        sb.append(',');
        sb.append("legendSets");
        sb.append('=');
        sb.append(((this.legendSets == null)?"<null>":this.legendSets));
        sb.append(',');
        sb.append("level");
        sb.append('=');
        sb.append(((this.level == null)?"<null>":this.level));
        sb.append(',');
        sb.append("memberCount");
        sb.append('=');
        sb.append(((this.memberCount == null)?"<null>":this.memberCount));
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("openingDate");
        sb.append('=');
        sb.append(((this.openingDate == null)?"<null>":this.openingDate));
        sb.append(',');
        sb.append("organisationUnitGroups");
        sb.append('=');
        sb.append(((this.organisationUnitGroups == null)?"<null>":this.organisationUnitGroups));
        sb.append(',');
        sb.append("parent");
        sb.append('=');
        sb.append(((this.parent == null)?"<null>":this.parent));
        sb.append(',');
        sb.append("path");
        sb.append('=');
        sb.append(((this.path == null)?"<null>":this.path));
        sb.append(',');
        sb.append("periodOffset");
        sb.append('=');
        sb.append(((this.periodOffset == null)?"<null>":this.periodOffset));
        sb.append(',');
        sb.append("phoneNumber");
        sb.append('=');
        sb.append(((this.phoneNumber == null)?"<null>":this.phoneNumber));
        sb.append(',');
        sb.append("programs");
        sb.append('=');
        sb.append(((this.programs == null)?"<null>":this.programs));
        sb.append(',');
        sb.append("publicAccess");
        sb.append('=');
        sb.append(((this.publicAccess == null)?"<null>":this.publicAccess));
        sb.append(',');
        sb.append("shortName");
        sb.append('=');
        sb.append(((this.shortName == null)?"<null>":this.shortName));
        sb.append(',');
        sb.append("translations");
        sb.append('=');
        sb.append(((this.translations == null)?"<null>":this.translations));
        sb.append(',');
        sb.append("type");
        sb.append('=');
        sb.append(((this.type == null)?"<null>":this.type));
        sb.append(',');
        sb.append("url");
        sb.append('=');
        sb.append(((this.url == null)?"<null>":this.url));
        sb.append(',');
        sb.append("user");
        sb.append('=');
        sb.append(((this.user == null)?"<null>":this.user));
        sb.append(',');
        sb.append("userAccesses");
        sb.append('=');
        sb.append(((this.userAccesses == null)?"<null>":this.userAccesses));
        sb.append(',');
        sb.append("userGroupAccesses");
        sb.append('=');
        sb.append(((this.userGroupAccesses == null)?"<null>":this.userGroupAccesses));
        sb.append(',');
        sb.append("users");
        sb.append('=');
        sb.append(((this.users == null)?"<null>":this.users));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.parent == null)? 0 :this.parent.hashCode()));
        result = ((result* 31)+((this.publicAccess == null)? 0 :this.publicAccess.hashCode()));
        result = ((result* 31)+((this.type == null)? 0 :this.type.hashCode()));
        result = ((result* 31)+((this.lastUpdated == null)? 0 :this.lastUpdated.hashCode()));
        result = ((result* 31)+((this.path == null)? 0 :this.path.hashCode()));
        result = ((result* 31)+((this.children == null)? 0 :this.children.hashCode()));
        result = ((result* 31)+((this.translations == null)? 0 :this.translations.hashCode()));
        result = ((result* 31)+((this.href == null)? 0 :this.href.hashCode()));
        result = ((result* 31)+((this.id == null)? 0 :this.id.hashCode()));
        result = ((result* 31)+((this.ancestors == null)? 0 :this.ancestors.hashCode()));
        result = ((result* 31)+((this.organisationUnitGroups == null)? 0 :this.organisationUnitGroups.hashCode()));
        result = ((result* 31)+((this.displayDescription == null)? 0 :this.displayDescription.hashCode()));
        result = ((result* 31)+((this.lastUpdatedBy == null)? 0 :this.lastUpdatedBy.hashCode()));
        result = ((result* 31)+((this.userGroupAccesses == null)? 0 :this.userGroupAccesses.hashCode()));
        result = ((result* 31)+((this.level == null)? 0 :this.level.hashCode()));
        result = ((result* 31)+((this.created == null)? 0 :this.created.hashCode()));
        result = ((result* 31)+((this.attributeValues == null)? 0 :this.attributeValues.hashCode()));
        result = ((result* 31)+((this.displayFormName == null)? 0 :this.displayFormName.hashCode()));
        result = ((result* 31)+((this.users == null)? 0 :this.users.hashCode()));
        result = ((result* 31)+((this.phoneNumber == null)? 0 :this.phoneNumber.hashCode()));
        result = ((result* 31)+((this.userAccesses == null)? 0 :this.userAccesses.hashCode()));
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.dataSets == null)? 0 :this.dataSets.hashCode()));
        result = ((result* 31)+((this.legendSets == null)? 0 :this.legendSets.hashCode()));
        result = ((result* 31)+((this.programs == null)? 0 :this.programs.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.shortName == null)? 0 :this.shortName.hashCode()));
        result = ((result* 31)+((this.favorite == null)? 0 :this.favorite.hashCode()));
        result = ((result* 31)+((this.dimensionItemType == null)? 0 :this.dimensionItemType.hashCode()));
        result = ((result* 31)+((this.favorites == null)? 0 :this.favorites.hashCode()));
        result = ((result* 31)+((this.aggregationType == null)? 0 :this.aggregationType.hashCode()));
        result = ((result* 31)+((this.access == null)? 0 :this.access.hashCode()));
        result = ((result* 31)+((this.code == null)? 0 :this.code.hashCode()));
        result = ((result* 31)+((this.displayName == null)? 0 :this.displayName.hashCode()));
        result = ((result* 31)+((this.contactPerson == null)? 0 :this.contactPerson.hashCode()));
        result = ((result* 31)+((this.description == null)? 0 :this.description.hashCode()));
        result = ((result* 31)+((this.displayShortName == null)? 0 :this.displayShortName.hashCode()));
        result = ((result* 31)+((this.externalAccess == null)? 0 :this.externalAccess.hashCode()));
        result = ((result* 31)+((this.periodOffset == null)? 0 :this.periodOffset.hashCode()));
        result = ((result* 31)+((this.formName == null)? 0 :this.formName.hashCode()));
        result = ((result* 31)+((this.openingDate == null)? 0 :this.openingDate.hashCode()));
        result = ((result* 31)+((this.email == null)? 0 :this.email.hashCode()));
        result = ((result* 31)+((this.address == null)? 0 :this.address.hashCode()));
        result = ((result* 31)+((this.dimensionItem == null)? 0 :this.dimensionItem.hashCode()));
        result = ((result* 31)+((this.memberCount == null)? 0 :this.memberCount.hashCode()));
        result = ((result* 31)+((this.leaf == null)? 0 :this.leaf.hashCode()));
        result = ((result* 31)+((this.url == null)? 0 :this.url.hashCode()));
        result = ((result* 31)+((this.closedDate == null)? 0 :this.closedDate.hashCode()));
        result = ((result* 31)+((this.legendSet == null)? 0 :this.legendSet.hashCode()));
        result = ((result* 31)+((this.comment == null)? 0 :this.comment.hashCode()));
        result = ((result* 31)+((this.geometry == null)? 0 :this.geometry.hashCode()));
        result = ((result* 31)+((this.user == null)? 0 :this.user.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof OrganisationUnit) == false) {
            return false;
        }
        OrganisationUnit rhs = ((OrganisationUnit) other);
        return (((((((((((((((((((((((((((((((((((((((((((((((((((((this.parent == rhs.parent)||((this.parent!= null)&&this.parent.equals(rhs.parent)))&&((this.publicAccess == rhs.publicAccess)||((this.publicAccess!= null)&&this.publicAccess.equals(rhs.publicAccess))))&&((this.type == rhs.type)||((this.type!= null)&&this.type.equals(rhs.type))))&&((this.lastUpdated == rhs.lastUpdated)||((this.lastUpdated!= null)&&this.lastUpdated.equals(rhs.lastUpdated))))&&((this.path == rhs.path)||((this.path!= null)&&this.path.equals(rhs.path))))&&((this.children == rhs.children)||((this.children!= null)&&this.children.equals(rhs.children))))&&((this.translations == rhs.translations)||((this.translations!= null)&&this.translations.equals(rhs.translations))))&&((this.href == rhs.href)||((this.href!= null)&&this.href.equals(rhs.href))))&&((this.id == rhs.id)||((this.id!= null)&&this.id.equals(rhs.id))))&&((this.ancestors == rhs.ancestors)||((this.ancestors!= null)&&this.ancestors.equals(rhs.ancestors))))&&((this.organisationUnitGroups == rhs.organisationUnitGroups)||((this.organisationUnitGroups!= null)&&this.organisationUnitGroups.equals(rhs.organisationUnitGroups))))&&((this.displayDescription == rhs.displayDescription)||((this.displayDescription!= null)&&this.displayDescription.equals(rhs.displayDescription))))&&((this.lastUpdatedBy == rhs.lastUpdatedBy)||((this.lastUpdatedBy!= null)&&this.lastUpdatedBy.equals(rhs.lastUpdatedBy))))&&((this.userGroupAccesses == rhs.userGroupAccesses)||((this.userGroupAccesses!= null)&&this.userGroupAccesses.equals(rhs.userGroupAccesses))))&&((this.level == rhs.level)||((this.level!= null)&&this.level.equals(rhs.level))))&&((this.created == rhs.created)||((this.created!= null)&&this.created.equals(rhs.created))))&&((this.attributeValues == rhs.attributeValues)||((this.attributeValues!= null)&&this.attributeValues.equals(rhs.attributeValues))))&&((this.displayFormName == rhs.displayFormName)||((this.displayFormName!= null)&&this.displayFormName.equals(rhs.displayFormName))))&&((this.users == rhs.users)||((this.users!= null)&&this.users.equals(rhs.users))))&&((this.phoneNumber == rhs.phoneNumber)||((this.phoneNumber!= null)&&this.phoneNumber.equals(rhs.phoneNumber))))&&((this.userAccesses == rhs.userAccesses)||((this.userAccesses!= null)&&this.userAccesses.equals(rhs.userAccesses))))&&((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name))))&&((this.dataSets == rhs.dataSets)||((this.dataSets!= null)&&this.dataSets.equals(rhs.dataSets))))&&((this.legendSets == rhs.legendSets)||((this.legendSets!= null)&&this.legendSets.equals(rhs.legendSets))))&&((this.programs == rhs.programs)||((this.programs!= null)&&this.programs.equals(rhs.programs))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.shortName == rhs.shortName)||((this.shortName!= null)&&this.shortName.equals(rhs.shortName))))&&((this.favorite == rhs.favorite)||((this.favorite!= null)&&this.favorite.equals(rhs.favorite))))&&((this.dimensionItemType == rhs.dimensionItemType)||((this.dimensionItemType!= null)&&this.dimensionItemType.equals(rhs.dimensionItemType))))&&((this.favorites == rhs.favorites)||((this.favorites!= null)&&this.favorites.equals(rhs.favorites))))&&((this.aggregationType == rhs.aggregationType)||((this.aggregationType!= null)&&this.aggregationType.equals(rhs.aggregationType))))&&((this.access == rhs.access)||((this.access!= null)&&this.access.equals(rhs.access))))&&((this.code == rhs.code)||((this.code!= null)&&this.code.equals(rhs.code))))&&((this.displayName == rhs.displayName)||((this.displayName!= null)&&this.displayName.equals(rhs.displayName))))&&((this.contactPerson == rhs.contactPerson)||((this.contactPerson!= null)&&this.contactPerson.equals(rhs.contactPerson))))&&((this.description == rhs.description)||((this.description!= null)&&this.description.equals(rhs.description))))&&((this.displayShortName == rhs.displayShortName)||((this.displayShortName!= null)&&this.displayShortName.equals(rhs.displayShortName))))&&((this.externalAccess == rhs.externalAccess)||((this.externalAccess!= null)&&this.externalAccess.equals(rhs.externalAccess))))&&((this.periodOffset == rhs.periodOffset)||((this.periodOffset!= null)&&this.periodOffset.equals(rhs.periodOffset))))&&((this.formName == rhs.formName)||((this.formName!= null)&&this.formName.equals(rhs.formName))))&&((this.openingDate == rhs.openingDate)||((this.openingDate!= null)&&this.openingDate.equals(rhs.openingDate))))&&((this.email == rhs.email)||((this.email!= null)&&this.email.equals(rhs.email))))&&((this.address == rhs.address)||((this.address!= null)&&this.address.equals(rhs.address))))&&((this.dimensionItem == rhs.dimensionItem)||((this.dimensionItem!= null)&&this.dimensionItem.equals(rhs.dimensionItem))))&&((this.memberCount == rhs.memberCount)||((this.memberCount!= null)&&this.memberCount.equals(rhs.memberCount))))&&((this.leaf == rhs.leaf)||((this.leaf!= null)&&this.leaf.equals(rhs.leaf))))&&((this.url == rhs.url)||((this.url!= null)&&this.url.equals(rhs.url))))&&((this.closedDate == rhs.closedDate)||((this.closedDate!= null)&&this.closedDate.equals(rhs.closedDate))))&&((this.legendSet == rhs.legendSet)||((this.legendSet!= null)&&this.legendSet.equals(rhs.legendSet))))&&((this.comment == rhs.comment)||((this.comment!= null)&&this.comment.equals(rhs.comment))))&&((this.geometry == rhs.geometry)||((this.geometry!= null)&&this.geometry.equals(rhs.geometry))))&&((this.user == rhs.user)||((this.user!= null)&&this.user.equals(rhs.user))));
    }

}
