
package org.hisp.dhis.api.model.v2_35_13;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "ownerOrgUnit",
    "program",
    "trackedEntityInstance"
})
@Generated("jsonschema2pojo")
public class ProgramOwner implements Serializable
{

    @JsonProperty("ownerOrgUnit")
    private String ownerOrgUnit;
    @JsonProperty("program")
    private String program;
    @JsonProperty("trackedEntityInstance")
    private String trackedEntityInstance;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -5617361264276180962L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ProgramOwner() {
    }

    /**
     * 
     * @param source
     */
    public ProgramOwner(ProgramOwner source) {
        super();
        this.ownerOrgUnit = source.ownerOrgUnit;
        this.program = source.program;
        this.trackedEntityInstance = source.trackedEntityInstance;
    }

    /**
     * 
     * @param ownerOrgUnit
     * @param program
     * @param trackedEntityInstance
     */
    public ProgramOwner(String ownerOrgUnit, String program, String trackedEntityInstance) {
        super();
        this.ownerOrgUnit = ownerOrgUnit;
        this.program = program;
        this.trackedEntityInstance = trackedEntityInstance;
    }

    @JsonProperty("ownerOrgUnit")
    public Optional<String> getOwnerOrgUnit() {
        return Optional.ofNullable(ownerOrgUnit);
    }

    @JsonProperty("ownerOrgUnit")
    public void setOwnerOrgUnit(String ownerOrgUnit) {
        this.ownerOrgUnit = ownerOrgUnit;
    }

    public ProgramOwner withOwnerOrgUnit(String ownerOrgUnit) {
        this.ownerOrgUnit = ownerOrgUnit;
        return this;
    }

    @JsonProperty("program")
    public Optional<String> getProgram() {
        return Optional.ofNullable(program);
    }

    @JsonProperty("program")
    public void setProgram(String program) {
        this.program = program;
    }

    public ProgramOwner withProgram(String program) {
        this.program = program;
        return this;
    }

    @JsonProperty("trackedEntityInstance")
    public Optional<String> getTrackedEntityInstance() {
        return Optional.ofNullable(trackedEntityInstance);
    }

    @JsonProperty("trackedEntityInstance")
    public void setTrackedEntityInstance(String trackedEntityInstance) {
        this.trackedEntityInstance = trackedEntityInstance;
    }

    public ProgramOwner withTrackedEntityInstance(String trackedEntityInstance) {
        this.trackedEntityInstance = trackedEntityInstance;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public ProgramOwner withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "ownerOrgUnit":
                if (value instanceof String) {
                    setOwnerOrgUnit(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"ownerOrgUnit\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "program":
                if (value instanceof String) {
                    setProgram(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"program\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "trackedEntityInstance":
                if (value instanceof String) {
                    setTrackedEntityInstance(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"trackedEntityInstance\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "ownerOrgUnit":
                return getOwnerOrgUnit();
            case "program":
                return getProgram();
            case "trackedEntityInstance":
                return getTrackedEntityInstance();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, ProgramOwner.NOT_FOUND_VALUE);
        if (ProgramOwner.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public ProgramOwner with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ProgramOwner.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("ownerOrgUnit");
        sb.append('=');
        sb.append(((this.ownerOrgUnit == null)?"<null>":this.ownerOrgUnit));
        sb.append(',');
        sb.append("program");
        sb.append('=');
        sb.append(((this.program == null)?"<null>":this.program));
        sb.append(',');
        sb.append("trackedEntityInstance");
        sb.append('=');
        sb.append(((this.trackedEntityInstance == null)?"<null>":this.trackedEntityInstance));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.program == null)? 0 :this.program.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.ownerOrgUnit == null)? 0 :this.ownerOrgUnit.hashCode()));
        result = ((result* 31)+((this.trackedEntityInstance == null)? 0 :this.trackedEntityInstance.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof ProgramOwner) == false) {
            return false;
        }
        ProgramOwner rhs = ((ProgramOwner) other);
        return (((((this.program == rhs.program)||((this.program!= null)&&this.program.equals(rhs.program)))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.ownerOrgUnit == rhs.ownerOrgUnit)||((this.ownerOrgUnit!= null)&&this.ownerOrgUnit.equals(rhs.ownerOrgUnit))))&&((this.trackedEntityInstance == rhs.trackedEntityInstance)||((this.trackedEntityInstance!= null)&&this.trackedEntityInstance.equals(rhs.trackedEntityInstance))));
    }

}
